/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.RolloverHandler;
import com.nokia.laf.text.NetCaret;
import com.nokia.laf.text.NetFieldView;
import com.nokia.laf.text.NetTextComponentHandler;
import com.nokia.laf.text.ReadOnlyKeymap;
import com.nokia.laf.util.NetUtils;
import com.nokia.laf.util.ReadOnlyHandler;
import com.nokia.widgets.text.status.ModifiedStatusHandler;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.View;

public class NetTextFieldUI
extends MetalTextFieldUI {
    protected NetTextComponentHandler myHandler;
    protected RolloverHandler myRolloverHandler;
    protected ModifiedStatusHandler myModifiedValueHandler = null;

    public static ComponentUI createUI(JComponent c) {
        return new NetTextFieldUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        NetUtils.installDefaultPopupMenu(this.getComponent());
        if (this.getComponent().getClientProperty("TextField.validateOnFocusLost") == null) {
            this.getComponent().putClientProperty("TextField.validateOnFocusLost", UIManager.get("TextField.validateOnFocusLost"));
        }
        this.getComponent().setOpaque(false);
        if (this.getComponent() != null) {
            this.setMargin(this.getComponent().getParent());
            this.myModifiedValueHandler = ModifiedStatusHandler.create(this.getComponent());
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (this.getComponent().getComponentPopupMenu() instanceof UIResource) {
            this.getComponent().setComponentPopupMenu(null);
        }
        if (this.myModifiedValueHandler != null) {
            this.myModifiedValueHandler.uninstallFrom(this.getComponent());
        }
    }

    @Override
    protected Keymap createKeymap() {
        Keymap keyMap = super.createKeymap();
        if (ComponentUtils.isReadOnly(this.getComponent())) {
            keyMap = new ReadOnlyKeymap(keyMap);
        }
        return keyMap;
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        NetUtils.installReadOnlyFocusInputMap(this.getComponent());
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.myHandler = new NetTextComponentHandler(this.getPropertyPrefix(), this.getComponent());
        this.myRolloverHandler = new RolloverHandler();
        this.myRolloverHandler.installTo(this.getComponent());
        ReadOnlyHandler.getInstance().installTo(this.getComponent());
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.myHandler.uninstallFrom(this.getComponent());
        this.myRolloverHandler.uninstallFrom(this.getComponent());
        ReadOnlyHandler.getInstance().uninstallFrom(this.getComponent());
    }

    @Override
    protected void paintSafely(Graphics g) {
        JTextComponent component = this.getComponent();
        this.paintBackground(g);
        Shape oldClip = g.getClip();
        NetUtils.setAntialiasing(g, RenderingHints.VALUE_ANTIALIAS_OFF);
        NetLookAndFeel.toggleTextAntialiasing(g);
        super.paintSafely(g);
        g.setClip(oldClip);
        NetUtils.paintLabelOrPrompt(g, component);
    }

    @Override
    protected Caret createCaret() {
        return new NetCaret.UIResource();
    }

    @Override
    public View create(Element elem) {
        Document doc = elem.getDocument();
        Object i18nFlag = doc.getProperty("i18n");
        if (Boolean.TRUE.equals(i18nFlag)) {
            return super.create(elem);
        }
        return new NetFieldView(elem);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("editable".equals(evt.getPropertyName()) || "enabled".equals(evt.getPropertyName())) {
            this.updateBackgroundAndForeground((JTextComponent)evt.getSource(), evt);
        } else if ("ancestor".equals(evt.getPropertyName()) && this.getComponent() != null) {
            if (this.getComponent().getParent() instanceof JTable) {
                this.getComponent().putClientProperty("JComponent.sizeVariant", "small");
            }
            this.setMargin(this.getComponent().getParent());
        }
    }

    private void setMargin(Container parent) {
        if (parent != null && NetUtils.lookAndFeelCanReplace(this.getComponent().getMargin()) && parent instanceof JTable) {
            this.getComponent().setMargin(UIManager.getInsets("TextField.tableMargin"));
            this.getComponent().repaint();
        }
    }

    private void updateBackgroundAndForeground(JTextComponent c, PropertyChangeEvent evt) {
        Color background = c.getBackground();
        if (background instanceof UIResource) {
            Color newBackground = null;
            Color newForeground = null;
            String prefix = this.getPropertyPrefix();
            if (!c.isEnabled()) {
                newBackground = UIManager.getColor(String.valueOf(prefix) + ".disabledBackground");
            }
            if (newBackground == null && !c.isEditable()) {
                newBackground = UIManager.getColor(String.valueOf(prefix) + ".inactiveBackground");
            }
            if (newBackground == null) {
                if (Boolean.TRUE.equals(evt.getNewValue()) && Boolean.TRUE.equals(c.getClientProperty("invalidEntry")) && !ClientPropertyUtil.booleanValue(c, "OrangeTouch.displayErrorIcon", true) && Boolean.FALSE.equals(c.getClientProperty("requiredButMissing"))) {
                    newBackground = UIManager.getColor(String.valueOf(prefix) + ".background");
                    newForeground = UIManager.getColor(String.valueOf(prefix) + ".invalidForeground");
                } else {
                    newBackground = UIManager.getColor(String.valueOf(prefix) + ".background");
                    newForeground = UIManager.getColor(String.valueOf(prefix) + ".foreground");
                }
            }
            if (newBackground != null && newBackground != background) {
                c.setBackground(newBackground);
            }
            if (newForeground != null && c.getForeground() instanceof UIResource && newForeground != c.getForeground()) {
                c.setForeground(newForeground);
            }
        }
    }

    @Override
    protected void paintBackground(Graphics g) {
        NetUtils.paintTextComponentBackground(g, this.getComponent());
    }
}

