/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.text.NetBasicCaret;
import com.nokia.laf.text.ReadOnlyKeymap;
import com.nokia.laf.util.NetUtils;
import com.nokia.laf.util.ReadOnlyHandler;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextPaneUI;
import javax.swing.text.Caret;
import javax.swing.text.Keymap;

public class NetTextPaneUI
extends BasicTextPaneUI {
    public static ComponentUI createUI(JComponent comp) {
        return new NetTextPaneUI();
    }

    @Override
    protected Caret createCaret() {
        return new NetBasicCaret.UIResource();
    }

    @Override
    protected void installDefaults() {
        JTextPane.registerEditorKitForContentType("text/html", "com.nokia.laf.text.NetHTMLEditorKit");
        super.installDefaults();
        NetUtils.installDefaultPopupMenu(this.getComponent());
        this.getComponent().putClientProperty("JEditorPane.honorDisplayProperties", true);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (this.getComponent().getComponentPopupMenu() instanceof UIResource) {
            this.getComponent().setComponentPopupMenu(null);
        }
    }

    @Override
    protected void paintSafely(Graphics g) {
        super.paintSafely(g);
        NetLookAndFeel.toggleTextAntialiasing(g);
    }

    @Override
    protected Keymap createKeymap() {
        Keymap keyMap = super.createKeymap();
        if (ComponentUtils.isReadOnly(this.getComponent())) {
            keyMap = new ReadOnlyKeymap(keyMap);
        }
        return keyMap;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        ReadOnlyHandler.getInstance().installTo(this.getComponent());
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        ReadOnlyHandler.getInstance().uninstallFrom(this.getComponent());
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        NetUtils.installReadOnlyFocusInputMap(this.getComponent());
    }
}

