/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.BasicNetButtonListener;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.ImageUtils;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalToggleButtonUI;

public class NetToggleButtonUI
extends MetalToggleButtonUI {
    private static final NetToggleButtonUI theToggleButtonUI = new NetToggleButtonUI();

    public static ComponentUI createUI(JComponent comp) {
        return theToggleButtonUI;
    }

    @Override
    public void installDefaults(AbstractButton btn) {
        super.installDefaults(btn);
        NetUtils.setCursor(btn);
        btn.setRolloverEnabled(true);
        btn.setOpaque(false);
        if (Boolean.TRUE.equals(btn.getClientProperty("toolButton"))) {
            LookAndFeel.installBorder(btn, String.valueOf(this.getPropertyPrefix()) + "toolBorder");
            btn.setFocusable(false);
        }
        NetUtils.setMarginAndFont(btn, this.getPropertyPrefix());
        this.setTabButtonMargin(btn);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        AbstractButton btn = (AbstractButton)c;
        ButtonModel model = btn.getModel();
        if (model.isRollover() && !model.isPressed() && btn.getClientProperty("BlueTouch.rolloverHighlightDisabled") == null) {
            this.paintRolloverHighlight(btn, g);
        }
    }

    @Override
    protected void paintIcon(Graphics g, AbstractButton b, Rectangle iconRect) {
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        if (icon != null && b.isFocusOwner() && b.isFocusPainted() && !model.isSelected() && !model.isPressed() && SystemUtils.isFocusedIconAutoCreated()) {
            ImageIcon focusedIcon = ImageUtils.createFocusedIcon(b, icon);
            focusedIcon.paintIcon(b, g, iconRect.x, iconRect.y);
            return;
        }
        super.paintIcon(g, b, iconRect);
    }

    protected void paintRolloverHighlight(AbstractButton btn, Graphics g) {
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton btn, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    protected void drawRolloverHighlight(AbstractButton btn, Graphics g) {
        ButtonModel model = btn.getModel();
        if (model.isRollover() && !model.isPressed()) {
            int width = btn.getWidth();
            int height = btn.getHeight();
            if (model.isSelected()) {
                NetUtils.drawRollover(g, 2, 2, width - 4, height - 4);
            } else {
                NetUtils.drawRollover(g, 1, 1, width - 2, height - 2);
            }
            if (btn.hasFocus() && btn.isFocusPainted()) {
                int offset = model.isSelected() ? 1 : 0;
                NetUtils.drawDash(g, 2 + offset, 2 + offset, width - 4 - 2 * offset, height - 4 - 2 * offset);
            }
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent button) {
        AbstractButton b = (AbstractButton)button;
        return NetUtils.getPreferredButtonSize(b, b.getIconTextGap());
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension size = super.getMaximumSize(c);
        AbstractButton b = (AbstractButton)c;
        if ((ClientPropertyUtil.booleanValue(c, "toolButton") || c.getParent() instanceof JToolBar) && b.getBorder() instanceof UIResource) {
            Insets insets = b.getInsets();
            int minimumMaxSize = 16 + insets.top + insets.bottom;
            if (size.height < minimumMaxSize) {
                size.height = minimumMaxSize;
            }
        }
        return size;
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton btn) {
        if (btn.isContentAreaFilled()) {
            String gradientKey = "ToggleButton.pressedGradient";
            Object type = btn.getClientProperty("OrangeTouch.visualVariant");
            if ("alternate1".equals(type)) {
                gradientKey = btn.isEnabled() ? "ToggleButton.alternate1PressedGradient" : "ToggleButton.disabledAlternate1PressedGradient";
            } else if ("alternate2".equals(type)) {
                gradientKey = btn.isEnabled() ? "ToggleButton.alternate2PressedGradient" : "ToggleButton.disabledAlternate2PressedGradient";
            }
            int x = 0;
            int y = 0;
            int width = btn.getWidth();
            Object position = btn.getClientProperty("JToggleButton.segmentPosition");
            boolean isHorizontal = ClientPropertyUtil.integerValue(btn, "OceanTouch.segmentOrientation", 0) == 0;
            int height = btn.getHeight();
            if (isHorizontal) {
                if ("first".equals(position)) {
                    width += 1000;
                } else if ("middle".equals(position)) {
                    x -= 1000;
                    width += 2000;
                } else if ("last".equals(position)) {
                    x -= 1000;
                    width += 1000;
                }
            } else if ("first".equals(position)) {
                height += 10;
            } else if ("middle".equals(position)) {
                y -= 10;
                height += 20;
            } else if ("last".equals(position)) {
                y -= 10;
                height += 10;
            }
            GradientUtils.drawVerticalGradient((JComponent)btn, g, gradientKey, NetUtils.getButtonOutline(btn, x, y, width, height));
        } else {
            super.paintButtonPressed(g, btn);
        }
        this.setTextShiftOffset();
    }

    @Override
    protected void paintText(Graphics g, JComponent comp, Rectangle textRect, String text) {
        AbstractButton button = (AbstractButton)comp;
        ButtonModel model = button.getModel();
        Object type = button.getClientProperty("OrangeTouch.visualVariant");
        boolean isPressed = model.isPressed() && model.isArmed();
        boolean isSelected = model.isSelected();
        boolean isHover = model.isRollover();
        boolean isFocus = button.isFocusOwner() && button.isFocusPainted();
        boolean isAlternate = "alternate1".equals(type) || "alternate2".equals(type);
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = button.getDisplayedMnemonicIndex();
        Color textColor = button.getForeground();
        Color offsetColor = NetTheme.getTextShadowColor();
        int offset = 1;
        if (isPressed || isSelected) {
            if (isAlternate) {
                offsetColor = button.getForeground();
                textColor = NetTheme.COLOR_WHITE_20;
                offset = 0;
            }
        } else if (isFocus) {
            offsetColor = button.getForeground();
            textColor = NetTheme.COLOR_WHITE_20;
            offset = 0;
        } else if (isHover) {
            textColor = NetTheme.getTextHoverColor();
        }
        if (model.isEnabled() && !ComponentUtils.isReadOnly(comp)) {
            g.setColor(button.getForeground());
            NetUtils.paintText(g, text, mnemIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset(), textColor, offsetColor, offset);
        } else {
            textColor = this.getDisabledTextColor();
            NetUtils.paintText(g, text, mnemIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset(), textColor, null, offset);
        }
    }

    @Override
    public void update(Graphics g, JComponent comp) {
        boolean isToolButton;
        NetLookAndFeel.toggleTextAntialiasing(g);
        AbstractButton btn = (AbstractButton)comp;
        ButtonModel model = btn.getModel();
        Color background = btn.getBackground();
        boolean isSelected = model.isSelected();
        boolean isHover = model.isRollover();
        boolean isFocus = btn.isFocusOwner() && btn.isFocusPainted();
        boolean bl = isToolButton = Boolean.TRUE.equals(btn.getClientProperty("toolButton")) || btn.getParent() instanceof JToolBar;
        if (background instanceof UIResource) {
            Color oldColor = g.getColor();
            if (isToolButton) {
                if (isHover && btn.isContentAreaFilled()) {
                    GradientUtils.drawVerticalGradient(comp, g, "ToggleButton.gradient", NetUtils.getButtonOutlineForFill(comp));
                }
            } else {
                int x = 0;
                int y = 0;
                int width = btn.getWidth();
                int height = comp.getHeight();
                Object position = btn.getClientProperty("JToggleButton.segmentPosition");
                boolean isHorizontal = ClientPropertyUtil.integerValue(btn, "OceanTouch.segmentOrientation", 0) == 0;
                boolean first = "first".equals(position);
                boolean middle = "middle".equals(position);
                boolean last = "last".equals(position);
                if (isHorizontal) {
                    if (first) {
                        width += 1000;
                    } else if (middle) {
                        x -= 1000;
                        width += 2000;
                    } else if (last) {
                        x -= 1000;
                        width += 1000;
                    }
                } else if (first) {
                    height += 10;
                } else if (middle) {
                    y -= 10;
                    height += 20;
                } else if (last) {
                    y -= 10;
                    height += 10;
                }
                String gradient = NetToggleButtonUI.getBackgroundGradientKey(btn, isSelected, isFocus);
                GradientUtils.drawVerticalGradient(comp, g, gradient, NetUtils.getButtonOutlineForFill(comp, x, y, width, height));
            }
            this.paint(g, comp);
            g.setColor(oldColor);
        } else {
            super.update(g, btn);
        }
    }

    public static String getBackgroundGradientKey(AbstractButton btn, boolean isSelected, boolean isFocus) {
        if (!btn.isEnabled()) {
            return "ToggleButton.disabledButtonGradient";
        }
        if (isFocus) {
            return btn.getModel().isRollover() ? "Button.nsnDefaultButtonRolloverGradient" : "ToggleButton.focusButtonGradient";
        }
        if (isSelected) {
            return "ToggleButton.pressedGradient";
        }
        return "ToggleButton.gradient";
    }

    private void setTabButtonMargin(AbstractButton button) {
        if (NetUtils.lookAndFeelCanReplace(button.getMargin())) {
            Object position = button.getClientProperty("JToggleButton.segmentPosition");
            if (position != null) {
                boolean small = ComponentUtils.isSmall(button);
                Insets insets = small ? UIManager.getInsets("ToggleButton.tabbutton.smallmargin") : UIManager.getInsets("ToggleButton.tabbutton.margin");
                InsetsUIResource margin = new InsetsUIResource(insets.top, insets.left, insets.bottom, insets.right);
                if ("last".equals(position)) {
                    margin.left = margin.left - (small ? 0 : 4);
                    margin.right = margin.right + (small ? 3 : 6);
                } else if ("middle".equals(position)) {
                    margin.left = margin.left - (small ? 0 : 4);
                } else if ("first".equals(position)) {
                    margin.left = margin.left + (small ? 1 : 0);
                }
                button.setMargin(margin);
            }
            if (button.getText() == null || "".equals(button.getText())) {
                Insets iconMargin = ComponentUtils.isSmall(button) ? UIManager.getInsets("ToggleButton.tabbutton.smallIconOnlyMargin") : UIManager.getInsets("ToggleButton.tabbutton.iconOnlyMargin");
                Insets insets = iconMargin = iconMargin != null ? new InsetsUIResource(iconMargin.top, iconMargin.left, iconMargin.bottom, iconMargin.right) : new InsetsUIResource(0, 0, 0, 0);
                if ("last".equals(position)) {
                    iconMargin.left -= 2;
                    ++iconMargin.right;
                } else if ("middle".equals(position)) {
                    iconMargin.left -= 2;
                    iconMargin.right -= 3;
                } else if ("first".equals(position)) {
                    iconMargin.right -= 3;
                    ++iconMargin.left;
                }
                button.setMargin(iconMargin);
            }
            button.revalidate();
            button.repaint();
        }
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton btn) {
        return new BasicToggleButtonListener(btn, this.getPropertyPrefix());
    }

    protected class BasicToggleButtonListener
    extends BasicNetButtonListener {
        public BasicToggleButtonListener(AbstractButton btn, String propertyPrefix) {
            super(btn, propertyPrefix);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            super.propertyChange(event);
            JComponent source = (JComponent)event.getSource();
            String propertyName = event.getPropertyName();
            if (("JToggleButton.segmentPosition".equals(propertyName) || "JComponent.sizeVariant".equals(propertyName)) && source instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)source;
                NetToggleButtonUI.this.setTabButtonMargin(button);
            } else if (("icon".equals(propertyName) || "text".equalsIgnoreCase(propertyName)) && source instanceof AbstractButton) {
                NetUtils.setMarginAndFont((AbstractButton)source, NetToggleButtonUI.this.getPropertyPrefix());
            }
        }
    }
}

