/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarSeparatorUI;

public class NetToolBarSeparatorUI
extends BasicToolBarSeparatorUI
implements PropertyChangeListener {
    public static ComponentUI createUI(JComponent separator) {
        return new NetToolBarSeparatorUI();
    }

    @Override
    protected void installListeners(JSeparator s) {
        super.installListeners(s);
        s.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JSeparator s) {
        super.uninstallListeners(s);
        s.removePropertyChangeListener(this);
    }

    @Override
    protected void installDefaults(JSeparator s) {
        this.updateSeparatorSize(s);
    }

    private void updateSeparatorSize(JSeparator s) {
        Dimension size = ((JToolBar.Separator)s).getSeparatorSize();
        if (size == null || size instanceof UIResource) {
            JToolBar.Separator sep = (JToolBar.Separator)s;
            size = (Dimension)UIManager.get("ToolBar.separatorSize");
            if (size != null) {
                if (sep.getOrientation() == 1) {
                    size = new DimensionUIResource(size.height, size.width);
                }
                sep.setSeparatorSize(size);
            }
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (!(c instanceof JSeparator)) {
            return;
        }
        JSeparator separator = (JSeparator)c;
        Color oldColor = g.getColor();
        g.setColor(NetTheme.getComponentOutlineColor());
        Insets insets = c.getInsets();
        if (separator.getOrientation() == 1) {
            int x = c.getWidth() / 2;
            int y = insets.top;
            g.drawLine(x, y, x, c.getHeight() - insets.bottom);
            g.setColor(NetLookAndFeel.getWhite());
            g.drawLine(x + 1, y, x + 1, c.getHeight() - insets.bottom);
        } else if (separator.getOrientation() == 0) {
            int y = c.getHeight() / 2;
            int x = insets.left;
            g.drawLine(x, y, c.getWidth() - insets.right, y);
        }
        g.setColor(oldColor);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("orientation".equals(evt.getPropertyName())) {
            this.updateSeparatorSize((JSeparator)evt.getSource());
        }
    }
}

