/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.toolbar.OverflowButton;
import com.nokia.laf.util.GradientUtils;
import com.nokia.widgets.PMenuBar;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalToolBarUI;

public class NetToolBarUI
extends MetalToolBarUI {
    private boolean myInstallingComponents = false;
    private static ContainerListener theButtonHandler;

    public static ComponentUI createUI(JComponent comp) {
        return new NetToolBarUI();
    }

    @Override
    protected void installDefaults() {
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.setRolloverBorders(true);
        super.installDefaults();
        this.configureChildren(this.toolBar);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (!(c.getParent() instanceof PMenuBar)) {
            Color background = c.getBackground();
            if (background == null || background instanceof UIResource) {
                if (c.isOpaque()) {
                    GradientUtils.drawVerticalBackgroundGradient(c, g);
                }
                this.paint(g, c);
            } else {
                super.update(g, c);
            }
            return;
        }
        super.update(g, c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
    }

    @Override
    protected ContainerListener createContainerListener() {
        if (theButtonHandler == null) {
            theButtonHandler = new ButtonHandler();
        }
        return theButtonHandler;
    }

    private void configureChildren(Container parent) {
        Component[] children = parent.getComponents();
        int i = 0;
        while (i < children.length) {
            if (!this.configureComponent(children[i]) && children[i] instanceof Container) {
                this.configureChildren((Container)children[i]);
            }
            ++i;
        }
    }

    private boolean configureComponent(Component comp) {
        if ((comp instanceof JButton || comp instanceof JToggleButton) && !ClientPropertyUtil.booleanValue((JComponent)comp, "OrangeTouch.roundedOutline")) {
            ((JComponent)comp).putClientProperty("toolButton", Boolean.TRUE);
            ((JComponent)comp).updateUI();
            return true;
        }
        return false;
    }

    @Override
    protected void setBorderToRollover(Component comp) {
        if (comp instanceof AbstractButton) {
            super.setBorderToRollover(comp);
        } else if (comp instanceof Container) {
            Container cont = (Container)comp;
            int idx = 0;
            while (idx < cont.getComponentCount()) {
                super.setBorderToRollover(cont.getComponent(idx));
                ++idx;
            }
        }
    }

    @Override
    protected Border createRolloverBorder() {
        return UIManager.getBorder("Button.toolBorder");
    }

    private class ButtonHandler
    extends ContainerAdapter {
        private ButtonHandler() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            if (!NetToolBarUI.this.myInstallingComponents && e.getChild() instanceof OverflowButton) {
                NetToolBarUI.this.toolBar.remove(e.getChild());
            }
            NetToolBarUI.this.configureComponent(e.getChild());
        }
    }
}

