/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTabbedPaneUI;
import com.nokia.laf.util.NetUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.metal.MetalToolTipUI;
import javax.swing.table.JTableHeader;
import javax.swing.text.View;

public class NetToolTipUI
extends MetalToolTipUI {
    private static NetToolTipUI theInstance = new NetToolTipUI();
    private String acceleratorDelim;
    private Color myAccessKeyColor;
    private PropertyChangeListener myPropertyChangeListener = new PropertyChangeHandler();

    public static ComponentUI createUI(JComponent c) {
        return theInstance;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.acceleratorDelim = UIManager.getString("MenuItem.acceleratorDelimiter");
        this.myAccessKeyColor = UIManager.getColor("ToolTip.accessForeground");
        c.setOpaque(false);
    }

    @Override
    protected void installListeners(JComponent c) {
        super.installListeners(c);
        c.addPropertyChangeListener(this.myPropertyChangeListener);
    }

    @Override
    protected void uninstallListeners(JComponent c) {
        super.uninstallListeners(c);
        c.removePropertyChangeListener(this.myPropertyChangeListener);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        g.setColor(c.getBackground());
        Insets insets = new Insets(1, 3, 4, 3);
        g.fillRoundRect(insets.left, insets.top, c.getWidth() - (insets.right + insets.left) - 1, c.getHeight() - (insets.top + insets.bottom), 6, 6);
        super.update(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        NetLookAndFeel.toggleTextAntialiasing(g);
        Font font = c.getFont();
        Dimension size = c.getSize();
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        g.setColor(c.getForeground());
        g.setFont(font);
        FontMetrics metrics = g.getFontMetrics();
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            tipText = "";
        }
        Insets insets = c.getInsets();
        Rectangle paintTextR = new Rectangle(insets.left, insets.top, size.width - (insets.left + insets.right), size.height - (insets.top + insets.bottom));
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            v.paint(g, paintTextR);
        } else {
            g.drawString(tipText, paintTextR.x, paintTextR.y + metrics.getAscent());
        }
        JToolTip tip = (JToolTip)c;
        String keyText = this.getAcceleratorString(tip);
        if (!"".equals(keyText)) {
            g.setColor(this.myAccessKeyColor);
            g.drawString(keyText, paintTextR.x + paintTextR.width - metrics.stringWidth(keyText), paintTextR.y + metrics.getAscent());
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        String key = this.getAcceleratorString((JToolTip)c);
        if (!"".equals(key)) {
            d.width += this.calcAccelSpacing(c.getFontMetrics(c.getFont()), key);
        }
        return d;
    }

    private int calcAccelSpacing(FontMetrics fm, String accel) {
        return "".equals(accel) ? 0 : 6 + fm.stringWidth(accel);
    }

    public String getAcceleratorString(JToolTip tip) {
        if (tip == null || this.isAcceleratorHidden() || tip.getComponent() instanceof JTableHeader) {
            return "";
        }
        JComponent comp = tip.getComponent();
        if (comp == null) {
            return "";
        }
        String tipText = comp.getToolTipText();
        String tooltipText = tip.getTipText();
        if (tipText == null && tooltipText != null) {
            return "";
        }
        if (tipText != null && !tipText.equals(tooltipText)) {
            return "";
        }
        KeyStroke[] keys = this.getKeyStrokes(comp);
        String controlKeyStr = "";
        int i = 0;
        while (i < keys.length) {
            int mod = keys[i].getModifiers();
            int condition = comp.getConditionForKeyStroke(keys[i]);
            if (condition == 2) {
                if ((mod & 8) != 0) break;
                if (this.isModifierOn(mod)) {
                    controlKeyStr = String.valueOf(KeyEvent.getKeyModifiersText(mod)) + this.acceleratorDelim + KeyEvent.getKeyText(keys[i].getKeyCode());
                    break;
                }
                controlKeyStr = KeyEvent.getKeyText(keys[i].getKeyCode());
            }
            ++i;
        }
        return controlKeyStr;
    }

    private KeyStroke[] getKeyStrokes(JComponent comp) {
        if (comp instanceof JTabbedPane) {
            return this.getKeyStrokesForTabbedPane(comp);
        }
        return comp.getRegisteredKeyStrokes();
    }

    private boolean isModifierOn(int mod) {
        return (mod & 2) != 0 || (mod & 1) != 0 || (mod & 4) != 0;
    }

    private KeyStroke[] getKeyStrokesForTabbedPane(JComponent comp) {
        KeyStroke[] keys;
        TabbedPaneUI ui = ((JTabbedPane)comp).getUI();
        if (ui instanceof NetTabbedPaneUI) {
            int rolloverTabIndex = ((NetTabbedPaneUI)ui).getRolloverIndex();
            if (rolloverTabIndex == -1) {
                keys = new KeyStroke[]{};
            } else {
                int mnemonic = ((JTabbedPane)comp).getMnemonicAt(rolloverTabIndex);
                if (mnemonic == -1) {
                    keys = new KeyStroke[]{};
                } else {
                    KeyStroke keyStroke = KeyStroke.getKeyStroke(mnemonic, 8);
                    keys = new KeyStroke[]{keyStroke};
                }
            }
        } else {
            keys = comp.getRegisteredKeyStrokes();
        }
        return keys;
    }

    private static class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JToolTip tip;
            Window window;
            if ("ancestor".equals(evt.getPropertyName()) && evt.getNewValue() != null && (window = SwingUtilities.getWindowAncestor(tip = (JToolTip)evt.getSource())) != null && window.getName() != null && window.getClass().getName().contains("Popup$HeavyWeightWindow")) {
                NetUtils.setTransparent(window);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tip.repaint();
                    }
                });
            }
        }
    }
}

