/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.labels.highlight.LabelHighlighter;
import com.nokia.widgets.tree.PDefaultTreeCellRenderer;
import com.nokia.widgets.tree.TreeHighlight;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.NSNColors;
import com.nokia.widgets.util.ScaleUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class NetTreeUI
extends MetalTreeUI {
    protected MouseInputAdapter myRolloverHandler = new RolloverHandler();
    protected FocusListener mySelectionHandler = new SelectionHandler();
    protected PropertyChangeListener myPropertyHandler = new PropertyHandler();
    private Stroke myExpandedNodeLineStroke = new BasicStroke(1.0f, 0, 1, 0.0f, new float[]{1.0f, 2.0f}, 1.0f);
    private boolean myIsMousePressed = false;
    public TreeSelectionListener myTreeSelectionHandler = new TreeSelectionHandler();

    public static ComponentUI createUI(JComponent c) {
        return new NetTreeUI();
    }

    @Override
    protected TreeCellRenderer createDefaultCellRenderer() {
        return new PDefaultTreeCellRenderer();
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MouseListenerDelegate(super.createMouseListener());
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        LookAndFeel.installBorder(this.tree, "Tree.border");
        int rowHeight = ScaleUtils.scale(ComponentUtils.isSmall(this.tree) ? UIManager.getInt("Tree.smallRowHeight") : UIManager.getInt("Tree.rowHeight"));
        this.tree.setRowHeight(rowHeight);
        this.tree.putClientProperty("BlueTouch.rolloveredCell", new Point(-1, -1));
        this.tree.setShowsRootHandles(true);
        this.tree.setExpandsSelectedPaths(true);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tree.addMouseListener(this.myRolloverHandler);
        this.tree.addMouseMotionListener(this.myRolloverHandler);
        this.tree.addFocusListener(this.mySelectionHandler);
        this.tree.addPropertyChangeListener(this.myPropertyHandler);
        this.tree.addTreeSelectionListener(this.myTreeSelectionHandler);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tree.removeMouseListener(this.myRolloverHandler);
        this.tree.removeMouseMotionListener(this.myRolloverHandler);
        this.tree.removeFocusListener(this.mySelectionHandler);
        this.tree.removePropertyChangeListener(this.myPropertyHandler);
        this.tree.removeTreeSelectionListener(this.myTreeSelectionHandler);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paintAlternateBackground(g);
        if (!Boolean.TRUE.equals(this.tree.getClientProperty("OrangeTouch.hideTreeNodeSelectionBorder"))) {
            this.paintBackgroundForSelection(g);
        }
        this.paint(g, c);
    }

    @Override
    public Rectangle getPathBounds(JTree jTree, TreePath path) {
        Rectangle result = super.getPathBounds(jTree, path);
        boolean wholeRowActive = ClientPropertyUtil.booleanValue(jTree, "OrangeTouch.wholeRowActiveInTree", true);
        if (!this.myIsMousePressed || !wholeRowActive) {
            return result;
        }
        if (result != null) {
            if (this.treeModel.isLeaf(path.getLastPathComponent())) {
                result.x = 0;
            }
            result.width = jTree.getWidth() - result.x;
        }
        return result;
    }

    private void paintAlternateBackground(Graphics g) {
        if (ClientPropertyUtil.booleanValue(this.tree, "OrangeTouch.alternate")) {
            Rectangle clipBounds = g.getClipBounds();
            int beginRow = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, clipBounds.y));
            int endRow = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, clipBounds.y + clipBounds.height - 1));
            if (beginRow <= -1 || endRow <= -1) {
                return;
            }
            int row = beginRow;
            while (row <= endRow) {
                Rectangle rowBounds;
                TreePath path = this.getPathForRow(this.tree, row);
                if (path != null && (rowBounds = this.tree.getRowBounds(row)) != null) {
                    Color background = row % 2 == 0 ? UIManager.getColor("Tree.evenRowBackground") : UIManager.getColor("Tree.oddRowBackground");
                    g.setColor(background);
                    g.fillRect(0, rowBounds.y, this.tree.getWidth(), rowBounds.height);
                }
                ++row;
            }
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.treeState != null && Boolean.TRUE.equals(c.getClientProperty("OrangeTouch.refreshTreeLayoutOnPaint"))) {
            this.treeState.invalidateSizes();
        }
        if (this.tree != null && this.tree.getRowCount() <= 0) {
            NetUtils.paintEmptyText(g, this.tree, this.getEmptyText());
        }
        super.paint(g, c);
    }

    protected String getEmptyText() {
        Object emptyText = this.tree.getClientProperty("OrangeTouch.emptyText");
        if (emptyText == null) {
            emptyText = UIManager.get("Tree.defaultEmptyText");
        }
        return emptyText == null ? null : emptyText.toString();
    }

    protected void paintBackgroundForSelection(Graphics g) {
        Rectangle rowBounds;
        int[] selected = this.tree.getSelectionRows();
        int leadIndex = this.getLeadSelection();
        if (leadIndex < 0) {
            leadIndex = 0;
        }
        if (selected != null) {
            int[] nArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                int selectedRow = nArray[n2];
                Rectangle rowBounds2 = this.tree.getRowBounds(selectedRow);
                if (rowBounds2 != null) {
                    Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, this.tree.getPathForRow(selectedRow).getLastPathComponent(), this.tree.isRowSelected(selectedRow), false, false, selectedRow, leadIndex == selectedRow);
                    Color background = component.getBackground();
                    if (background == null) {
                        g.setColor(NetTheme.getSelectionColor());
                    } else {
                        g.setColor(background);
                    }
                    g.fillRect(0, rowBounds2.y, this.tree.getWidth(), rowBounds2.height);
                }
                ++n2;
            }
        }
        if (leadIndex >= 0 && this.tree.isFocusOwner() && (rowBounds = this.tree.getRowBounds(leadIndex)) != null) {
            g.setColor(NetLookAndFeel.getCurrentTheme().getFocusColor());
            g.drawRect(0, rowBounds.y, this.tree.getWidth() - 1, rowBounds.height - 1);
        }
    }

    @Override
    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.editingComponent != null && this.editingRow == row) {
            return;
        }
        int leadIndex = this.getLeadSelection();
        if (this.tree.isFocusOwner() && leadIndex < 0) {
            leadIndex = 0;
        }
        String text = (String)this.tree.getClientProperty("OrangeTouch.highlightText");
        boolean selected = this.tree.isRowSelected(row);
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), selected, isExpanded, isLeaf, row, leadIndex == row);
        this.prepareRenderer(component, row, selected);
        int hoverOffset = 0;
        if (component instanceof JComponent) {
            JComponent jComp = (JComponent)component;
            jComp.putClientProperty("OrangeTouch.isSelected", selected);
            hoverOffset = ClientPropertyUtil.integerValue(jComp, "OceanTouch.hoverXOffset", 4);
        }
        JLabel renderer = this.highlightRenderer(path, null, text, component);
        boolean rollovered = false;
        Point rolloveredRow = (Point)this.tree.getClientProperty("BlueTouch.rolloveredCell");
        if (rolloveredRow != null) {
            rollovered = row == (int)rolloveredRow.getX() && this.tree.isEnabled();
        }
        this.rendererPane.paintComponent(g, component, this.tree, bounds.x, bounds.y, bounds.width, bounds.height, true);
        if (rollovered && !selected && ClientPropertyUtil.booleanValue(this.tree, "OrangeTouch.paintHoverFrame", true)) {
            Rectangle textRect = new Rectangle(bounds.x + hoverOffset, bounds.y, component.getPreferredSize().width - hoverOffset - 1, bounds.height - 2);
            NetUtils.paintHoverEffect(g, component, 1, bounds.y, this.tree.getWidth() - 3, bounds.height - 1, textRect);
        }
        if (leadIndex == row && this.tree.isFocusOwner() && !Boolean.TRUE.equals(this.tree.getClientProperty("OrangeTouch.hideTreeNodeSelectionBorder"))) {
            this.paintFocus(g, bounds);
        }
        if (!Boolean.TRUE.equals(this.tree.getClientProperty("OrangeTouch.hideTreeNodeDashedSeparator"))) {
            this.paintExpandedNodeLine((Graphics2D)g, bounds, path, row);
        }
        if (renderer != null) {
            this.clearHighlights(renderer);
        }
    }

    protected void prepareRenderer(Component component, int row, boolean selected) {
        if (ClientPropertyUtil.booleanValue(this.tree, "OrangeTouch.alternate") && !selected) {
            Color alternateBackground = row % 2 == 0 ? UIManager.getColor("Tree.evenRowBackground") : UIManager.getColor("Tree.oddRowBackground");
            component.setBackground(alternateBackground);
        }
    }

    protected JLabel highlightRenderer(TreePath path, JLabel renderer, String text, Component component) {
        if (text == null || text.isEmpty()) {
            return renderer;
        }
        JLabel tempRenderer = renderer;
        if (component instanceof JLabel) {
            tempRenderer = (JLabel)component;
            String rendererText = tempRenderer.getText();
            if (rendererText != null) {
                String[] searchHits;
                String[] stringArray = searchHits = text.split("\\#\\$");
                int n = searchHits.length;
                int n2 = 0;
                while (n2 < n) {
                    String searchHit = stringArray[n2];
                    this.highlight(tempRenderer, searchHit, false);
                    TreeHighlight singleHighlight = (TreeHighlight)this.tree.getClientProperty("OrangeTouch.treeEmphasizedHighlight");
                    if (singleHighlight != null && path.equals(singleHighlight.getPath()) && rendererText.toLowerCase().contains(searchHit.toLowerCase())) {
                        this.singleHighlight(tempRenderer, singleHighlight);
                    }
                    ++n2;
                }
            }
        } else {
            this.highlightChildComponent(path, tempRenderer, text, component);
        }
        return tempRenderer;
    }

    protected JLabel highlightChildComponent(TreePath path, JLabel renderer, String text, Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            Component[] componentArray = container.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component childComponent = componentArray[n2];
                if (childComponent instanceof JLabel) {
                    this.highlightRenderer(path, renderer, text, childComponent);
                } else if (childComponent instanceof Container) {
                    this.highlightChildComponent(path, renderer, text, childComponent);
                }
                ++n2;
            }
        }
        return renderer;
    }

    private void paintFocus(Graphics g, Rectangle bounds) {
        g.setColor(NetLookAndFeel.getCurrentTheme().getFocusColor());
        g.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y);
        g.drawLine(bounds.x, bounds.y + bounds.height - 1, bounds.x + bounds.width, bounds.y + bounds.height - 1);
    }

    protected int getLeadSelection() {
        if (this.tree.isFocusOwner()) {
            return this.getRowForPath(this.tree, this.tree.getLeadSelectionPath());
        }
        return -1;
    }

    private void paintExpandedNodeLine(Graphics2D g, Rectangle bounds, TreePath path, int row) {
        TreePath parentPath = path.getParentPath();
        if (parentPath != null) {
            int endRow = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, this.tree.getHeight()));
            TreePath pathOfLastChild = this.getLastChildPath(parentPath);
            if (row != endRow && !this.tree.isExpanded(row) && pathOfLastChild != null && pathOfLastChild.equals(path)) {
                Color oldColor = g.getColor();
                Stroke oldStroke = g.getStroke();
                g.setColor(UIManager.getColor("Tree.dividerColor"));
                g.setStroke(this.myExpandedNodeLineStroke);
                g.drawLine(0, bounds.y + bounds.height - 1, this.tree.getWidth() - 1, bounds.y + bounds.height - 1);
                g.setColor(oldColor);
                g.setStroke(oldStroke);
            }
        }
    }

    protected void singleHighlight(JLabel label, TreeHighlight singleHighlight) {
        this.addHighlight(label, singleHighlight.getIndex(), singleHighlight.getIndex() + singleHighlight.getText().length(), NSNColors.getPurple());
    }

    public void highlight(JLabel label, String text) {
        this.highlight(label, text, true);
    }

    private void highlight(JLabel label, String text, boolean clearPrevious) {
        String tempText = text;
        String lowerCaseText = label.getText().toLowerCase();
        if (tempText == null || lowerCaseText.indexOf(tempText.toLowerCase()) < 0) {
            if (clearPrevious) {
                this.clearHighlights(label);
            }
            return;
        }
        tempText = tempText.toLowerCase();
        Pattern p = Pattern.compile(tempText.replaceAll("(\\p{Punct})", "\\\\$1"));
        Matcher m = p.matcher(lowerCaseText);
        while (m.find()) {
            this.addHighlight(label, m.start(), m.end(), NSNColors.getGreen());
        }
    }

    public void addHighlight(JLabel label, int start, int end, Color color) {
        NetUtils.addHighlight(label, start, end, color);
    }

    public void clearHighlights(JLabel label) {
        LabelHighlighter highlighter = (LabelHighlighter)label.getClientProperty("OrangeTouch.highlighter");
        if (highlighter != null) {
            highlighter.removeAllHighlights();
        }
    }

    private class MouseListenerDelegate
    implements MouseListener {
        MouseListener myDelegate;

        public MouseListenerDelegate(MouseListener delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.myDelegate.mouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            NetTreeUI.this.myIsMousePressed = true;
            this.myDelegate.mousePressed(e);
            NetTreeUI.this.myIsMousePressed = false;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.myDelegate.mouseReleased(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.myDelegate.mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.myDelegate.mouseExited(e);
        }
    }

    private class PropertyHandler
    implements PropertyChangeListener {
        private PropertyHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("JComponent.sizeVariant".equals(propertyName)) {
                int rowHeight = ScaleUtils.scale(ComponentUtils.isSmall(NetTreeUI.this.tree) ? UIManager.getInt("Tree.smallRowHeight") : UIManager.getInt("Tree.rowHeight"));
                NetTreeUI.this.tree.setRowHeight(rowHeight);
                NetTreeUI.this.tree.revalidate();
                NetTreeUI.this.tree.repaint();
            } else if ("ancestor".equals(evt.getPropertyName()) && evt.getNewValue() == null && NetTreeUI.this.tree != null) {
                Point point = (Point)NetTreeUI.this.tree.getClientProperty("BlueTouch.rolloveredCell");
                if (point != null) {
                    point.move(-1, -1);
                }
            } else if ("selectionModel".equals(evt.getPropertyName())) {
                Object newValue;
                Object oldValue = evt.getOldValue();
                if (oldValue instanceof TreeSelectionModel) {
                    ((TreeSelectionModel)oldValue).removeTreeSelectionListener(NetTreeUI.this.myTreeSelectionHandler);
                }
                if ((newValue = evt.getNewValue()) instanceof TreeSelectionModel) {
                    ((TreeSelectionModel)newValue).addTreeSelectionListener(NetTreeUI.this.myTreeSelectionHandler);
                }
            }
        }
    }

    private class RolloverHandler
    extends MouseInputAdapter {
        private RolloverHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Point point = (Point)NetTreeUI.this.tree.getClientProperty("BlueTouch.rolloveredCell");
            Point oldPoint = (Point)point.clone();
            point.move(-1, -1);
            int oldRow = (int)oldPoint.getX();
            Rectangle rowBounds = NetTreeUI.this.tree.getRowBounds(oldRow);
            if (rowBounds != null) {
                rowBounds.x = 0;
                rowBounds.width = NetTreeUI.this.tree.getWidth();
                NetTreeUI.this.tree.repaint(rowBounds);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point point = (Point)NetTreeUI.this.tree.getClientProperty("BlueTouch.rolloveredCell");
            int oldRow = (int)point.getX();
            int row = NetTreeUI.this.tree.getClosestRowForLocation(e.getX(), e.getY());
            Rectangle rowBounds = NetTreeUI.this.tree.getRowBounds(row);
            if (rowBounds == null) {
                rowBounds = new Rectangle(0, 0);
            } else {
                rowBounds.x = 0;
                rowBounds.width = NetTreeUI.this.tree.getWidth();
            }
            if (!rowBounds.contains(e.getPoint())) {
                row = -1;
            }
            point.move(row, (int)point.getY());
            Rectangle oldRowBounds = NetTreeUI.this.tree.getRowBounds(oldRow);
            if (oldRowBounds != null) {
                oldRowBounds.x = 0;
                oldRowBounds.width = NetTreeUI.this.tree.getWidth();
                NetTreeUI.this.tree.repaint(oldRowBounds);
            }
            if (rowBounds != null) {
                rowBounds.x = 0;
                rowBounds.width = NetTreeUI.this.tree.getWidth();
                NetTreeUI.this.tree.repaint(rowBounds);
            }
        }
    }

    private class SelectionHandler
    extends FocusAdapter {
        private SelectionHandler() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (NetTreeUI.this.tree == null) {
                return;
            }
            int leadSelection = NetTreeUI.this.tree.getLeadSelectionRow();
            Rectangle rowBounds = NetTreeUI.this.tree.getRowBounds(Math.max(leadSelection, 0));
            if (rowBounds == null) {
                NetTreeUI.this.tree.repaint();
                return;
            }
            Rectangle leadSelectionRect = new Rectangle(rowBounds);
            leadSelectionRect.x = 0;
            leadSelectionRect.width = NetTreeUI.this.tree.getWidth();
            NetTreeUI.this.tree.repaint(leadSelectionRect);
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.focusLost(e);
        }
    }

    private class TreeSelectionHandler
    implements TreeSelectionListener {
        private TreeSelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Rectangle firstCell;
            Rectangle rectangle = firstCell = NetTreeUI.this.tree != null ? NetTreeUI.this.tree.getRowBounds(0) : null;
            if (firstCell != null) {
                NetTreeUI.this.tree.repaint(firstCell);
            }
        }
    }
}

