/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicViewportUI;
import javax.swing.table.JTableHeader;
import javax.swing.text.JTextComponent;

public class NetViewportUI
extends BasicViewportUI
implements ContainerListener {
    private Border mySavedOldBorder = null;
    private JViewport myViewport;
    private PropertyChangeListener myBorderHandler = new TextFieldHandler();

    public NetViewportUI(JViewport viewport) {
        this.myViewport = viewport;
    }

    public static ComponentUI createUI(JComponent component) {
        return new NetViewportUI((JViewport)component);
    }

    @Override
    public void installUI(JComponent viewport) {
        super.installUI(viewport);
        if (this.myViewport.getView() instanceof JPanel && this.myViewport.getParent() instanceof JScrollPane) {
            JScrollPane scroll = (JScrollPane)this.myViewport.getParent();
            if (UIManager.getBoolean("Viewport.cleanupPanelBorder") && NetUtils.lookAndFeelCanReplace(scroll.getViewportBorder())) {
                this.mySavedOldBorder = scroll.getViewportBorder();
                scroll.setViewportBorder(UIManager.getBorder("ScrollPane.panelViewportBorder"));
            }
        }
    }

    @Override
    protected void installDefaults(JComponent viewport) {
        super.installDefaults(viewport);
        this.myViewport.setScrollMode(0);
        viewport.addContainerListener(this);
        viewport.setOpaque(!(this.myViewport.getView() instanceof JTableHeader));
        if (this.myViewport.getView() instanceof JTextComponent) {
            this.myViewport.getView().addPropertyChangeListener(this.myBorderHandler);
        }
    }

    @Override
    protected void uninstallDefaults(JComponent viewport) {
        super.uninstallDefaults(viewport);
        viewport.removeContainerListener(this);
        if (this.myViewport.getView() instanceof JTextComponent) {
            this.myViewport.getView().removePropertyChangeListener(this.myBorderHandler);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque() && c.getBackground() instanceof UIResource) {
            GradientUtils.drawVerticalBackgroundGradient((Container)c, g, this.myViewport.getView() instanceof JPanel ? 0 : 1);
            if (this.myViewport.getView() instanceof JTable) {
                Rectangle localBounds = SwingUtilities.getLocalBounds(this.myViewport);
                ++localBounds.height;
                NetUtils.paintTableBackgroundFilter(g, (JTable)this.myViewport.getView(), localBounds);
            }
            this.paint(g, c);
            return;
        }
        super.update(g, c);
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        JScrollPane scroll;
        this.myViewport.setOpaque(!(e.getChild() instanceof JTableHeader));
        if (this.shouldRemoveBorder(e) && NetUtils.lookAndFeelCanReplace((scroll = (JScrollPane)e.getComponent().getParent()).getViewportBorder())) {
            this.mySavedOldBorder = scroll.getViewportBorder();
            scroll.setViewportBorder(UIManager.getBorder("ScrollPane.panelViewportBorder"));
        }
        if (e.getChild() instanceof JTextComponent) {
            e.getChild().addPropertyChangeListener(this.myBorderHandler);
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        JScrollPane scroll;
        if (this.shouldRemoveBorder(e) && (scroll = (JScrollPane)e.getComponent().getParent()).getViewportBorder() == UIManager.getBorder("ScrollPane.panelViewportBorder")) {
            scroll.setViewportBorder(this.mySavedOldBorder);
            this.mySavedOldBorder = null;
        }
        if (e.getChild() instanceof JTextComponent) {
            e.getChild().addPropertyChangeListener(this.myBorderHandler);
        }
    }

    private boolean shouldRemoveBorder(ContainerEvent e) {
        Component child = e.getChild();
        Component source = e.getComponent();
        return (child instanceof JPanel || child instanceof JLabel) && source != null && source.getParent() instanceof JScrollPane && UIManager.getBoolean("Viewport.cleanupPanelBorder");
    }

    private class TextFieldHandler
    implements PropertyChangeListener {
        private TextFieldHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("background".equals(evt.getPropertyName()) && NetViewportUI.this.myViewport != null && NetViewportUI.this.myViewport.getParent() instanceof JScrollPane) {
                JScrollPane scroll = (JScrollPane)NetViewportUI.this.myViewport.getParent();
                scroll.repaint(0, 0, scroll.getWidth(), 5);
                scroll.repaint(0, scroll.getHeight() - 6, scroll.getWidth(), 5);
            }
        }
    }
}

