/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class RolloverHandler
extends MouseInputAdapter
implements PropertyChangeListener {
    private JComponent myComponent;

    public void installTo(JComponent component) {
        this.myComponent = component;
        this.myComponent.addMouseListener(this);
        this.myComponent.addMouseMotionListener(this);
        this.myComponent.addPropertyChangeListener("ancestor", this);
    }

    public void uninstallFrom(JComponent component) {
        this.myComponent.removeMouseListener(this);
        this.myComponent.removeMouseMotionListener(this);
        this.myComponent.removePropertyChangeListener("ancestor", this);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Point point = (Point)this.myComponent.getClientProperty("BlueTouch.rolloveredCell");
        if (point != null) {
            point.move(-1, -1);
        }
        this.myComponent.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point point = (Point)this.myComponent.getClientProperty("BlueTouch.rolloveredCell");
        if (point == null) {
            point = new Point();
            this.myComponent.putClientProperty("BlueTouch.rolloveredCell", point);
        }
        Point newPoint = e.getPoint();
        point.move((int)newPoint.getX(), (int)newPoint.getY());
        this.myComponent.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Point point;
        if ("ancestor".equals(evt.getPropertyName()) && evt.getNewValue() == null && this.myComponent != null && (point = (Point)this.myComponent.getClientProperty("BlueTouch.rolloveredCell")) != null) {
            point.move(-1, -1);
        }
    }
}

