/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.borders;

import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.util.NetUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DialogShadowBorder
extends BaseBorder {
    private static final int ROUNDING = NetTheme.getNormalRounding();

    public DialogShadowBorder() {
        super(11, 7, 16, 7);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Window window = SwingUtilities.getWindowAncestor(c);
        JRootPane root = (JRootPane)c;
        Rectangle bounds = window.getBounds();
        NetUtils.paintScreenCapture(g, bounds);
        NetUtils.drawDropShadow((Graphics2D)g, (Color[])UIManager.get("Dialog.shadow"), new Insets(5, 7, 10, 7), 0, 0, width, height, ROUNDING + 2);
        Insets insets = this.getBorderInsets(c);
        Object oldAa = NetUtils.antiAliasingOn(g);
        g.setColor(Color.decode("#FCFCFC"));
        Shape topCap = NetUtils.getRoundedRect(root, insets.left + 1, 6, width - (insets.left + insets.right) - 1, 7, ROUNDING, 5);
        ((Graphics2D)g).fill(topCap);
        NetUtils.paintEmphasis((Graphics2D)g, root, insets.left, 5, root.getWidth() - (insets.left + insets.right) + 1, ROUNDING + 1);
        Shape bottomCap = NetUtils.getRoundedRect(root, insets.left, height - insets.bottom, width - (insets.left + insets.right) + 1, 7, ROUNDING, 1);
        Color bottomCapColor = ((Color[])UIManager.get("Dialog.background"))[1];
        g.setColor(bottomCapColor);
        ((Graphics2D)g).fill(bottomCap);
        NetUtils.setAntialiasing(g, oldAa);
    }
}

