/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.borders;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class FloatingPaneBorder
extends AbstractBorder {
    private static final Insets SHADOW_INSETS = new Insets(1, 2, 3, 2);

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 3;
        insets.left = 4;
        insets.bottom = 5;
        insets.right = 4;
        return insets;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int rounding = NetTheme.getNormalRounding();
        NetUtils.drawDropShadow((Graphics2D)g, "FloatingPane.dropShadow", SHADOW_INSETS, x, y, width, height, rounding + 1);
        this.paintTopHighlight(c, g, width);
        if (this.shouldPaintOutline(c)) {
            Object oldAa = NetUtils.antiAliasingOn(g);
            RoundRectangle2D.Double outline = new RoundRectangle2D.Double(2.0, 1.0, c.getWidth() - 5, c.getHeight() - 5, rounding - 1, rounding - 1);
            GradientUtils.drawVerticalGradientOutline((JComponent)c, g, "FloatingPane.outlineGradient", (Shape)outline);
            if (this.shouldPaintBottomShadow(c)) {
                g.setColor(UIManager.getColor("FloatingPane.bottomShadow"));
                ((Graphics2D)g).drawLine(x + 7, height - 5, width - 9, height - 5);
            }
            NetUtils.setAntialiasing(g, oldAa);
        }
    }

    private boolean shouldPaintBottomShadow(Component comp) {
        if (comp instanceof JPanel) {
            return true;
        }
        if (comp instanceof JScrollPane) {
            JScrollPane scroll = (JScrollPane)comp;
            Component view = scroll.getViewport().getView();
            return view instanceof JPanel || view instanceof AbstractButton;
        }
        return false;
    }

    private boolean shouldPaintOutline(Component comp) {
        if (comp instanceof JPanel) {
            return true;
        }
        if (comp instanceof JScrollPane) {
            JScrollPane scroll = (JScrollPane)comp;
            Component view = scroll.getViewport().getView();
            return view instanceof JPanel || view instanceof AbstractButton || view instanceof JTree;
        }
        return false;
    }

    private void paintTopHighlight(Component c, Graphics g, int width) {
        if (c instanceof JPanel || c instanceof JScrollPane && ((JScrollPane)c).getViewport().getView() instanceof JPanel) {
            g.setColor(NetLookAndFeel.getWhite());
            g.drawLine(9, 1, width - 10, 1);
            g.drawLine(8, 2, width - 8, 2);
        }
    }
}

