/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.borders;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PBorderFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class HeaderBorder
extends AbstractBorder {
    private static final Color OUTLINE_COLOR = UIManager.getColor("Panel.headerPanelOutline");
    private static int HEADER_MARGIN = 8;
    private static Font HEADER_FONT = UIManager.getFont("Label.headersFont");
    private boolean myIsEmphasized = false;
    protected static int BOTTOM_SHADOW_HEIGHT = 10;
    private String myHeader;
    private boolean myPaintHeaderArea = true;
    private boolean myPaintSeparator;
    private static Border DELEGATE_BORDER = PBorderFactory.getBasicNetBorder(Color.decode("#FEFEFE"));

    public HeaderBorder(String headerText) {
        this(headerText, false);
    }

    public HeaderBorder(String headerText, boolean emphasized) {
        this.myIsEmphasized = emphasized;
        this.myHeader = headerText;
    }

    public HeaderBorder(String headerText, boolean emphasized, boolean paintHeaderArea) {
        this.myIsEmphasized = emphasized;
        this.myHeader = headerText;
        this.myPaintHeaderArea = paintHeaderArea;
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        return this.getBorderInsets(comp, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component comp, Insets newInsets) {
        Insets insets = DELEGATE_BORDER.getBorderInsets(comp);
        insets.top = this.myHeader != null && this.myHeader.length() > 0 ? (insets.top += HEADER_FONT.getSize() + 10 - 1) : 5;
        if (this.myIsEmphasized) {
            insets.top += 2;
        }
        newInsets.top = insets.top;
        newInsets.bottom = 15 + insets.bottom;
        newInsets.left = insets.left;
        newInsets.right = insets.right;
        return newInsets;
    }

    public void setPaintSeparator(boolean paint) {
        this.myPaintSeparator = paint;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.translate(x, y);
        JComponent jComponent = (JComponent)c;
        Object oldAa = NetUtils.antiAliasingOn(g);
        Insets insets = this.getBorderInsets(c);
        if (this.myPaintHeaderArea) {
            this.paintHeaderAreaBackground(jComponent, g, width, insets.top);
        }
        if (this.myIsEmphasized) {
            NetUtils.paintEmphasis((Graphics2D)g, jComponent, width);
        }
        Shape oldClip = g.getClip();
        if (this.myIsEmphasized) {
            g.clipRect(0, 6, width, height);
        }
        Color headerOutline = NetLookAndFeel.getWhite();
        if (this.myPaintHeaderArea) {
            DELEGATE_BORDER.paintBorder(c, g, 0, 0, width - 1, height - BOTTOM_SHADOW_HEIGHT);
            g.clipRect(0, 0, width, insets.top);
            headerOutline = Color.decode("#FDFDFD");
        }
        PBorderFactory.getBasicNetBorder(headerOutline).paintBorder(c, g, 0, 0, width - 1, height - BOTTOM_SHADOW_HEIGHT);
        g.setClip(oldClip);
        if (this.myPaintHeaderArea && this.myPaintSeparator) {
            this.paintSeparator(g, c, width);
        }
        int shadowMargin = 1;
        NetUtils.drawCurvedDropShadow((Graphics2D)g, shadowMargin, height - BOTTOM_SHADOW_HEIGHT, width - 1 - 2 * shadowMargin, true);
        g.setFont(this.getHeaderFont(jComponent));
        g.setColor(NetTheme.COLOR_BLACK_29);
        NetLookAndFeel.toggleTextAntialiasing(g);
        int offset = g.getFont().getSize() > 12 ? 1 : 0;
        g.drawString(this.myHeader, HEADER_MARGIN, insets.top / 2 + g.getFontMetrics(g.getFont()).getAscent() / 2 - offset);
        NetUtils.setAntialiasing(g, oldAa);
        g.translate(-x, -y);
    }

    protected void paintHeaderAreaBackground(JComponent jComponent, Graphics g, int width, int height) {
        int yPos = this.myIsEmphasized ? 3 : 1;
        int rounding = NetTheme.getComponentOutlineRounding(jComponent);
        Shape background = NetUtils.getRoundedRect(jComponent, 1, yPos, width - 2, height, rounding, 5);
        GradientUtils.drawDoubleGradientBackground(g, jComponent, background, "HeaderBorder.headerBackground");
    }

    private Font getHeaderFont(Component c) {
        Font customFont = (Font)((JComponent)c).getClientProperty(ClientProperties.PANEL_HEADER_FONT);
        return customFont != null ? customFont : UIManager.getFont("Label.headersFont");
    }

    public void paintBackground(Graphics g, JComponent c) {
        Insets insets = c.getInsets();
        int rounding = 6;
        Shape background = this.myPaintHeaderArea ? NetUtils.getRoundedRect(c, 1, insets.top, c.getWidth() - 2, c.getHeight() - insets.top - BOTTOM_SHADOW_HEIGHT, rounding, 1) : NetUtils.getRoundedRect(c, 1, 1, c.getWidth() - 2, c.getHeight() - BOTTOM_SHADOW_HEIGHT, rounding);
        GradientUtils.drawVerticalGradient(c, g, "HeaderBorder.panelBackground", background);
    }

    private void paintSeparator(Graphics g, Component comp, int width) {
        g.setColor(OUTLINE_COLOR);
        int bottomBorderYLocation = this.getBorderInsets((Component)comp).top;
        g.drawLine(0, bottomBorderYLocation, width - 1, bottomBorderYLocation);
        g.setColor(NetLookAndFeel.getWhite());
        g.drawLine(1, bottomBorderYLocation + 1, width - 3, bottomBorderYLocation + 1);
    }

    public int getPreferredWidth(JComponent comp) {
        if (this.myHeader == null) {
            return 0;
        }
        FontMetrics fm = comp.getFontMetrics(this.getHeaderFont(comp));
        return fm.stringWidth(this.myHeader) + 36;
    }
}

