/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.borders;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.buttons.MenuButton;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class NetButtonBorder
extends BaseBorder {
    public NetButtonBorder() {
        super(new Insets(2, 3, 4, 3));
    }

    @Override
    public Insets getBorderInsets(Component comp, Insets newInsets) {
        if (ComponentUtils.isRounded((JComponent)comp)) {
            newInsets.top = 4;
            newInsets.bottom = 4;
            newInsets.left = 4;
            newInsets.right = 4;
            return newInsets;
        }
        Insets result = super.getBorderInsets(comp, newInsets);
        if (ClientPropertyUtil.booleanValue((JComponent)comp, "toolButton")) {
            result.bottom = 3;
        }
        return result;
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        if (ComponentUtils.isRounded((JComponent)comp)) {
            return new Insets(4, 4, 4, 4);
        }
        return super.getBorderInsets(comp);
    }

    @Override
    public void paintBorder(Component comp, Graphics graphics, int x, int y, int w, int h) {
        Shape oldClip = graphics.getClip();
        boolean straightBottomEdge = ClientPropertyUtil.booleanValue((JComponent)comp, "OrangeTouch.isStraightBottomEdge");
        boolean straightTopEdge = ClientPropertyUtil.booleanValue((JComponent)comp, "OrangeTouch.isStraightTopEdge");
        boolean isMinimalistic = Boolean.TRUE.equals(((JComponent)comp).getClientProperty(ClientProperties.IS_MINIMALISTIC));
        if (straightBottomEdge) {
            graphics.clipRect(x, y, w, h - 4);
        } else if (straightTopEdge) {
            graphics.clipRect(x, y + 1, w, h);
        }
        AbstractButton button = (AbstractButton)comp;
        ButtonModel model = button.getModel();
        Color outlineColor = UIManager.getColor("Button.outlineColor");
        Color highlightColor = NetTheme.getComponentOutlineHighlightColor();
        boolean isPressed = this.isPressed(button);
        boolean isDark = this.isDark(comp);
        boolean rounded = ComponentUtils.isRounded(button);
        if (model.isEnabled() && !ComponentUtils.isReadOnly(button)) {
            boolean isHovered = model.isRollover();
            if (straightBottomEdge) {
                highlightColor = UIManager.getColor("Button.pressedHighlight1");
            }
            if (isHovered && !isPressed) {
                outlineColor = NetTheme.getHoverColor();
            } else if (isPressed) {
                highlightColor = UIManager.getColor("Button.pressedHighlight1");
            }
            if (isDark) {
                highlightColor = isPressed && !(comp instanceof MenuButton) || rounded ? null : UIManager.getColor("Button.defaultButtonHighlightOutline");
                if (!isHovered || isPressed) {
                    outlineColor = UIManager.getColor("Button.defaultButtonOutline");
                }
            }
        } else {
            outlineColor = NetTheme.getDisabledComponentOutlineColor();
            highlightColor = null;
        }
        if (!isPressed && button.isEnabled() && !ComponentUtils.isReadOnly(button) && !rounded) {
            if (NetUtils.isMinimalistic(button)) {
                NetUtils.drawDropShadow((Graphics2D)graphics, (Color[])UIManager.get("Button.minimalisticShadow"), new Insets(1, 1, 2, 1), x, y, w, h + 1, 8);
            } else {
                NetUtils.paintDropShadow(graphics, button, x, y, w, h);
            }
        }
        if (highlightColor != null && !isMinimalistic) {
            this.paintTopHighlight(graphics, button, w, h, button, highlightColor, rounded);
        }
        if (isPressed && !isDark && !isMinimalistic) {
            graphics.setColor(UIManager.getColor("Button.pressedHighlight2"));
            graphics.drawLine(5, 3, w - 6, 3);
            graphics.setColor(UIManager.getColor("Button.pressedBottomHighlight"));
            graphics.drawLine(7, h - 5, w - 9, h - 5);
            Graphics2D g2d = (Graphics2D)graphics;
            Color[] pressedOutline = (Color[])UIManager.get("Button.pressedOutlineGradient");
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, pressedOutline[0], 0.0f, h - 1, pressedOutline[1]));
            Object oldAa = NetUtils.antiAliasingOn(g2d);
            g2d.draw(NetUtils.getButtonOutline(button));
            NetUtils.setAntialiasing(g2d, oldAa);
        } else {
            this.paintMainOutline(graphics, button, outlineColor, x, y, w, h);
        }
        graphics.setClip(oldClip);
    }

    private void paintTopHighlight(Graphics graphics, JComponent comp, int w, int h, AbstractButton button, Color highlightColor, boolean rounded) {
        graphics.setColor(highlightColor);
        if (rounded) {
            return;
        }
        if (button.getModel().isPressed()) {
            graphics.drawLine(5, 2, w - 6, 2);
        } else {
            int offset;
            boolean isDefault;
            boolean bl = isDefault = button instanceof JButton && (((JButton)button).isDefaultButton() || ((JButton)button).isFocusOwner());
            if (isDefault && !SystemUtils.isOrangeTouch()) {
                return;
            }
            Shape clip = graphics.getClip();
            graphics.clipRect(0, 0, w, 5);
            Object oldAa = NetUtils.antiAliasingOn(graphics);
            int rounding = NetTheme.getComponentOutlineRounding(comp);
            int n = offset = NetUtils.isMinimalistic(comp) ? 1 : 0;
            if (NetLookAndFeel.getWhite().equals(highlightColor)) {
                graphics.drawLine(rounding / 2 + 3 - offset, 2 - offset, w - rounding + 1 + 2 * offset, 2 - offset);
            } else {
                graphics.drawRoundRect(3, 2, w - 6, h, rounding - 2, rounding - 2);
            }
            NetUtils.setAntialiasing(graphics, oldAa);
            graphics.setClip(clip);
        }
    }

    protected boolean isPressed(AbstractButton button) {
        ButtonModel model = button.getModel();
        return model.isPressed() && model.isArmed();
    }

    protected boolean isDark(Component comp) {
        if (comp instanceof AbstractButton) {
            return NetUtils.isNegative((AbstractButton)comp);
        }
        return false;
    }

    protected void paintMainOutline(Graphics graphics, AbstractButton button, Color outlineColor, int x, int y, int w, int h) {
        NetUtils.drawButtonOutline(graphics, (JComponent)button, outlineColor);
    }
}

