/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.borders;

import com.nokia.laf.borders.BaseBorder;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public class NetCheckBoxBorder
extends BaseBorder {
    private static final int STATUS_AREA_WIDTH = 10;
    private static final int ICON_OFFSET = -2;

    public NetCheckBoxBorder() {
        super(new Insets(0, 0, 0, 10));
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        return this.getBorderInsets(comp, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component comp, Insets newInsets) {
        Insets result = super.getBorderInsets(comp, newInsets);
        if (!ClientPropertyUtil.hasProperty((JComponent)comp, "BlueTouch.unmodifiedValue")) {
            result.right = 0;
        }
        return result;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        JComponent component = (JComponent)c;
        Object unmodifiedValue = component.getClientProperty("BlueTouch.unmodifiedValue");
        if (unmodifiedValue != null && this.getValue(component) != null && !this.getValue(component).toString().equalsIgnoreCase(unmodifiedValue.toString())) {
            if (c instanceof JRadioButton && !((JRadioButton)c).isSelected()) {
                return;
            }
            this.paintIconToStatusArea(g2d, component, CommonIcons.getIcon(component, CommonIcons.getEditIcon()), -2, -1);
        }
    }

    private void paintIconToStatusArea(Graphics2D g2d, JComponent component, Icon icon, int xOffset, int yOffset) {
        Icon iconToPaint = icon;
        iconToPaint.paintIcon(component, g2d, component.getWidth() - icon.getIconWidth() + xOffset, component.getHeight() / 2 - icon.getIconHeight() / 2 + yOffset);
    }

    protected Object getValue(JComponent component) {
        return ((AbstractButton)component).isSelected();
    }
}

