/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.borders;

import com.nokia.laf.NetComboBoxUI;
import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.UIManager;

public class NetComboBoxBorder
extends BaseBorder {
    public NetComboBoxBorder() {
        super(1, 0, 2, 1);
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        return this.getBorderInsets(comp, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component comp, Insets newInsets) {
        JComboBox combo = (JComboBox)comp;
        if (combo.isEditable() && ComponentUtils.isSmall(combo)) {
            newInsets.top = 0;
            newInsets.bottom = 2;
            newInsets.left = 0;
            newInsets.right = 1;
            return newInsets;
        }
        super.getBorderInsets(comp, newInsets);
        String segmentPosition = (String)combo.getClientProperty("JToggleButton.segmentPosition");
        if ("first".equals(segmentPosition)) {
            newInsets.bottom = 0;
        } else if ("middle".equals(segmentPosition)) {
            newInsets.top = 0;
            newInsets.bottom = 0;
        } else if ("last".equals(segmentPosition)) {
            newInsets.top = 0;
        }
        return newInsets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        int tempH = h;
        int tempY = y;
        JComboBox combo = (JComboBox)c;
        if (combo.isPopupVisible()) {
            tempH += 1000;
        }
        if (c.isEnabled() && !ComponentUtils.isReadOnly(combo)) {
            String segmentPosition;
            Shape oldClip = g.getClip();
            if (combo.isEditable()) {
                AbstractButton arrowButton = this.getArrowButton(combo);
                g.clipRect(combo.getWidth() - arrowButton.getWidth() - 1, 0, combo.getWidth(), combo.getHeight() + 1);
            }
            if ("first".equals(segmentPosition = (String)combo.getClientProperty("JToggleButton.segmentPosition"))) {
                tempH += 1000;
            } else if ("middle".equals(segmentPosition)) {
                tempH += 1000;
                tempY -= 500;
            } else if ("last".equals(segmentPosition)) {
                tempY -= 1000;
                tempH += 1000;
            }
            NetUtils.paintDropShadow((Graphics2D)g, combo, x, y, w, h, NetTheme.getComponentOutlineRounding(combo) + 1);
            g.setClip(oldClip);
            if (combo.isEditable()) {
                AbstractButton arrowButton = this.getArrowButton(combo);
                Color bottomHighlight = (Color)combo.getClientProperty("OrangeTouch.bottomHighlight");
                if (bottomHighlight == null) {
                    bottomHighlight = UIManager.getColor("TextField.bottomHighlight");
                }
                g.setColor(bottomHighlight);
                int rounding = NetTheme.getComponentOutlineRounding(combo);
                g.drawLine(x + rounding / 2, y + h - 3, w - arrowButton.getWidth() - 3, tempY + tempH - 3);
            }
        }
    }

    protected AbstractButton getArrowButton(Component comp) {
        JComboBox comboBox = (JComboBox)comp;
        return ((NetComboBoxUI)comboBox.getUI()).getArrowButton();
    }
}

