/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.borders;

import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.combobox.NetComboBoxButton;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.ButtonModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;

public class NetComboBoxButtonBorder
extends BaseBorder {
    public NetComboBoxButtonBorder() {
        super(1, 1, 1, 1);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        String segmentPosition;
        int tempX = x;
        int tempY = y;
        int tempW = w;
        int tempH = h;
        NetComboBoxButton button = (NetComboBoxButton)c;
        JComboBox<Object> combo = button.getComboBox();
        ButtonModel model = button.getModel();
        Color outlineColor = this.getOutlineColor(button);
        if (combo.isPopupVisible()) {
            tempH += 1000;
            boolean popupAboveCombo = ClientPropertyUtil.booleanValue(combo, "OrangeTouch.popupAboveCombo");
            if (popupAboveCombo) {
                tempY -= 1000;
            }
        }
        if (combo.isEditable() && combo.isEnabled() && !ComponentUtils.isReadOnly(combo)) {
            tempW += 1000;
            tempX -= 1000;
        }
        if ((segmentPosition = (String)combo.getClientProperty("JToggleButton.segmentPosition")) != null) {
            Color oldColor = g.getColor();
            Object oldAa = NetUtils.antiAliasingOn(g);
            g.setColor(outlineColor);
            ((Graphics2D)g).draw(this.getButtonShape(button, x, y, w, h, segmentPosition));
            g.setColor(oldColor);
            NetUtils.setAntialiasing(g, oldAa);
        } else {
            if (model.isEnabled() && !ComponentUtils.isReadOnly(button)) {
                g.setColor(UIManager.getColor("TextComponent.disabledFill"));
                if (combo.isEditable()) {
                    g.drawLine(1, h - 2, button.getWidth() - 5, h - 2);
                } else {
                    g.drawLine(5, h - 2, w - 6, h - 2);
                }
            }
            NetUtils.drawOutline((Graphics2D)g, button, outlineColor, tempX, tempY, tempW, tempH);
        }
    }

    private Color getOutlineColor(NetComboBoxButton button) {
        boolean isHovered;
        boolean isPressed;
        ButtonModel model = button.getModel();
        boolean bl = isPressed = model.isPressed() && model.isArmed();
        if (!model.isEnabled() || ComponentUtils.isReadOnly(button)) {
            return NetTheme.getDisabledComponentOutlineColor();
        }
        JComboBox<Object> combo = button.getComboBox();
        boolean bl2 = isHovered = model.isRollover() && !combo.getUI().isPopupVisible(combo);
        if (isHovered && !isPressed && (!NetUtils.isTableCellEditor(combo) || combo.getParent() instanceof JTableHeader)) {
            return NetTheme.getHoverColor();
        }
        if (NetUtils.isFocused(combo) && (!isHovered || isPressed)) {
            return UIManager.getColor("Button.defaultButtonOutline");
        }
        return NetTheme.getComponentOutlineColor();
    }

    private Shape getButtonShape(JComponent button, int x, int y, int w, int h, String segmentPosition) {
        int rounding = NetTheme.getComponentOutlineRounding(button);
        if ("first".equals(segmentPosition)) {
            return NetUtils.getRoundedRect(button, x, y, w, h, rounding, 5, 7);
        }
        if ("last".equals(segmentPosition)) {
            return NetUtils.getRoundedRect(button, x, y, w, h, rounding, 1, 7);
        }
        if ("only".equals(segmentPosition)) {
            return NetUtils.getRoundedRect(button, x, y, w, h, rounding, 7);
        }
        if ("middle".equals(segmentPosition)) {
            return new Rectangle(x, y - 1, w - 1, h + 1);
        }
        return null;
    }
}

