/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.borders;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.combobox.NetComboPopup;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class NetComboBoxPopupBorder
extends BaseBorder {
    public NetComboBoxPopupBorder() {
        super(0, 2, 3, 2);
    }

    public NetComboBoxPopupBorder(int top, int left, int bottom, int right) {
        this.myInsets = new Insets(top, left, bottom, right);
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        NetComboPopup comboPopup = (NetComboPopup)comp;
        Insets newInsets = new Insets(0, 0, 0, 0);
        return this.getBorderInsets(comp, newInsets, comboPopup);
    }

    @Override
    public Insets getBorderInsets(Component comp, Insets newInsets) {
        NetComboPopup comboPopup = (NetComboPopup)comp;
        return this.getBorderInsets(comp, newInsets, comboPopup);
    }

    private Insets getBorderInsets(Component comp, Insets newInsets, NetComboPopup comboPopup) {
        if (ClientPropertyUtil.booleanValue((JComponent)comp, "OrangeTouch.popupAboveCombo")) {
            return this.getBorderInsetsWhenPopupAboveCombo(newInsets, comboPopup);
        }
        return this.getBorderInsetsWhenPopupUnderCombo(comp, newInsets, comboPopup);
    }

    private Insets getBorderInsetsWhenPopupAboveCombo(Insets newInsets, NetComboPopup comboPopup) {
        if (comboPopup.isSearchSupported()) {
            newInsets.top = 5;
            newInsets.left = 1;
            newInsets.bottom = 1;
            newInsets.right = 1;
        } else {
            newInsets.top = 3;
            newInsets.left = 2;
            newInsets.bottom = 0;
            newInsets.right = 2;
        }
        return newInsets;
    }

    private Insets getBorderInsetsWhenPopupUnderCombo(Component comp, Insets newInsets, NetComboPopup comboPopup) {
        if (comboPopup.isSearchSupported()) {
            newInsets.top = 1;
            newInsets.left = 1;
            newInsets.bottom = 5;
            newInsets.right = 1;
        }
        return super.getBorderInsets(comp, newInsets);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        NetComboPopup comboPopup = (NetComboPopup)c;
        if (comboPopup.isSearchSupported()) {
            this.paintBorderWithSearchField(g, x, y, width, height, comboPopup);
        } else {
            this.paintBorderWithoutSearchField(c, g, x, y, width, height);
        }
    }

    private void paintBorderWithSearchField(Graphics g, int x, int y, int width, int height, NetComboPopup comboPopup) {
        boolean popupAboveCombo = ClientPropertyUtil.booleanValue(comboPopup.getComboBox(), "OrangeTouch.popupAboveCombo");
        Color background = UIManager.getColor("ComboBox.background");
        ColorUIResource outline = NetUtils.isFocused(comboPopup.getComboBox()) ? NetLookAndFeel.getCurrentTheme().getFocusColor() : NetTheme.getComponentOutlineColor();
        NetUtils.drawRoundRectWithFilledCap(comboPopup, g, x, y, width, height, background, outline, popupAboveCombo ? 5 : 1);
    }

    private void paintBorderWithoutSearchField(Component c, Graphics g, int x, int y, int width, int height) {
        Color[] colors = (Color[])UIManager.get("Button.shadow");
        boolean popupAboveCombo = ClientPropertyUtil.booleanValue((JComponent)c, "OrangeTouch.popupAboveCombo");
        if (popupAboveCombo) {
            BufferedImage image = ImageUtils.createCompatibleTranslucentImage(width, height);
            Graphics2D g2d = image.createGraphics();
            NetUtils.drawDropShadow(g2d, colors, new Insets(0, 2, 3, 2), x, y, width, height, 9);
            g2d.dispose();
            g.drawImage(ImageUtils.createFlippedImage(image), x, y, null);
        } else {
            NetUtils.drawDropShadow((Graphics2D)g, colors, new Insets(0, 2, 3, 2), x, y, width, height, 9);
        }
    }
}

