/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.borders;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class NetDialogBorder
extends BaseBorder {
    public NetDialogBorder() {
        super(4, 4, 5, 4);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Window window = SwingUtilities.getWindowAncestor(c);
        JRootPane root = (JRootPane)c;
        this.paintMainOutline(c, g, x, y, width, height, window);
        Color[] gradient = (Color[])UIManager.get(this.getGradient(root));
        boolean isPlainDialog = false;
        if (root.getWindowDecorationStyle() == 8) {
            g.setColor(NetUtils.decodeColor("#FFE000"));
        } else if (root.getWindowDecorationStyle() == 4) {
            g.setColor(gradient[1]);
        } else {
            isPlainDialog = true;
            g.setColor(NetLookAndFeel.getWhite());
            g.fillRect(x + 1, y + 2, width - 2, 1);
        }
        g.drawLine(x + 1, y + 1, width - 2, y + 1);
        Insets insets = this.getBorderInsets(c);
        int topGap = NetUtils.isWarningOrErrorBox(root) ? 2 : insets.top;
        GradientUtils.drawVerticalGradient((JComponent)c, g, gradient, x + 5, y + topGap, width - 6, 32 - topGap);
        g.setColor(gradient[0]);
        g.fillRect(x + 1, y + 2, 4, 9);
        if (isPlainDialog) {
            g.setColor(NetLookAndFeel.getWhite());
            g.drawLine(x + 1, 2, x + width - 2, 2);
            g.drawLine(x + 1, 3, x + width - 2, 3);
        }
        this.fillLeftAndRightEndsOfCurvyTitleOutline(g, x, y, width, root);
        if (isPlainDialog && window != null && window.isActive() && !NetUtils.isWarningOrErrorBox(root)) {
            this.paintEmphasis(g, root);
        }
    }

    private void fillLeftAndRightEndsOfCurvyTitleOutline(Graphics g, int x, int y, int width, JRootPane root) {
        Color[] colors = (Color[])UIManager.get(this.getCurvyOutlineKey(root));
        g.setColor(colors[0]);
        g.drawLine(x + 1, y + 10, x + 4, y + 10);
        g.setColor(colors[1]);
        g.drawLine(x + width - 5, y + 31, x + width - 2, y + 31);
        g.setColor(NetLookAndFeel.getWhite());
        g.drawLine(x + width - 4, y + 32, x + width - 4, y + 32);
    }

    private void paintMainOutline(Component c, Graphics g, int x, int y, int width, int height, Window window) {
        int tempHeight = height;
        if (window != null && window.isActive()) {
            g.setColor(UIManager.getColor("RootPane.bottomShadow"));
            g.drawLine(0, tempHeight - 1, width - 1, tempHeight - 1);
            BorderFactory.createLineBorder(new Color(250, 250, 250), 4).paintBorder(c, g, x, y, width, --tempHeight);
            BorderFactory.createLineBorder(new Color(255, 255, 255), 3).paintBorder(c, g, x, y, width, tempHeight);
            BorderFactory.createLineBorder(NetLookAndFeel.getFocusColor(), 1).paintBorder(c, g, x, y, width, tempHeight);
        } else {
            BorderFactory.createLineBorder(new Color(255, 255, 255), 4).paintBorder(c, g, x, y, width, tempHeight);
            BorderFactory.createLineBorder(new Color(235, 235, 235), 3).paintBorder(c, g, x, y, width, tempHeight);
            BorderFactory.createLineBorder(new Color(180, 180, 180), 1).paintBorder(c, g, x, y, width, tempHeight);
        }
    }

    private void paintEmphasis(Graphics g, JRootPane root) {
        g.setColor(NetLookAndFeel.getWhite());
        g.fillRect(1, 8, 3, 3);
        Color[] colors = (Color[])UIManager.get("RootPane.topEmphasis");
        Color col1 = colors[0];
        g.setColor(NetUtils.getColor(col1, 255));
        g.drawLine(1, 10, 3, 10);
        int alpha = NetUtils.isMessageBox(root) ? 90 : 130;
        g.setColor(NetUtils.getColor(col1, alpha));
        g.drawLine(1, 9, 3, 9);
        alpha = NetUtils.isMessageBox(root) ? 9 : 14;
        g.setColor(NetUtils.getColor(col1, alpha));
        g.drawLine(1, 8, 3, 8);
    }

    private String getCurvyOutlineKey(JRootPane root) {
        int decorationStyle = root.getWindowDecorationStyle();
        if (decorationStyle == 8) {
            return "RootPane.warningCurvyOutline";
        }
        if (decorationStyle == 4) {
            return "RootPane.errorCurvyOutline";
        }
        return "RootPane.curvyOutline";
    }

    private String getGradient(JRootPane root) {
        int decorationStyle = root.getWindowDecorationStyle();
        if (decorationStyle == 8) {
            return "RootPane.warningCapGradient";
        }
        if (decorationStyle == 4) {
            return "RootPane.errorCapGradient";
        }
        return "RootPane.capGradient";
    }
}

