/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.borders;

import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.util.NetUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class NetPopupMenuBorder
extends BaseBorder {
    public NetPopupMenuBorder() {
        super(new Insets(5, 4, 10, 4));
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Object oldAa = NetUtils.antiAliasingOn(g);
        JComponent jComp = (JComponent)c;
        int rounding = NetTheme.getComponentOutlineRounding(jComp);
        Component invoker = this.getInvoker(jComp);
        boolean isTopLevelMenuPopup = this.isTopLevelMenu(jComp, invoker);
        Insets shadowInsets = new Insets(1, 4, 5, 4);
        Graphics2D g2d = (Graphics2D)g;
        this.paintShadow(g2d, jComp, invoker, x, y, width, height, rounding, shadowInsets, isTopLevelMenuPopup);
        this.fillTopCap(g2d, jComp, x, y, width, rounding, isTopLevelMenuPopup);
        this.fillBottomCap(g2d, jComp, x, y, width, height, rounding);
        NetUtils.setAntialiasing(g, oldAa);
    }

    protected boolean isTopLevelMenu(JComponent jComp, Component invoker) {
        if (jComp instanceof JPopupMenu) {
            return invoker instanceof JMenu && ((JMenu)invoker).isTopLevelMenu();
        }
        return false;
    }

    protected Component getInvoker(JComponent jComp) {
        if (jComp instanceof JPopupMenu) {
            return ((JPopupMenu)jComp).getInvoker();
        }
        return (Component)jComp.getClientProperty("OrangeTouch.invoker");
    }

    private void fillTopCap(Graphics2D g, JComponent c, int x, int y, int width, int rounding, boolean isTopLevelMenuPopup) {
        Shape topShape = this.getTopCapShape(c, x, y, width, rounding, isTopLevelMenuPopup);
        NetUtils.fillShapeInPopup(c, g, topShape);
    }

    private void fillBottomCap(Graphics2D g, JComponent c, int x, int y, int width, int height, int rounding) {
        Shape bottomShape = NetUtils.getRoundedRect(c, x + 4, y + height - 16, width - 7, 12, rounding, 1);
        NetUtils.fillShapeInPopup(c, g, bottomShape);
    }

    private Shape getTopCapShape(JComponent c, int x, int y, int width, int rounding, boolean isTopLevelMenuPopup) {
        int xStart = x + 4;
        int yStart = y + 1;
        int shapeWidth = width - 7;
        int shapeHeight = 9;
        if (isTopLevelMenuPopup || !(c instanceof JPopupMenu)) {
            return NetUtils.getRoundedRect(c, xStart, yStart, shapeWidth, 9, rounding - 1, 5, 7);
        }
        return NetUtils.getRoundedRect(c, xStart, yStart, shapeWidth, 9, rounding - 1, 5);
    }

    private void paintShadow(Graphics2D g2d, JComponent popupMenu, Component invoker, int x, int y, int width, int height, int rounding, Insets shadowInsets, boolean isTopLevelMenuPopup) {
        Color[] colors = (Color[])UIManager.get("PopupMenu.shadow");
        if (!(popupMenu instanceof JPopupMenu) && invoker != null || isTopLevelMenuPopup) {
            Shape oldClip = g2d.getClip();
            g2d.clipRect(0, 1, invoker.getWidth(), height);
            NetUtils.drawDropShadow(g2d, colors, shadowInsets, x, y - 1000, width, height + 1000, rounding);
            g2d.setClip(oldClip);
            g2d.clipRect(invoker.getWidth(), 0, width, height);
            NetUtils.drawDropShadow(g2d, colors, shadowInsets, x, y, width, height, rounding - 1);
            g2d.setClip(oldClip);
        } else {
            NetUtils.drawDropShadow(g2d, colors, shadowInsets, x, y, width, height, rounding);
        }
    }
}

