/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.borders;

import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.borders.FloatingPaneBorder;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public class NetScrollPaneBorder
extends BaseBorder {
    private static Border FLOATINGPANE_BORDER = new FloatingPaneBorder();
    private int SHADOW_HEIGHT = 10;

    public NetScrollPaneBorder() {
        super(new Insets(0, 0, 1, 0));
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        return this.getBorderInsets(comp, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component comp, Insets newInsets) {
        JScrollPane scroll;
        Insets result = super.getBorderInsets(comp, newInsets);
        if (comp.getParent() instanceof JSplitPane) {
            Insets floatingPaneInsets = FLOATINGPANE_BORDER.getBorderInsets(comp);
            result.top = floatingPaneInsets.top;
            result.left = floatingPaneInsets.left;
            result.right = floatingPaneInsets.right;
            result.bottom = floatingPaneInsets.bottom;
            return result;
        }
        if (this.isCurvedSheetInUse(comp)) {
            newInsets.bottom = result.bottom = this.SHADOW_HEIGHT;
        }
        if (comp instanceof JScrollPane && ((scroll = (JScrollPane)comp).getViewport().getView() instanceof JPanel && this.isVoidViewportBorder(scroll) || ClientPropertyUtil.booleanValue(scroll, "OrangeTouch.isInOverflowPopup"))) {
            result.top = 0;
            result.left = 0;
            result.right = 0;
            result.bottom = 0;
        }
        return result;
    }

    private boolean isVoidViewportBorder(JScrollPane comp) {
        Border border = comp.getViewportBorder();
        if (border == null || border instanceof EmptyBorder) {
            return true;
        }
        Insets insets = border.getBorderInsets(comp);
        return insets.top == 0 && insets.left == 0 && insets.right == 0 && insets.bottom == 0;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!(c instanceof JScrollPane)) {
            return;
        }
        JScrollPane scroll = (JScrollPane)c;
        if (scroll.getParent() instanceof JSplitPane) {
            this.paintBorderWhenParentIsSplitPane(scroll, g, x, y, width, height);
            return;
        }
        if (scroll.getViewport() != null && scroll.getViewport().getView() instanceof JPanel && this.isVoidViewportBorder(scroll)) {
            return;
        }
        Color oldColor = g.getColor();
        g.setColor(UIManager.getColor("ScrollPane.borderHighlight"));
        Border viewportBorder = scroll.getViewportBorder();
        int curvedShadowWidthOffset = 1;
        if (NetUtils.isNotNullAndVisible(scroll.getVerticalScrollBar()) && NetUtils.isNotNullAndVisible(scroll.getHorizontalScrollBar())) {
            curvedShadowWidthOffset += scroll.getVerticalScrollBar().getWidth();
        }
        if (this.isCurvedSheetInUse(scroll)) {
            NetUtils.drawCurvedDropShadow((Graphics2D)g, x, height - this.SHADOW_HEIGHT, width - curvedShadowWidthOffset);
        } else if (viewportBorder != null && viewportBorder.getBorderInsets((Component)c).bottom > 0 && !(viewportBorder instanceof EmptyBorder)) {
            g.drawLine(4, height - 1, width - 6, height - 1);
        }
        g.setColor(oldColor);
    }

    private void paintBorderWhenParentIsSplitPane(JScrollPane scroll, Graphics g, int x, int y, int width, int height) {
        Component view = scroll.getViewport().getView();
        if (view instanceof JList || view instanceof JTree) {
            g.setColor(view.getBackground());
            Object oldAa = NetUtils.antiAliasingOn(g);
            ((Graphics2D)g).fill(NetUtils.getRoundedRect(scroll, 2, 1, scroll.getWidth() - 4, scroll.getHeight() - 3, NetTheme.getNormalRounding()));
            NetUtils.setAntialiasing(g, oldAa);
        }
        FLOATINGPANE_BORDER.paintBorder(scroll, g, x, y, width, height);
    }

    private boolean isCurvedSheetInUse(Component c) {
        if (!(c instanceof JScrollPane)) {
            return false;
        }
        JScrollPane scroll = (JScrollPane)c;
        Object property = scroll.getClientProperty("OrangeTouch.curvedSheet");
        if (property == null && scroll.getViewport().getView() instanceof JTextComponent) {
            return false;
        }
        if (property == null && NetScrollPaneBorder.hasVoidViewportBorder(scroll)) {
            return false;
        }
        return ClientPropertyUtil.booleanValue(scroll, "OrangeTouch.curvedSheet", UIManager.getBoolean("ScrollPane.curvedSheetInUse"));
    }

    public static boolean hasVoidViewportBorder(JScrollPane scroll) {
        if (scroll.getViewportBorder() == null || scroll.getViewportBorder() instanceof EmptyBorder) {
            return true;
        }
        Insets insets = scroll.getViewportBorder().getBorderInsets(scroll);
        return insets.top == 0 && insets.bottom == 0 && insets.left == 0 && insets.right == 0;
    }
}

