/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.borders;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.util.NetUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RectangularShape;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class NetTableCellBorder
extends BaseBorder {
    public NetTableCellBorder() {
        super(1, 4, 1, 4);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        RectangularShape rect;
        JComponent jComp = (JComponent)c;
        boolean enabled = Boolean.TRUE.equals(jComp.getClientProperty("Table.isEnabled"));
        boolean hovered = Boolean.TRUE.equals(jComp.getClientProperty("Table.isRollovered")) && enabled;
        boolean focused = Boolean.TRUE.equals(jComp.getClientProperty("Table.hasFocus"));
        boolean editable = Boolean.TRUE.equals(jComp.getClientProperty("Table.isEditable"));
        boolean selected = Boolean.TRUE.equals(jComp.getClientProperty("Table.isSelected"));
        if (!editable && !focused) {
            return;
        }
        Object oldAa = NetUtils.antiAliasingOn(g);
        Color outline = UIManager.getColor("Table.editorBorder");
        int rounding = NetTheme.getSmallRounding();
        RectangularShape rectangularShape = rect = editable ? NetUtils.getRoundedRect(jComp, 1, 1, c.getWidth() - 2, c.getHeight() - 2, rounding) : new Rectangle(0, 0, c.getWidth() - 1, c.getHeight() - 1);
        if (!selected && !hovered) {
            this.paintTopHighlight(g, x, y, width, height, jComp, rounding);
        }
        if (focused) {
            outline = NetLookAndFeel.getFocusColor();
            g.setColor(outline);
            ((Graphics2D)g).draw(rect);
        } else if (hovered) {
            if (selected) {
                outline = NetTheme.getHoverColor();
                g.setColor(outline);
                ((Graphics2D)g).draw(rect);
            } else {
                Color[] top = (Color[])UIManager.get("TextField.topOutline");
                Color[] bottom = (Color[])UIManager.get("TextField.bottomOutline");
                NetUtils.drawRoundedRect((Graphics2D)g, top, bottom, 1, 1, c.getWidth() - 3, c.getHeight() - 3, rounding);
            }
        } else if (selected) {
            Color[] top = (Color[])UIManager.get("Table.selectedEditorOutline");
            NetUtils.drawRoundedRect((Graphics2D)g, top[0], top[1], 1, 1, c.getWidth() - 3, c.getHeight() - 3, rounding);
        } else {
            g.setColor(outline);
            ((Graphics2D)g).draw(rect);
        }
        NetUtils.setAntialiasing(g, oldAa);
    }

    private void paintTopHighlight(Graphics g, int x, int y, int width, int height, JComponent jComp, int rounding) {
        g.setColor(UIManager.getColor("Table.editorTopHighlight"));
        Shape shape = NetUtils.getRoundedPath(jComp, x + 2, y + 2, width - 3, height - rounding / 2, rounding - 2, 5, true);
        Shape clip = g.getClip();
        g.clipRect(x, y, width - 3, height - 4);
        ((Graphics2D)g).draw(shape);
        g.setClip(clip);
    }
}

