/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.borders;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class NetTableHeaderCellBorder
extends BaseBorder {
    private static final int CELL_ROUNDING = NetTheme.getNormalRounding();

    public NetTableHeaderCellBorder(boolean paintShadow) {
        super(1, 1, 1, 1);
    }

    public NetTableHeaderCellBorder() {
        super(1, 1, 1, 1);
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        return this.getBorderInsets(comp, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component comp, Insets newInsets) {
        if (comp instanceof JLabel) {
            newInsets.top = 4;
            newInsets.bottom = 3;
            return newInsets;
        }
        return super.getBorderInsets(comp, newInsets);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!(c instanceof JComponent)) {
            g.drawRect(x, y, width - 1, height - 1);
            return;
        }
        Object oldAa = NetUtils.antiAliasingOn(g);
        JComponent jComp = (JComponent)c;
        boolean standalone = ComponentUtils.isStandalone(jComp);
        Color color = NetUtils.isInDialog(jComp) ? NetUtils.getColor("TableHeader.dialogOutlineColor", 189) : NetUtils.getColor("TableHeader.outlineColor", 120);
        boolean enabled = ClientPropertyUtil.booleanValue(jComp, "TableHeader.isEnabled", true);
        if (!enabled) {
            color = UIManager.getColor("Table.bottomRuleColor");
        }
        Color oldColor = g.getColor();
        g.setColor(color);
        boolean straightLeft = Boolean.TRUE.equals(jComp.getClientProperty("OrangeTouch.isStraightLeftEdge"));
        boolean isLeftmostCell = Boolean.TRUE.equals(jComp.getClientProperty("Table.isLeftEnd")) && !straightLeft;
        boolean isRightmostCell = Boolean.TRUE.equals(jComp.getClientProperty("Table.isRightEnd"));
        boolean isEmpty = Boolean.TRUE.equals(jComp.getClientProperty("Table.isEmpty"));
        if (isLeftmostCell) {
            this.paintLeftmostCellBorder(jComp, (Graphics2D)g, x, y, width, height, standalone, isRightmostCell, isEmpty);
        } else if (isRightmostCell) {
            this.paintRightmostCellBorder(jComp, (Graphics2D)g, x, y, width, height, standalone, isEmpty);
        } else {
            this.paintMiddleCellBorder(jComp, g, x, y, width, height, standalone);
        }
        if (standalone || !isEmpty) {
            this.paintBottomRule(g, x, y, width, height, ClientPropertyUtil.booleanValue(jComp, "OceanTouch.isHeaderGroupRenderer", false));
        }
        if (!isLeftmostCell) {
            this.paintVerticalGridLine(g, jComp, x, y, height);
            if (ClientPropertyUtil.booleanValue(jComp, "Table.isBelowHeaderGroup")) {
                g.setColor(UIManager.getColor("Table.filterAreaBackground"));
                g.drawLine(x, y, x, y + height - 1);
            }
        }
        NetUtils.setAntialiasing(g, oldAa);
        g.setColor(oldColor);
    }

    private void paintLeftmostCellBorder(JComponent comp, Graphics2D g, int x, int y, int width, int height, boolean standalone, boolean isRightmostCell, boolean isEmpty) {
        Shape roundRect = this.getLeftmostCellOutline(comp, x, y, width, height, standalone, isRightmostCell, isEmpty);
        g.draw(roundRect);
    }

    private Shape getLeftmostCellOutline(JComponent comp, int x, int y, int width, int height, boolean standalone, boolean isRightmostCell, boolean isEmpty) {
        if (!standalone && isEmpty) {
            return NetUtils.getRoundedRect(comp, x, y, width, height, CELL_ROUNDING, 3);
        }
        if (isRightmostCell) {
            return NetUtils.getRoundedRect(comp, x, y, width, height, CELL_ROUNDING, 5);
        }
        return NetUtils.getRoundedRect(comp, x, y, width, height, CELL_ROUNDING, 5, 3);
    }

    private void paintRightmostCellBorder(JComponent c, Graphics2D g, int x, int y, int width, int height, boolean standalone, boolean isEmpty) {
        Shape roundRect = this.getRightmostCellOutline(c, x, y, width, height, standalone, isEmpty);
        g.draw(roundRect);
    }

    private Shape getRightmostCellOutline(JComponent c, int x, int y, int width, int height, boolean standalone, boolean isEmpty) {
        return !standalone && isEmpty ? NetUtils.getRoundedRect(c, x, y, width, height, CELL_ROUNDING, 7) : NetUtils.getRoundedRect(c, x, y, width, height, CELL_ROUNDING, 7, 5);
    }

    private void paintBottomRule(Graphics g, int x, int y, int width, int height, boolean headerGroup) {
        g.setColor(UIManager.getColor(headerGroup ? "Table.headerGroupRule" : "Table.bottomRuleColor"));
        g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
    }

    private void paintVerticalGridLine(Graphics g, JComponent comp, int x, int y, int height) {
        boolean enabled = ClientPropertyUtil.booleanValue(comp, "TableHeader.isEnabled", true);
        g.setColor(UIManager.getColor(enabled ? "Table.GridVertical" : "Table.bottomRuleColor"));
        g.drawLine(x, y + 2, x, y + height - 2);
        if (enabled) {
            g.setColor(NetLookAndFeel.getWhite());
            g.drawLine(x, y + 1, x, y + 1);
        }
    }

    private void paintMiddleCellBorder(JComponent comp, Graphics g, int x, int y, int width, int height, boolean standalone) {
        boolean enabled;
        if (!standalone) {
            g.setColor(UIManager.getColor("Table.dialogBottomOutline"));
        }
        g.drawRect(x, y, width - 1, height - 1);
        boolean header = ClientPropertyUtil.booleanValue(comp, "Table.isBelowHeaderGroup", false);
        if (header) {
            g.setColor(UIManager.getColor("Table.headerGroupRule"));
            g.drawLine(x, y, x + width - 1, y);
        }
        g.setColor(UIManager.getColor((enabled = ClientPropertyUtil.booleanValue(comp, "TableHeader.isEnabled", true)) ? "TableHeader.outlineColor" : "Table.bottomRuleColor"));
        g.drawLine(x, y + 1, x, y + height - 1);
    }
}

