/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.borders;

import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class NetTextAreaBorder
extends BaseBorder {
    private static final int STATUS_AREA_WIDTH = 31;

    public NetTextAreaBorder() {
        super(new Insets(2, 2, 2, 20));
    }

    public NetTextAreaBorder(int top, int left, int bottom, int right) {
        super(top, left, bottom, right);
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        return this.getBorderInsets(comp, new Insets(0, 0, 0, 0));
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        Object oldAa = NetUtils.antiAliasingOn(g2d);
        JComponent component = (JComponent)c;
        boolean istextComponent = component instanceof JTextComponent;
        if (!istextComponent || !((JTextComponent)component).isEditable()) {
            return;
        }
        this.paintStatusArea(g2d, component);
        NetUtils.setAntialiasing(g2d, oldAa);
    }

    public void paintStatusArea(Graphics2D g2d, JComponent component) {
        if (ComponentUtils.isRequiredButMissing(component)) {
            NetUtils.paintMandatoryAsterisk(g2d, component, ComponentUtils.isSmall(component) ? 3 : 0, 12 - component.getHeight() / 2);
        } else if (this.isPenIconShown(component)) {
            Rectangle visibleRectangle = component.getVisibleRect();
            int yOffset = (int)visibleRectangle.getMinY();
            ImageIcon editIcon = CommonIcons.getIcon(component, CommonIcons.getEditIcon());
            this.paintIconToStatusArea(g2d, component, editIcon, ComponentUtils.isSmall(component) ? -4 : 4, yOffset);
        }
    }

    private boolean isPenIconShown(JComponent component) {
        JComponent componentToCheck = component;
        return Boolean.TRUE.equals(componentToCheck.getClientProperty("BlueTouch.isModified"));
    }

    private void paintIconToStatusArea(Graphics2D g2d, JComponent component, Icon icon, int xOffset, int yOffset) {
        icon.paintIcon(component, g2d, component.getWidth() - NetTextAreaBorder.getStatusAreaWidth(component) + icon.getIconWidth() / 2 + xOffset, yOffset);
    }

    private static int getStatusAreaWidth(JComponent comp) {
        return ComponentUtils.isSmall(comp) ? 21 : 31;
    }
}

