/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.borders;

import com.nokia.laf.NetBorderFactory;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.icons.ScaledIcon;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RectangularShape;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class NetTextFieldBorder
extends BaseBorder {
    private static Icon FLASH_ICON = NetUtils.loadIcon("error_flash.png");
    private static Icon SMALL_FLASH_ICON = ScaledIcon.create(NetUtils.loadIcon("error_flash.png"), 13);
    private static final int STATUS_AREA_WIDTH = 31;
    private static Insets SEARCH_FIELD_INSETS = new Insets(2, 28, 2, 20);
    private static Insets SEARCH_FIELD_SMALL_INSETS = new Insets(2, 20, 1, 20);
    private static Insets SEARCH_FIELD_DROPDOWN_INSETS = new Insets(2, 38, 2, 20);
    private static Insets SEARCH_FIELD_DROPDOWN_SMALL_INSETS = new Insets(2, 30, 1, 20);
    private static Insets TABLE_INSETS = new Insets(2, 0, 2, 0);
    protected boolean myPaintBottomHighlight = true;

    public NetTextFieldBorder() {
        super(new Insets(2, 2, 2, 20));
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        return this.getBorderInsets(comp, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component comp, Insets newInsets) {
        if (NetUtils.isTableEditorTextField(comp)) {
            return TABLE_INSETS;
        }
        if (this.isSearchField(comp)) {
            if (this.isDropdownEnabled(comp)) {
                return ComponentUtils.isSmall(comp) ? SEARCH_FIELD_DROPDOWN_SMALL_INSETS : SEARCH_FIELD_DROPDOWN_INSETS;
            }
            return ComponentUtils.isSmall(comp) ? SEARCH_FIELD_SMALL_INSETS : SEARCH_FIELD_INSETS;
        }
        if (ComponentUtils.isSmall(comp)) {
            return new Insets(2, 0, this.myPaintBottomHighlight && !ComponentUtils.isSmall(comp) ? 2 : 1, 10);
        }
        return super.getBorderInsets(comp, newInsets);
    }

    private boolean isSearchField(Component comp) {
        return ClientPropertyUtil.booleanValue((JComponent)comp, "OrangeTouch.searchField");
    }

    public NetTextFieldBorder(int top, int left, int bottom, int right) {
        super(top, left, bottom, right);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        Object oldAa = NetUtils.antiAliasingOn(g2d);
        JComponent component = (JComponent)c;
        boolean textComponent = component instanceof JTextComponent;
        if (!textComponent) {
            return;
        }
        if (textComponent && !((JTextComponent)component).isEditable()) {
            return;
        }
        if (c.getParent() instanceof JTable) {
            NetBorderFactory.getBasicNetBorder(NetLookAndFeel.getFocusColor()).paintBorder(component, g2d, 1, 1, width - 2, height - 2);
            return;
        }
        this.paintLeadingIcon(g, component);
        int rounding = NetTheme.getComponentOutlineRounding(component);
        boolean openRightEdge = ClientPropertyUtil.booleanValue(component, "OrangeTouch.openRightEdge");
        if (component.isEnabled() && !ComponentUtils.isReadOnly(component)) {
            this.drawTopHighlight(g, component, x, y, width, height, rounding, openRightEdge);
            this.drawBottomHighlight(g, component, x, y, width, height, rounding);
        }
        this.drawMainOutline(g2d, component, x, y, width, height, rounding, openRightEdge);
        if (!(component.getParent() instanceof JTable) && !NetUtils.isTableCellEditor(component)) {
            this.paintStatusArea(g2d, component);
        }
        NetUtils.setAntialiasing(g2d, oldAa);
    }

    protected void paintLeadingIcon(Graphics g, JComponent component) {
        if (!this.isSearchField(component)) {
            return;
        }
        Icon searchIcon = this.getLeadingIcon(component);
        if (!component.isEnabled()) {
            searchIcon = UIManager.getLookAndFeel().getDisabledIcon(component, searchIcon);
        }
        searchIcon.paintIcon(component, g, ComponentUtils.isSmall(component) ? 5 : 10, component.getHeight() / 2 - searchIcon.getIconHeight() / 2);
    }

    private ImageIcon getLeadingIcon(JComponent component) {
        if (ClientPropertyUtil.booleanValue(component, "OrangeTouch.useFilterIconInSearchField")) {
            return CommonIcons.getFilterIcon();
        }
        return CommonIcons.getSearchIcon();
    }

    protected void drawTopHighlight(Graphics g, JComponent comp, int x, int y, int width, int height, int rounding, boolean openRightEdge) {
        Color topHighlight = UIManager.getColor("TextField.topHighlight");
        g.setColor(topHighlight);
        Shape oldClip = g.getClip();
        int topWidth = openRightEdge ? width : width - 1;
        Shape shape = null;
        if (openRightEdge) {
            shape = NetUtils.getRoundedPath(null, x + 1, y + 1, width + 1000, height - rounding / 2, rounding - 1, 5, true);
            g.clipRect(x, y, topWidth, height);
        } else if (this.isSearchField(comp)) {
            shape = NetUtils.getRoundedPath(null, x, y + 1, width, height - rounding / 2, height - 2, 5, true);
            g.clipRect(x, y, topWidth, height / 2);
        } else {
            shape = NetUtils.getRoundedPath(comp, x + 1, y + 1, width - 1, height - rounding / 2, rounding - 2, 5, true);
            g.clipRect(x, y, topWidth, height - 4);
        }
        ((Graphics2D)g).draw(shape);
        g.setClip(oldClip);
    }

    protected void drawBottomHighlight(Graphics g, JComponent comp, int x, int y, int width, int height, int rounding) {
        int tempX = x;
        int tempWidth = width;
        if (ClientPropertyUtil.booleanValue(comp, "JComboBox.isTableCellEditor") || !this.myPaintBottomHighlight) {
            return;
        }
        boolean rollovered = ComponentUtils.isRollovered(comp);
        Color bottomHighlight = UIManager.getColor("TextField.bottomHighlight");
        g.setColor(bottomHighlight);
        if (this.isSearchField(comp)) {
            tempX += 4;
            tempWidth -= 8;
        }
        Shape oldClip = g.getClip();
        g.clipRect(tempX, y + height - 5, tempWidth, height);
        Object oldAa = NetUtils.antiAliasingOn(g);
        boolean openRightEdge = ClientPropertyUtil.booleanValue(comp, "OrangeTouch.openRightEdge");
        if (openRightEdge) {
            g.drawRoundRect(tempX, y, tempWidth + 12, y + height - 1, rounding + 2, rounding + 2);
        } else {
            g.drawRoundRect(tempX, y, tempWidth - 1, y + height - 1, rounding + 2, rounding + 2);
        }
        if (rollovered) {
            Color hover = ((Color[])UIManager.get("Button.hoverShadow"))[0];
            g.setColor(hover);
            g.drawRoundRect(tempX, y, tempWidth - 1, y + height - 1, rounding + 2, rounding + 2);
        }
        NetUtils.setAntialiasing(g, oldAa);
        g.setClip(oldClip);
    }

    private void drawMainOutline(Graphics2D g2d, JComponent component, int x, int y, int width, int height, int rounding, boolean openRightEdge) {
        Color specialOutline;
        int heightOffset;
        int tempWidth = width;
        int tempHeight = height;
        boolean openBottomEdge = ClientPropertyUtil.booleanValue(component, "OrangeTouch.openBottomEdge");
        boolean isSearchField = ClientPropertyUtil.booleanValue(component, "OrangeTouch.searchField");
        boolean isClearIconHovered = ClientPropertyUtil.booleanValue(component, "OrangeTouch.clearIconHovered");
        boolean isMultiLanguageIconUse = NetTextFieldBorder.isMultiLanguageIconUsed(component);
        if (openRightEdge) {
            tempWidth += 1000;
        }
        if (openBottomEdge) {
            tempHeight += 1000;
        }
        boolean isTableEditor = NetUtils.isTableEditorTextField(component);
        int n = heightOffset = openBottomEdge ? 1000 : 0;
        if (this.myPaintBottomHighlight && !isTableEditor) {
            heightOffset = -1;
        }
        int widthOffset = 0;
        if (isMultiLanguageIconUse) {
            widthOffset = -34;
        } else if (openRightEdge) {
            widthOffset = 1000;
        }
        RectangularShape borderShape = NetUtils.getOutline(component, widthOffset, heightOffset);
        boolean readonly = ComponentUtils.isReadOnly(component);
        if (!component.isEnabled() || readonly) {
            g2d.setColor(NetTheme.getDisabledComponentOutlineColor());
            g2d.draw(borderShape);
        } else if (!(component.isFocusOwner() || !isClearIconHovered && ComponentUtils.isRollovered(component))) {
            Color[] top = (Color[])UIManager.get("TextField.topOutline");
            Color[] bottom = (Color[])UIManager.get("TextField.bottomOutline");
            NetUtils.drawRoundedRect(g2d, top, bottom, x, y, tempWidth - 1, tempHeight - (this.myPaintBottomHighlight ? 2 : 1), isSearchField ? component.getHeight() - 1 : rounding);
        }
        boolean showErrorIcon = ClientPropertyUtil.booleanValue(component, "OrangeTouch.displayErrorIcon", true);
        Shape oldClip = null;
        if (ComponentUtils.isInvalid(component) && showErrorIcon && !isTableEditor) {
            oldClip = g2d.getClip();
            g2d.clipRect(0, 0, component.getWidth() - NetTextFieldBorder.getStatusAreaWidth(component) / 2, component.getHeight());
        }
        if ((specialOutline = this.getSpecialOutline(component, isClearIconHovered, isTableEditor)) != null && !readonly) {
            g2d.setColor(specialOutline);
            g2d.draw(borderShape);
        }
        if (oldClip != null) {
            g2d.setClip(oldClip);
        }
    }

    private static boolean isMultiLanguageIconUsed(JComponent component) {
        return ClientPropertyUtil.booleanValue(component, "Multi-language");
    }

    private Color getSpecialOutline(JComponent component, boolean isClearIconHovered, boolean isTableEditor) {
        if (ComponentUtils.isRollovered(component) && !isClearIconHovered && !isTableEditor) {
            return NetTheme.getHoverColor();
        }
        if (component.isFocusOwner() && component.isEnabled()) {
            return NetLookAndFeel.getCurrentTheme().getFocusColor();
        }
        return null;
    }

    public void paintStatusArea(Graphics2D g2d, JComponent component) {
        boolean progressOngoing = ClientPropertyUtil.booleanValue(component, "OrangeTouch.progressOngoing", false);
        if (progressOngoing) {
            this.paintIconToStatusArea(g2d, component, CommonIcons.getProgressOngoingIcon(), ComponentUtils.isSmall(component) ? -5 : 0, 0);
            return;
        }
        boolean showErrorIcon = ClientPropertyUtil.booleanValue(component, "OrangeTouch.displayErrorIcon", true);
        Insets insets = component.getInsets();
        int yOffset = insets.top - insets.bottom - 1;
        if (ComponentUtils.isRequiredButMissing(component)) {
            int xOffSet = NetTextFieldBorder.isMultiLanguageIconUsed(component) ? -34 : 0;
            NetUtils.paintMandatoryAsterisk(g2d, component, (ComponentUtils.isSmall(component) ? 3 : 0) + xOffSet, ComponentUtils.isSmall(component) ? yOffset : 0);
        } else if (ComponentUtils.isInvalid(component) && showErrorIcon) {
            this.paintInvalidIndication(g2d, component);
        } else if (this.isPenIconShown(component)) {
            ImageIcon editIcon = CommonIcons.getIcon(component, CommonIcons.getEditIcon());
            this.paintIconToStatusArea(g2d, component, editIcon, ComponentUtils.isSmall(component) ? -4 : 4, yOffset);
        } else if (ClientPropertyUtil.booleanValue(component, "OrangeTouch.displayValidValue")) {
            if (ComponentUtils.isSmall(component)) {
                this.paintIconToStatusArea(g2d, component, ScaledIcon.create(CommonIcons.getOkIcon(), 14), -4, 0);
            } else {
                this.paintIconToStatusArea(g2d, component, CommonIcons.getOkIcon(), 4, 0);
            }
        }
    }

    private void paintInvalidIndication(Graphics2D g, JComponent component) {
        boolean openRightEdge = ClientPropertyUtil.booleanValue(component, "OrangeTouch.openRightEdge");
        RectangularShape outline = openRightEdge ? new Rectangle(1, 0, component.getWidth() + 1, component.getHeight()) : NetUtils.getOutline(component, 1, 0);
        Shape oldClip = g.getClip();
        int statusAreaWidth = NetTextFieldBorder.getStatusAreaWidth(component);
        g.clipRect(component.getWidth() - statusAreaWidth + 2, 0, statusAreaWidth + 100, component.getHeight());
        if (component.isEnabled()) {
            GradientUtils.drawVerticalGradient(component, (Graphics)g, "TextField.invalidStripe", (Shape)outline);
        } else {
            g.setColor(UIManager.getColor("TextField.invalidStripeDisabled"));
            g.fill(outline);
        }
        g.setClip(oldClip);
        if (ComponentUtils.isSmall(component)) {
            this.paintIconToStatusArea(g, component, SMALL_FLASH_ICON, -1, -1);
        } else {
            this.paintIconToStatusArea(g, component, FLASH_ICON, 0, 0);
        }
    }

    private boolean isPenIconShown(JComponent component) {
        JComponent componentToCheck = component;
        if (this.isEditorInCompositeComponent(component)) {
            componentToCheck = (JComponent)component.getParent();
        }
        return Boolean.TRUE.equals(componentToCheck.getClientProperty("BlueTouch.isModified"));
    }

    private boolean isEditorInCompositeComponent(JComponent component) {
        return component.getParent() instanceof JSpinner || component.getParent() instanceof JComboBox && ((JComboBox)component.getParent()).isEditable();
    }

    private void paintIconToStatusArea(Graphics2D g2d, JComponent component, Icon icon, int xOffset, int yOffset) {
        icon.paintIcon(component, g2d, component.getWidth() - NetTextFieldBorder.getStatusAreaWidth(component) + icon.getIconWidth() / 2 + xOffset, component.getHeight() / 2 - icon.getIconHeight() / 2 + yOffset);
    }

    private static int getStatusAreaWidth(JComponent comp) {
        int offset = NetTextFieldBorder.isMultiLanguageIconUsed(comp) ? -34 : 0;
        return (ComponentUtils.isSmall(comp) ? 21 : 31) - offset;
    }

    private boolean isDropdownEnabled(Component comp) {
        return ClientPropertyUtil.booleanValue((JComponent)comp, "OceanTouch.searchDropdown");
    }
}

