/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.borders;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.table.PTable;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class TablePanelBorder
extends BaseBorder {
    private static final int ROUNDING = NetTheme.getNormalRounding();

    public TablePanelBorder() {
        super(2, 2, 6, 2);
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        return this.getBorderInsets(comp, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component comp, Insets newInsets) {
        super.getBorderInsets(comp, newInsets);
        if (!TablePanelBorder.isPTable(comp)) {
            newInsets.left = 1;
            newInsets.right = 1;
        }
        if (comp instanceof JTable) {
            newInsets.top = 0;
            newInsets.bottom = 6;
            newInsets.left = 3;
            newInsets.right = 2;
        } else if (comp instanceof JTableHeader) {
            newInsets.bottom = 0;
            newInsets.right = 3;
            newInsets.left = 2;
        }
        return newInsets;
    }

    @Override
    public void paintBorder(Component comp, Graphics g, int x, int y, int width, int height) {
        int tempX = x;
        int tempY = y;
        int tempWidth = width;
        int tempHeight = height;
        Object oldAa = NetUtils.antiAliasingOn(g);
        Color oldColor = g.getColor();
        boolean isPTable = TablePanelBorder.isPTable(comp);
        if (comp instanceof JTable) {
            JTable table = (JTable)comp;
            Insets insets = table.getInsets();
            int left = insets.left;
            int bottom = insets.bottom;
            int offset = isPTable ? 0 : 2;
            int heightoffset = table.getRowCount() == 0 ? 1 : 0;
            int bottomCapY = tempHeight - bottom - heightoffset;
            int bottomCapX = tempX + left - 1;
            int bottomCapWidth = tempWidth - left - insets.right + 1 + offset;
            int bottomCapHeight = 4 + heightoffset;
            Shape bottomShape = NetUtils.getRoundedPath(table, bottomCapX, bottomCapY, bottomCapWidth, bottomCapHeight, ROUNDING, 1, true);
            g.setColor(this.getBottomCapFillColor(table));
            if (table.isEnabled() || table.getRowCount() > 0) {
                ((Graphics2D)g).fill(bottomShape);
            }
            Shape oldClip = g.getClip();
            g.clipRect(tempX, tempY, tempWidth, tempY + tempHeight - 6);
            g.setColor(NetUtils.getTableOutlineColor(table));
            Shape outline = NetUtils.getRoundedPath(table, bottomCapX, tempY, bottomCapWidth, tempY + tempHeight - bottom + 4, ROUNDING, 1, true);
            ((Graphics2D)g).draw(outline);
            g.setClip(oldClip);
            g.clipRect(tempX, tempY + tempHeight - 6, tempWidth, 6);
            g.setColor(UIManager.getColor(NetUtils.isInDialog(table) ? "Table.dialogBottomOutline" : "Table.bottomOutline"));
            ((Graphics2D)g).draw(outline);
            g.setClip(oldClip);
            this.paintGridLines(g, table, tempHeight, bottom);
            if (!comp.isEnabled()) {
                return;
            }
            if (NetUtils.isNotNullAndVisible(table.getTableHeader())) {
                tempY -= 1000;
                tempHeight += 1000;
            }
        } else if (comp instanceof JTableHeader) {
            JTableHeader header = (JTableHeader)comp;
            if (header.getTable() != null && !header.getTable().isEnabled()) {
                return;
            }
            tempHeight += 1000;
        }
        if (comp instanceof JTableHeader && !isPTable) {
            --tempX;
            tempWidth += 3;
        }
        Insets shadowSize = this.getShadowSize(comp);
        NetUtils.drawTableShadow(comp, g, tempX, tempY, tempWidth, tempHeight, shadowSize, ROUNDING);
        NetUtils.setAntialiasing(g, oldAa);
        g.setColor(oldColor);
    }

    private static boolean isPTable(Component comp) {
        if (comp instanceof JTable) {
            return comp instanceof PTable;
        }
        if (comp instanceof JTableHeader) {
            return ((JTableHeader)comp).getTable() instanceof PTable;
        }
        return false;
    }

    protected Insets getShadowSize(Component c) {
        if (!TablePanelBorder.isPTable(c)) {
            return c instanceof JTableHeader ? new Insets(2, 2, 2, 2) : new Insets(1, 1, 2, 1);
        }
        return new Insets(2, 2, 2, 2);
    }

    protected Color getBottomCapFillColor(JTable table) {
        if (!table.isEnabled()) {
            return NetTheme.getMidGrayOutline();
        }
        boolean isAlternate = ClientPropertyUtil.booleanValue(table, "OrangeTouch.alternate", true);
        return table.getRowCount() == 0 || table.getRowCount() % 2 == 0 || !isAlternate ? NetLookAndFeel.getWhite() : UIManager.getColor("Table.UnEditableRowBackground2");
    }

    private void paintGridLines(Graphics g, JTable table, int height, int bottomHeight) {
        boolean useCustomGridColor;
        if (table.getRowCount() <= 0 || !table.getShowVerticalLines()) {
            return;
        }
        int draggedColumnIndex = this.getDraggedColumnIndex(table);
        boolean bl = useCustomGridColor = !(table.getGridColor() instanceof UIResource);
        g.setColor(useCustomGridColor ? table.getGridColor() : UIManager.getColor(table.isEnabled() ? "Table.UnEditableGridVertical" : "Table.bottomRuleColor"));
        int idx = 0;
        while (idx < table.getColumnCount() - 1) {
            if (draggedColumnIndex != idx) {
                Rectangle cellRect = table.getCellRect(0, idx, false);
                if (cellRect.width > 0) {
                    g.drawLine(cellRect.x + cellRect.width, height - bottomHeight - 1, cellRect.x + cellRect.width, height - bottomHeight + 2);
                }
            }
            ++idx;
        }
    }

    protected int getDraggedColumnIndex(JTable table) {
        JTableHeader header = table.getTableHeader();
        TableColumn draggedColumn = header != null ? header.getDraggedColumn() : null;
        return draggedColumn == null ? -1 : table.convertColumnIndexToView(draggedColumn.getModelIndex());
    }
}

