/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.borders;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;

public class TableShadowBorder
extends BaseBorder {
    private static Border SPLITPANE_BORDER = new SplitPaneFloatingBorder();
    private static final int ROUNDING = NetTheme.getNormalRounding();

    public TableShadowBorder() {
        super(2, 2, 2, 2);
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        return this.getBorderInsets(comp, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component comp, Insets result) {
        JTable table;
        JScrollPane scroll;
        if (comp instanceof JScrollPane && (scroll = (JScrollPane)comp).getViewport().getView() instanceof JTable && !ComponentUtils.isStandalone(table = (JTable)scroll.getViewport().getView())) {
            result.top = 1;
            result.left = 0;
            result.right = 0;
            result.bottom = 0;
            return result;
        }
        if (comp.getParent() instanceof JSplitPane) {
            Insets floatingPaneInsets = SPLITPANE_BORDER.getBorderInsets(comp);
            result.top = floatingPaneInsets.top;
            result.left = floatingPaneInsets.left;
            result.right = floatingPaneInsets.right;
            result.bottom = floatingPaneInsets.bottom;
            return result;
        }
        return super.getBorderInsets(comp, result);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        JScrollPane scroll;
        Component view;
        if (c.getParent() instanceof JSplitPane) {
            SPLITPANE_BORDER.paintBorder(c, g, x, y, width, height);
            return;
        }
        if (c instanceof JScrollPane && (view = (scroll = (JScrollPane)c).getViewport().getView()) instanceof JTable) {
            JTable table = (JTable)view;
            if (!table.isEnabled()) {
                return;
            }
            if (!ComponentUtils.isStandalone(table)) {
                g.setColor(UIManager.getColor("TextComponent.disabledFill"));
                g.drawLine(x + 5, y, x + width - 7, y);
                return;
            }
        }
        NetUtils.drawTableShadow(c, g, x, y, width, height, this.getBorderInsets(c), ROUNDING);
    }

    private static class SplitPaneFloatingBorder
    extends AbstractBorder {
        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 0;
            insets.left = 2;
            insets.bottom = 5;
            insets.right = 2;
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            ColorUIResource outline = NetLookAndFeel.getWhite();
            Color[] bottomGradient = new Color[]{outline, outline};
            Shape oldClip = g.getClip();
            int bottomHeight = 8;
            g.clipRect(y, y + height - bottomHeight, width, bottomHeight);
            Shape bottom = NetUtils.getRoundedPath((JComponent)c, x + 3, y + height - 1 - bottomHeight - 1, width - 6, bottomHeight - 1, ROUNDING, 1, false);
            GradientUtils.drawVerticalGradientOutline((JComponent)c, g, bottomGradient, bottom);
            g.setClip(oldClip);
            Color[] shadow = (Color[])UIManager.get("FloatingPane.shadow");
            NetUtils.drawDropShadow((Graphics2D)g, shadow, new Insets(1, 2, 3, 2), x, y, width, height, ROUNDING);
        }
    }
}

