/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.combobox;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class ComboBoxViewportBorder
extends AbstractBorder {
    private JComboBox myComboBox;

    public ComboBoxViewportBorder(JComboBox combo) {
        this.myComboBox = combo;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int height) {
        JScrollPane scroll = (JScrollPane)c;
        int width = w;
        if (NetUtils.isNotNullAndVisible(scroll.getVerticalScrollBar())) {
            width += 10;
        }
        boolean popupAboveCombo = ClientPropertyUtil.booleanValue(this.myComboBox, "OrangeTouch.popupAboveCombo");
        Color background = UIManager.getColor("ComboBox.background");
        Color outline = this.getOutlineColor();
        NetUtils.drawRoundRectWithFilledCap(scroll, g, x, y, width, height, background, outline, popupAboveCombo ? 5 : 1);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets insets = new Insets(1, 1, 5, 1);
        if (ClientPropertyUtil.booleanValue(this.myComboBox, "OrangeTouch.popupAboveCombo")) {
            insets.top = 5;
            insets.bottom = 1;
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    private Color getOutlineColor() {
        return NetUtils.isFocused(this.myComboBox) ? NetLookAndFeel.getCurrentTheme().getFocusColor() : NetTheme.getComponentOutlineColor();
    }
}

