/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.combobox;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.ImageUtils;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.table.JTableHeader;

public class NetComboBoxButton
extends MetalComboBoxButton
implements PropertyChangeListener {
    private static final int STATUS_AREA_WIDTH = 52;
    private static Icon FLASH_ICON = NetUtils.loadIcon("error_flash.png");
    private boolean myUISettingTooltip = false;

    public NetComboBoxButton(final JComboBox comboBox, Icon icon, boolean onlyIcon, CellRendererPane cellrendererpane, JList list, boolean isTableCellEditor) {
        super(comboBox, icon, onlyIcon, cellrendererpane, list);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                comboBox.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                comboBox.repaint();
            }
        });
        this.changeIconOnly();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setBackground(UIManager.getColor("ComboBox.buttonBackground"));
        }
    }

    public void paintComponentImpl(Graphics g) {
        boolean leftToRight = ComponentUtils.isLeftToRight(this.comboBox);
        if (this.ui != null) {
            Graphics scratchGraphics = g == null ? null : g.create();
            try {
                this.ui.update(scratchGraphics, this);
            }
            finally {
                if (scratchGraphics != null) {
                    scratchGraphics.dispose();
                }
            }
        }
        Insets insets = this.getInsets();
        int width = this.getWidth() - (insets.left + insets.right);
        int height = this.getHeight() - (insets.top + insets.bottom);
        if (height <= 0 || width <= 0) {
            if (width < 0) {
                this.comboIcon.paintIcon(this, g, 0, this.getHeight() / 2 - this.comboIcon.getIconHeight() / 2);
            }
            return;
        }
        int left = insets.left;
        int top = insets.top;
        int right = left + (width - 1);
        int bottom = top + (height - 1);
        int iconWidth = 0;
        int iconLeft = leftToRight ? right : left;
        boolean small = ComponentUtils.isSmall(this.comboBox);
        if (this.comboIcon != null) {
            iconWidth = this.comboIcon.getIconWidth();
            int iconHeight = this.comboIcon.getIconHeight();
            int iconTop = 0;
            if (this.iconOnly) {
                iconLeft = this.getWidth() / 2 - iconWidth / 2 - 2;
                iconTop = this.getHeight() / 2 - iconHeight / 2 + 1;
            } else {
                iconTop = top + (bottom - top) / 2 - iconHeight / 2;
                if (leftToRight) {
                    iconLeft = left + (width - 1) - this.getHeight() / 4 + 1;
                    if (small) {
                        iconLeft += 2;
                        iconLeft = Math.max(2, iconLeft);
                    }
                } else {
                    iconLeft = left;
                }
            }
            this.comboIcon.paintIcon(this, g, iconLeft, iconTop);
        }
        if (!NetUtils.isFocused(this.comboBox) && this.comboBox.isEnabled() && !ComponentUtils.isReadOnly(this.comboBox) && !this.comboBox.isPopupVisible()) {
            this.paintTopHighlight(g);
        }
        this.paintVerticalLine(g, height);
        if (!this.comboBox.isEditable()) {
            this.paintStatusArea((Graphics2D)g, this, this.comboBox.getSelectedItem());
        }
        if (!this.iconOnly && this.comboBox != null) {
            ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
            boolean selected = this.getModel().isPressed() || NetUtils.isFocused(this.comboBox);
            Component component = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, selected, false);
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(false);
            }
            component.setFont(this.rendererPane.getFont());
            if (this.model.isArmed() && this.model.isPressed()) {
                if (this.isOpaque()) {
                    component.setBackground(UIManager.getColor("Button.select"));
                }
            } else if (!this.comboBox.isEnabled()) {
                if (this.isOpaque()) {
                    component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                }
                component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            } else {
                component.setBackground(this.comboBox.getBackground());
            }
            if (this.getModel().isRollover()) {
                component.setForeground(NetUtils.isFocused(this.comboBox) ? NetLookAndFeel.getWhite() : NetTheme.getTextHoverColor());
            }
            if (selected) {
                component.setForeground(NetLookAndFeel.getWhite());
            }
            int cWidth = width - iconWidth;
            boolean shouldValidate = false;
            boolean oldEnabled = component.isEnabled();
            if (component instanceof JPanel) {
                shouldValidate = true;
            } else if (component instanceof JLabel) {
                ((JLabel)component).putClientProperty("Label.isDark", NetUtils.isFocused(this.comboBox));
                component.setEnabled(this.comboBox.isEnabled());
                if (this.comboBox.isEnabled()) {
                    ((JLabel)component).putClientProperty("OrangeTouch.labelOffsetColor", NetUtils.isFocused(this.comboBox) ? Color.BLACK : NetTheme.getTextShadowColor());
                }
            }
            if (leftToRight) {
                this.rendererPane.paintComponent(g, component, this, left, top, cWidth, height, shouldValidate);
            } else {
                this.rendererPane.paintComponent(g, component, this, left + iconWidth, top, cWidth, height, shouldValidate);
            }
            component.setEnabled(oldEnabled);
            if (component instanceof JComponent) {
                JComponent jComp = (JComponent)component;
                jComp.setOpaque(true);
                jComp.putClientProperty("List.isSelected", false);
                ((JComponent)component).putClientProperty("OrangeTouch.labelOffsetColor", null);
                if (this.comboBox.getClientProperty("OrangeTouch.tooltipSetByClient") == null) {
                    this.myUISettingTooltip = true;
                    this.comboBox.setToolTipText(jComp.getToolTipText());
                    this.myUISettingTooltip = false;
                }
                jComp.putClientProperty("Label.isRollover", null);
                jComp.putClientProperty("Label.isDark", null);
            }
        }
    }

    private void paintTopHighlight(Graphics g) {
        int rounding = NetTheme.getComponentOutlineRounding(this.comboBox);
        g.setColor(NetLookAndFeel.getWhite());
        if (this.comboBox.isEditable()) {
            g.drawLine(0, 1, this.getWidth() - rounding / 2 - 3, 1);
        } else {
            g.drawLine(rounding / 2 + 1, 1, this.getWidth() - rounding / 2 - 1, 1);
        }
    }

    @Override
    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
        if (this.comboBox.isEditable() && this.comboBox.isEnabled() && (this.getModel().isRollover() || this.isEditorHovered()) && !this.comboBox.getUI().isPopupVisible(this.comboBox)) {
            Color oldColor = g.getColor();
            g.setColor(NetTheme.getHoverColor());
            g.drawLine(0, 0, 0, 0);
            g.drawLine(0, this.getHeight() - 1, 0, this.getHeight() - 1);
            g.setColor(oldColor);
        }
    }

    public void paintStatusArea(Graphics2D g2d, JComponent component, Object value) {
        boolean showErrorIcon = ClientPropertyUtil.booleanValue(component, "OrangeTouch.displayErrorIcon", true);
        int offset = -(Math.min(23, this.getHeight()) - 7);
        if (ComponentUtils.isRequiredButMissing(this.comboBox)) {
            if (!(this.comboBox.getParent() instanceof JTable)) {
                NetUtils.paintMandatoryAsterisk(g2d, component, offset, 1);
            }
        } else if (ComponentUtils.isInvalid(this.comboBox) && showErrorIcon) {
            RectangularShape outline = NetUtils.getOutline(component, 1, 0);
            Shape storedClip = g2d.getClip();
            g2d.clipRect(component.getWidth() - 52, 0, 152, component.getHeight());
            if (component.isEnabled()) {
                GradientUtils.drawVerticalGradient(component, (Graphics)g2d, "TextField.invalidStripe", (Shape)outline);
            } else {
                g2d.setColor(UIManager.getColor("TextField.invalidStripeDisabled"));
                g2d.fill(outline);
            }
            g2d.setClip(storedClip);
            NetComboBoxButton.paintIconToStatusArea(g2d, component, FLASH_ICON, offset, 0);
        } else {
            boolean modified = Boolean.TRUE.equals(this.comboBox.getClientProperty("BlueTouch.isModified"));
            if (modified && !this.comboBox.isEditable()) {
                ImageIcon icon = CommonIcons.getIcon(component, CommonIcons.getEditIcon());
                if (this.comboBox.isFocusOwner() && !SystemUtils.isOrangeTouch()) {
                    icon = ImageUtils.createSolidColorIcon(component, icon, Color.decode("#6DBFF5"));
                }
                NetComboBoxButton.paintIconToStatusArea(g2d, component, icon, offset, 0);
            }
        }
    }

    private static void paintIconToStatusArea(Graphics2D g2d, JComponent comp, Icon icon, int xOffset, int yOffset) {
        icon.paintIcon(comp, g2d, comp.getWidth() - 21 + xOffset + 2, comp.getHeight() / 2 - icon.getIconHeight() / 2 + yOffset);
    }

    private void paintVerticalLine(Graphics g, int height) {
        Color verticalLineColor = UIManager.getColor("ComboBox.separatorColor");
        if (!this.comboBox.isEnabled() || ComponentUtils.isReadOnly(this.comboBox)) {
            verticalLineColor = NetTheme.getDisabledComponentOutlineColor();
        } else if (!(!this.getModel().isRollover() && !this.isEditorHovered() || this.comboBox.getUI().isPopupVisible(this.comboBox) || NetUtils.isTableCellEditor(this.comboBox) && !(this.comboBox.getParent() instanceof JTableHeader))) {
            verticalLineColor = NetTheme.getHoverColor();
        } else if (this.comboBox.isFocusOwner()) {
            verticalLineColor = UIManager.getColor("ComboBox.separatorColor2");
        }
        g.setColor(verticalLineColor);
        int xPos = this.getVerticalLineLocation();
        g.drawLine(xPos, 0, xPos, height);
        if (this.comboBox.isFocusOwner()) {
            g.setColor(NetLookAndFeel.getCurrentTheme().getFocusColor());
        } else if (this.comboBox.isEnabled()) {
            g.setColor(NetLookAndFeel.getWhite());
        }
        if (this.comboBox.isEnabled() && !ComponentUtils.isReadOnly(this.comboBox)) {
            g.drawLine(xPos - 1, 0, xPos - 1, height);
        }
    }

    private int getVerticalLineLocation() {
        if (NetUtils.isTableCellEditor(this.comboBox) && !this.comboBox.isEditable()) {
            return this.getWidth() - 14;
        }
        if (!this.comboBox.isEditable() || !this.comboBox.isEnabled() || ComponentUtils.isReadOnly(this.comboBox)) {
            return this.getWidth() - Math.min(this.getHeight(), 23) + 1;
        }
        return 0;
    }

    private boolean isEditorHovered() {
        Component editor = this.comboBox.getEditor().getEditorComponent();
        return this.comboBox.isEditable() && editor instanceof JComponent && ComponentUtils.isRollovered((JComponent)editor) && !ClientPropertyUtil.booleanValue((JComponent)editor, "OrangeTouch.clearIconHovered");
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintComponentImpl(g);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("enabled".equals(evt.getPropertyName()) || "OrangeTouch.readOnly".equals(evt.getPropertyName()) || "editable".equals(evt.getPropertyName())) {
            this.changeIconOnly();
        } else if (evt.getPropertyName().equals("ToolTipText") && !this.myUISettingTooltip) {
            this.comboBox.putClientProperty("OrangeTouch.tooltipSetByClient", evt.getNewValue());
        }
    }

    @Override
    public String getUIClassID() {
        return "ComboBox.ButtonUI";
    }

    private void changeIconOnly() {
        if ((!this.comboBox.isEnabled() || ComponentUtils.isReadOnly(this.comboBox)) && this.comboBox.isEditable()) {
            this.setIconOnly(false);
        } else if (this.comboBox.isEditable()) {
            this.setIconOnly(!ComponentUtils.isReadOnly(this.comboBox));
        }
        this.comboBox.revalidate();
    }
}

