/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.combobox;

import com.nokia.laf.NetComboBoxUI;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class NetComboBoxRenderer
extends BasicComboBoxRenderer {
    private JComboBox myComboBox;

    public NetComboBoxRenderer(JComboBox comboBox) {
        this.setBorder(UIManager.getBorder("ComboBox.renderer.border"));
        this.putClientProperty("OrangeTouch.automaticTooltipEnabled", true);
        this.myComboBox = comboBox;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        int horizontalAlignment = ClientPropertyUtil.intValue(this.myComboBox, "Combobox.horizontalAlignment");
        if (horizontalAlignment == -1 && value instanceof Number && this.myComboBox.getParent() instanceof JTable) {
            horizontalAlignment = 4;
        }
        NetComboBoxUI netComboBoxUI = (NetComboBoxUI)this.myComboBox.getUI();
        if (index < 0) {
            this.setSelectedItemBorder(horizontalAlignment);
        } else {
            this.setListItemBorder(list, horizontalAlignment);
        }
        if (horizontalAlignment != ClientProperties.UNKNOWN_VALUE) {
            this.setHorizontalAlignment(horizontalAlignment);
        } else if (value instanceof Number && this.myComboBox.getParent() instanceof JTable) {
            this.setHorizontalAlignment(4);
        }
        if (this.myComboBox.isFocusOwner() && index < 0) {
            this.setForeground(NetUtils.isFocused(this.myComboBox) ? NetLookAndFeel.getWhite() : NetLookAndFeel.getBlack());
        } else if (netComboBoxUI != null && netComboBoxUI.getArrowButton() != null && index < 0) {
            this.setForeground(NetUtils.isFocused(this.myComboBox) ? NetLookAndFeel.getWhite() : NetLookAndFeel.getBlack());
        }
        return this;
    }

    private void setSelectedItemBorder(int horizontalAlignment) {
        String borderKey = "ComboBox.editable.renderer.border";
        if (!this.myComboBox.isEditable()) {
            borderKey = this.isTableEditor() ? (horizontalAlignment == 4 ? "ComboBox.table.renderer.border.rightalign" : "ComboBox.table.renderer.border") : (ComponentUtils.isSmall(this.myComboBox) ? (horizontalAlignment == 4 ? "ComboBox.renderer.border.smallrightalign" : "ComboBox.renderer.smallborder") : (horizontalAlignment == 4 ? "ComboBox.renderer.border.rightalign" : "ComboBox.renderer.border"));
        }
        this.setBorder(UIManager.getBorder(borderKey));
    }

    private void setListItemBorder(JList list, int horizontalAlignment) {
        String borderKey = "ComboBox.list.border";
        if (ComponentUtils.isSmall(this.myComboBox)) {
            if (this.isTableEditor()) {
                if (horizontalAlignment == 4) {
                    borderKey = "ComboBox.list.tableborder.rightalign";
                    if (ClientPropertyUtil.booleanValue(list, "OrangeTouch.scrollVisibleInComboPopup")) {
                        borderKey = "ComboBox.list.tableborder.rightalign.scroll";
                    }
                } else {
                    borderKey = "ComboBox.list.tableborder";
                }
            } else {
                borderKey = "ComboBox.list.smallborder";
            }
        } else if (horizontalAlignment == 4) {
            borderKey = "ComboBox.list.border.rightalign";
        }
        this.setBorder(UIManager.getBorder(borderKey));
    }

    private boolean isTableEditor() {
        return this.myComboBox.getParent() instanceof JTable || NetUtils.isTableCellEditor(this.myComboBox);
    }

    public static class UIResource
    extends NetComboBoxRenderer
    implements javax.swing.plaf.UIResource {
        public UIResource(JComboBox combo) {
            super(combo);
        }
    }
}

