/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.combobox;

import com.nokia.laf.NetPopupMenuUI;
import com.nokia.laf.combobox.ComboBoxViewportBorder;
import com.nokia.laf.combobox.NetComboPopupHandler;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.PListFocusTraversalPolicy;
import com.nokia.widgets.util.SystemUtils;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboPopup;

public class NetComboPopup
extends BasicComboPopup
implements PropertyChangeListener {
    protected PTextField mySearchField;
    protected boolean myPopupNeededWhenSearchFieldFocused;
    private NetComboPopupHandler myHandler;
    protected static final int SHADOW_BORDER_WIDTH = 3;
    private int largestElementComponentWidth;

    public NetComboPopup(JComboBox comboBox) {
        super(comboBox);
    }

    public void setSearchField() {
        this.mySearchField = new PTextField();
        this.mySearchField.setSearchField(true);
        this.add((Component)this.mySearchField, 0);
        this.scroller.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        this.scroller.getVerticalScrollBar().putClientProperty("ScrollBar.comboBoxPopup", Boolean.FALSE);
        this.putClientProperty("OrangeTouch.searchField", Boolean.TRUE);
        PListFocusTraversalPolicy myFocusPolicy = new PListFocusTraversalPolicy();
        myFocusPolicy.add(this.getComboBox());
        myFocusPolicy.add(this.mySearchField);
        myFocusPolicy.add(this.getComboBox());
        this.setFocusTraversalPolicy(myFocusPolicy);
        this.setFocusTraversalPolicyProvider(true);
        this.mySearchField.addMouseListener(this.getHandler());
        this.mySearchField.addDocumentListener(this.getHandler());
        this.mySearchField.addFocusListener(this.getHandler());
        this.mySearchField.addKeyListener(this.getHandler());
        this.list.removeMouseListener(this.listMouseListener);
        this.listMouseListener = this.getHandler();
        this.list.addMouseListener(this.listMouseListener);
        this.getComboBox().addKeyListener(this.getHandler());
    }

    public boolean isSearchSupported() {
        return ClientPropertyUtil.booleanValue(this, "OrangeTouch.searchField");
    }

    @Override
    protected JScrollPane createScroller() {
        JScrollPane jScrollPane = super.createScroller();
        jScrollPane.setOpaque(false);
        jScrollPane.setViewportBorder(new ComboBoxViewportBorder(this.comboBox));
        jScrollPane.getVerticalScrollBar().putClientProperty("ScrollBar.comboBoxPopup", Boolean.TRUE);
        jScrollPane.getVerticalScrollBar().setOpaque(false);
        return jScrollPane;
    }

    protected JList createList() {
        return new JList(this.comboBox.getModel()){

            @Override
            public void processMouseEvent(MouseEvent e) {
                MouseEvent tempE = e;
                if (NetUtils.isMenuShortcutKeyDown(tempE)) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    tempE = new MouseEvent((Component)tempE.getSource(), tempE.getID(), tempE.getWhen(), tempE.getModifiers() ^ toolkit.getMenuShortcutKeyMask(), tempE.getX(), tempE.getY(), tempE.getXOnScreen(), tempE.getYOnScreen(), tempE.getClickCount(), tempE.isPopupTrigger(), 0);
                }
                super.processMouseEvent(tempE);
            }

            @Override
            public void setBackground(Color bg) {
                if (NetComboPopup.this.comboBox.isEditable() && bg instanceof UIResource && UIManager.getColor("TextField.invalidBackground").equals(bg)) {
                    return;
                }
                super.setBackground(bg);
            }

            @Override
            public void setForeground(Color fg) {
                if (NetComboPopup.this.comboBox.isEditable() && fg instanceof UIResource && UIManager.getColor("TextField.invalidForeground").equals(fg)) {
                    return;
                }
                super.setForeground(fg);
            }
        };
    }

    @Override
    public boolean isOpaque() {
        return this.isSearchSupported();
    }

    @Override
    public void show() {
        if (ComponentUtils.isReadOnly(this.comboBox) || ClientPropertyUtil.booleanValue(this.comboBox, "OrangeTouch.comboBoxButtonHidden")) {
            return;
        }
        if (!this.comboBox.isShowing()) {
            return;
        }
        this.list.putClientProperty("BlueTouch.rolloveredCell", null);
        this.comboBox.firePopupMenuWillBecomeVisible();
        Dimension popupSize = this.comboBox.getSize();
        int width = ClientPropertyUtil.integerValue(this.comboBox, "BlueTouch.ComboBox.popupWidth");
        if (width < 0 && ClientPropertyUtil.booleanValue(this.comboBox, "OrangeTouch.ComboBox.packPopupWidth") && this.scroller.getParent() != null) {
            width = this.calculatePopupWidthDynamically();
        }
        if (width > 0) {
            popupSize.width = width;
        }
        Insets insets = this.getInsets();
        int scrollerWidth = 0;
        int borderWidth = 3;
        int searchFieldHeight = 0;
        int gapforComponentHeight = 0;
        if (this.scroller.getParent() != null) {
            int scrollBarWidth;
            if (this.isSearchSupported()) {
                borderWidth = -1;
                searchFieldHeight = this.mySearchField.getPreferredSize().height;
                gapforComponentHeight = 4;
                this.synchronizeListModelFromComboModel();
            }
            if (popupSize.width - this.largestElementComponentWidth < (scrollBarWidth = UIManager.getInt("ScrollBar.width")) && this.comboBox.getMaximumRowCount() < this.list.getModel().getSize()) {
                scrollerWidth += scrollBarWidth;
            }
            popupSize.setSize(popupSize.width + scrollerWidth - (insets.left + insets.right) + borderWidth, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()) + searchFieldHeight + gapforComponentHeight);
        }
        Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height - 3, popupSize.width, popupSize.height);
        boolean popupAboveCombo = popupBounds.y < -this.comboBox.getHeight();
        Dimension computePopupSize = popupBounds.getSize();
        if (this.isSearchSupported()) {
            this.layoutComponents();
            this.setSizeForSearchField(computePopupSize);
        }
        Dimension scrollSize = new Dimension();
        Point popupLocation = popupBounds.getLocation();
        scrollSize.width = computePopupSize.width;
        scrollSize.height = computePopupSize.height - searchFieldHeight - gapforComponentHeight;
        this.setScrollerSize(scrollSize, popupLocation);
        this.list.putClientProperty("OrangeTouch.scrollVisibleInComboPopup", NetUtils.isNotNullAndVisible(this.scroller.getVerticalScrollBar()));
        this.comboBox.putClientProperty("OrangeTouch.popupAboveCombo", popupAboveCombo);
        this.putClientProperty("OrangeTouch.popupAboveCombo", popupAboveCombo);
        this.scroller.putClientProperty("OrangeTouch.popupAboveCombo", popupAboveCombo);
        this.adjustPopupYLocation(popupAboveCombo, popupLocation);
        this.list.revalidate();
        if (this.scroller.getParent() == null) {
            this.pack();
        }
        this.setListSelection(this.comboBox.getSelectedIndex());
        this.show(this.comboBox, popupLocation.x, popupLocation.y);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NetComboPopup.this.scroller.repaint();
            }
        });
        this.setPopupFocusableInWindow();
    }

    protected void adjustPopupYLocation(boolean popupAboveCombo, Point popupLocation) {
        if (popupAboveCombo) {
            popupLocation.y = this.isSearchSupported() ? (popupLocation.y -= 2) : (popupLocation.y += 2);
        }
    }

    protected void setScrollerSize(Dimension scrollSize, Point popupLocation) {
        if (!(this.comboBox.getParent() instanceof JTable)) {
            if (!this.isSearchSupported()) {
                --popupLocation.y;
                popupLocation.x -= 2;
            }
        } else {
            ++popupLocation.y;
            --popupLocation.x;
            --scrollSize.width;
        }
        if (!SystemUtils.isAfterJava15()) {
            scrollSize.height += 4;
        }
        this.scroller.setMaximumSize(scrollSize);
        this.scroller.setPreferredSize(scrollSize);
        this.scroller.setMinimumSize(scrollSize);
    }

    protected void setPopupFocusableInWindow() {
        if (this.isSearchSupported()) {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window != null) {
                window.setFocusableWindowState(true);
            }
            if (!this.comboBox.isFocusOwner()) {
                this.comboBox.requestFocusInWindow();
            }
        }
    }

    protected void synchronizeListModelFromComboModel() {
        this.mySearchField.setText("");
        this.list.setModel(this.comboBox.getModel());
    }

    private void setSizeForSearchField(Dimension computePopupSize) {
        Dimension searchFieldSize = new Dimension();
        searchFieldSize.width = computePopupSize.width;
        searchFieldSize.height = this.mySearchField.getPreferredSize().height;
        this.mySearchField.setMinimumSize(searchFieldSize);
        this.mySearchField.setPreferredSize(searchFieldSize);
        this.mySearchField.setMaximumSize(searchFieldSize);
    }

    protected void layoutComponents() {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalStrut(2));
        this.add(this.mySearchField);
        this.add(Box.createVerticalStrut(2));
        this.add(this.scroller);
        this.validate();
    }

    private void setListSelection(int selectedIndex) {
        if (selectedIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
            this.list.ensureIndexIsVisible(selectedIndex);
        }
    }

    public void setComponent(JComponent component) {
        if (this.getComponentCount() == 1 && this.getComponent(0) == this.scroller) {
            this.remove(this.scroller);
            this.add(component);
            if (this.isVisible()) {
                this.hide();
                this.show();
            }
        }
    }

    public void restoreList() {
        if (this.getComponentCount() == 1 && this.getComponent(0) != this.scroller) {
            this.remove(0);
            this.add(this.scroller);
            if (this.isVisible()) {
                this.hide();
                this.show();
            }
        }
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    @Override
    public void updateUI() {
        this.setUI(new NetComboPopupUI());
    }

    @Override
    protected void configurePopup() {
        super.configurePopup();
        this.setBorder(UIManager.getBorder("ComboBox.Popup.border"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ((evt.getPropertyName().equals("BlueTouch.ComboBox.popupWidth") || evt.getPropertyName().equals("OrangeTouch.ComboBox.packPopupWidth")) && this.isVisible()) {
            this.hide();
            this.show();
        }
    }

    protected int calculatePopupWidthDynamically() {
        double defaultWidth = this.comboBox.getSize().getWidth();
        DefaultListCellRenderer renderer = this.comboBox.getRenderer();
        if (renderer == null) {
            renderer = new DefaultListCellRenderer();
        }
        ComboBoxModel model = this.comboBox.getModel();
        int modelSize = model.getSize();
        int i = 0;
        while (i < modelSize) {
            Component c = renderer.getListCellRendererComponent(this.getList(), model.getElementAt(i), i, false, false);
            int preferredComponentSize = c.getPreferredSize().width + 2;
            this.largestElementComponentWidth = Math.max(this.largestElementComponentWidth, preferredComponentSize);
            defaultWidth = Math.max(defaultWidth, (double)preferredComponentSize);
            ++i;
        }
        return (int)Math.ceil(defaultWidth);
    }

    private NetComboPopupHandler getHandler() {
        if (this.myHandler == null) {
            this.myHandler = new NetComboPopupHandler(this);
        }
        return this.myHandler;
    }

    @Override
    public void hide() {
        if (this.myPopupNeededWhenSearchFieldFocused) {
            this.myPopupNeededWhenSearchFieldFocused = false;
            return;
        }
        super.hide();
    }

    protected void searchFieldDocumentChanged(DocumentEvent e) {
        String text = this.mySearchField.getText();
        if (text == null) {
            return;
        }
        ComboBoxModel comboboxModel = this.getComboBox().getModel();
        ArrayList matchedElements = new ArrayList();
        int index = 0;
        while (index < comboboxModel.getSize()) {
            Object element = comboboxModel.getElementAt(index);
            if (element.toString().toLowerCase().contains(text.toLowerCase())) {
                matchedElements.add(element);
            }
            ++index;
        }
        this.list.removeAll();
        DefaultListModel listModel = new DefaultListModel();
        if (text.length() == 0) {
            int index2 = 0;
            while (index2 < comboboxModel.getSize()) {
                listModel.addElement(comboboxModel.getElementAt(index2));
                ++index2;
            }
        } else if (matchedElements.size() == 0) {
            listModel.addElement(WidgetResources.getString("PCombobox.Popup.Search.NoMatches"));
        } else if (matchedElements.size() > 0) {
            for (Object element : matchedElements) {
                listModel.addElement(element);
            }
        }
        this.list.setModel(listModel);
        this.list.setSelectedIndex(0);
    }

    private static class NetComboPopupUI
    extends NetPopupMenuUI {
        private NetComboPopupUI() {
        }

        @Override
        public void installDefaults() {
            super.installDefaults();
            this.popupMenu.putClientProperty("useOpaquePopup", Boolean.TRUE);
            LookAndFeel.installBorder(this.popupMenu, "ComboBox.Popup.border");
        }
    }
}

