/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.combobox;

import com.nokia.laf.combobox.NetComboPopup;
import com.nokia.widgets.text.PTextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComboBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NetComboPopupHandler
implements MouseListener,
DocumentListener,
FocusListener,
KeyListener {
    private NetComboPopup myComboPopup;

    public NetComboPopupHandler(NetComboPopup comboPopup) {
        this.myComboPopup = comboPopup;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.myComboPopup.mySearchField) {
            this.myComboPopup.myPopupNeededWhenSearchFieldFocused = true;
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.myComboPopup.getList()) {
            this.setSelectionForCombobox();
            return;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.myComboPopup.searchFieldDocumentChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.myComboPopup.searchFieldDocumentChanged(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.myComboPopup.searchFieldDocumentChanged(e);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.myComboPopup.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.myComboPopup.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.myComboPopup.isSearchSupported() && this.myComboPopup.isVisible()) {
            if (e.getSource() instanceof JComboBox) {
                this.handleKeyEventForCombo(e);
            } else if (e.getSource() instanceof PTextField) {
                this.handleKeyEventForSerchField(e);
            }
        }
    }

    private void handleKeyEventForCombo(KeyEvent e) {
        if (e.getKeyCode() == 38 && this.myComboPopup.getList().getSelectedIndex() == 0) {
            this.myComboPopup.myPopupNeededWhenSearchFieldFocused = true;
            this.myComboPopup.mySearchField.requestFocus();
        } else if (e.getKeyCode() == 40 && this.myComboPopup.getList().getSelectedIndex() != -1 && this.myComboPopup.getList().getSelectedIndex() == this.myComboPopup.getList().getModel().getSize() - 1) {
            e.consume();
        } else if (e.getKeyCode() == 10) {
            this.setSelectionForCombobox();
        }
    }

    private void handleKeyEventForSerchField(KeyEvent e) {
        if (e.getKeyCode() == 40) {
            this.myComboPopup.getComboBox().requestFocus();
            if (this.myComboPopup.getList().getSelectedIndex() == -1) {
                this.myComboPopup.getList().setSelectedIndex(0);
            }
        } else if (e.getKeyCode() == 10) {
            this.setSelectionForCombobox();
            e.consume();
        }
    }

    private void setSelectionForCombobox() {
        if (this.myComboPopup.getList().getModel().getSize() > 0) {
            this.myComboPopup.getComboBox().getEditor().setItem(this.myComboPopup.getList().getSelectedValue());
            this.myComboPopup.getComboBox().setSelectedItem(this.myComboPopup.getList().getSelectedValue());
        }
        this.myComboPopup.myPopupNeededWhenSearchFieldFocused = false;
        this.myComboPopup.synchronizeListModelFromComboModel();
        this.myComboPopup.getComboBox().requestFocusInWindow();
        this.myComboPopup.getComboBox().setPopupVisible(false);
        this.myComboPopup.setVisible(false);
        if (this.myComboPopup.getComboBox().isEditable() && this.myComboPopup.getComboBox().getEditor() != null) {
            this.myComboPopup.getComboBox().configureEditor(this.myComboPopup.getComboBox().getEditor(), this.myComboPopup.getComboBox().getSelectedItem());
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

