/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.painters;

import com.nokia.laf.painters.GradientPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class ButtonGradientPainter
extends GradientPainter {
    public static final ButtonGradientPainter INSTANCE = new ButtonGradientPainter(16);

    public ButtonGradientPainter(int cacheSize) {
        super(cacheSize);
    }

    @Override
    protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
        Graphics2D g2 = (Graphics2D)g;
        Color[] gradient = (Color[])args[0];
        boolean isVertical = (Boolean)args[1];
        if (isVertical) {
            this.drawVerticalDoubleGradient(g2, gradient, w, h);
        } else {
            this.drawHorizontalDoubleGradient(g2, gradient, w, h);
        }
    }

    private void drawVerticalDoubleGradient(Graphics2D g2, Color[] colors, int w, int h) {
        int midy = h / 2;
        if (h % 2 != 0) {
            ++midy;
        }
        Color topColor = null;
        Color midTopColor = null;
        Color bottomColor = null;
        Color midBottomColor = null;
        if (colors.length == 4) {
            topColor = colors[0];
            midTopColor = colors[1];
            midBottomColor = colors[2];
            bottomColor = colors[3];
        } else {
            topColor = ButtonGradientPainter.incrementColor(colors[0], midy - 1);
            midTopColor = colors[0];
            midBottomColor = colors[1];
            bottomColor = ButtonGradientPainter.incrementColor(colors[1], -midy + 1);
        }
        g2.setPaint(new GradientPaint(0.0f, 0.0f, topColor, 0.0f, midy - 1, midTopColor));
        g2.fillRect(0, 0, w, midy);
        g2.setPaint(new GradientPaint(0.0f, midy, midBottomColor, 0.0f, h - 1, bottomColor));
        g2.fillRect(0, midy, w, h - midy);
    }

    private static Color incrementColor(Color color, int increment) {
        return new Color(ButtonGradientPainter.incrementColorComponent(color.getRed(), increment), ButtonGradientPainter.incrementColorComponent(color.getGreen(), increment), ButtonGradientPainter.incrementColorComponent(color.getBlue(), increment));
    }

    private static int incrementColorComponent(int color, int increment) {
        int newValue = color + increment;
        if (newValue < 0) {
            return 0;
        }
        if (newValue > 255) {
            return 255;
        }
        return newValue;
    }

    private void drawHorizontalDoubleGradient(Graphics2D g2, Color[] colors, int w, int h) {
        float midx = (float)w / 2.0f;
        g2.setPaint(new GradientPaint(0.0f, 0.0f, colors[0], midx, 0.0f, colors[1]));
        g2.fillRect(0, 0, (int)midx, h);
        g2.setPaint(new GradientPaint(midx + 1.0f, 0.0f, colors[2], w - 1, 0.0f, colors[3]));
        g2.fillRect((int)midx, 0, (int)((float)w - midx), h);
    }
}

