/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.painters;

import com.nokia.laf.painters.ImageCache;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.HashMap;
import java.util.Map;

public abstract class CachedImagePainter {
    private static final Map theCacheMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageCache getCache(Object key) {
        Map map = theCacheMap;
        synchronized (map) {
            ImageCache imageCache = (ImageCache)theCacheMap.get(key);
            if (imageCache == null) {
                imageCache = new ImageCache(1);
                theCacheMap.put(key, imageCache);
            }
            return imageCache;
        }
    }

    public CachedImagePainter(int cacheCount) {
        CachedImagePainter.getCache(this.getClass()).setMaxCount(cacheCount);
    }

    public void paint(Component c, Graphics g, int x, int y, int cachedWidth, int cachedHeight, Object[] attributes) {
        if (cachedWidth <= 0 || cachedHeight <= 0) {
            return;
        }
        Class<?> key = this.getClass();
        GraphicsConfiguration config = c.getGraphicsConfiguration();
        ImageCache imageCache = CachedImagePainter.getCache(key);
        Image image = imageCache.getImage(config, cachedWidth, cachedHeight, attributes);
        int attempts = 0;
        do {
            boolean draw = false;
            if (image instanceof VolatileImage) {
                switch (((VolatileImage)image).validate(config)) {
                    case 2: {
                        ((VolatileImage)image).flush();
                        image = null;
                        break;
                    }
                    case 1: {
                        draw = true;
                        break;
                    }
                }
            }
            if (image == null) {
                image = this.createImage(c, cachedWidth, cachedHeight, config);
                imageCache.setImage(config, cachedWidth, cachedHeight, attributes, image);
                draw = true;
            }
            if (draw) {
                Graphics g2 = image.getGraphics();
                this.paintToImage(c, g2, cachedWidth, cachedHeight, attributes);
                g2.dispose();
            }
            this.paintImage(c, g, x, y, cachedWidth, cachedHeight, image, attributes);
        } while (image instanceof VolatileImage && ((VolatileImage)image).contentsLost() && ++attempts < 3);
    }

    protected abstract void paintToImage(Component var1, Graphics var2, int var3, int var4, Object[] var5);

    protected void paintImage(Component c, Graphics g, int x, int y, int w, int h, Image image, Object[] args) {
        g.drawImage(image, x, y, null);
    }

    protected Image createImage(Component c, int w, int h, GraphicsConfiguration config) {
        if (config == null) {
            return new BufferedImage(w, h, 1);
        }
        return config.createCompatibleVolatileImage(w, h);
    }
}

