/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.painters;

import com.nokia.widgets.util.ImageUtils;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.WritableRaster;

public class CircleProjection
implements BufferedImageOp {
    private BufferedImage myDestination;
    private double myRadius;
    private double myQuarterOfPerimeter;
    private double myCenterArea = 0.0;

    public CircleProjection(double radius) {
        this.myRadius = radius;
        this.myQuarterOfPerimeter = 1.5707963267948966 * this.myRadius;
    }

    public CircleProjection(double radius, double centerArea) {
        this(radius);
        this.myCenterArea = centerArea;
    }

    public double getRadius() {
        return this.myRadius;
    }

    public double getCenterArea() {
        return this.myCenterArea;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        int height = src.getHeight();
        int[] pixels = new int[height];
        if (this.myDestination == null) {
            this.myDestination = this.createCompatibleDestImage(src, null);
        }
        int x = 0;
        while ((double)x < this.myQuarterOfPerimeter) {
            double transferred = this.getTransformedX(x);
            ImageUtils.getPixels(src, x, 0, 1, height, pixels);
            ImageUtils.setPixels(this.myDestination, (int)transferred, 0, 1, height, pixels);
            ++x;
        }
        WritableRaster r = src.getRaster();
        Raster child = r.createChild((int)this.myQuarterOfPerimeter + 1, 0, (int)this.myCenterArea, r.getHeight() - 1, (int)this.myRadius, 0, null);
        this.myDestination.setData(child);
        int x2 = (int)(this.myQuarterOfPerimeter + this.myCenterArea);
        while (x2 < src.getWidth()) {
            double transferred = this.getTransformedX(x2);
            ImageUtils.getPixels(src, x2, 0, 1, height, pixels);
            ImageUtils.setPixels(this.myDestination, (int)transferred, 0, 1, height, pixels);
            ++x2;
        }
        return this.myDestination;
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle2D.Double(0.0, 0.0, this.getTransformedX(src.getWidth()), src.getHeight());
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        BufferedImage image;
        Rectangle r = this.getBounds2D(src).getBounds();
        int w = r.x + r.width;
        int h = r.y + r.height;
        if (w <= 0) {
            throw new RasterFormatException("Transformed width (" + w + ") is less than or equal to 0.");
        }
        if (h <= 0) {
            throw new RasterFormatException("Transformed height (" + h + ") is less than or equal to 0.");
        }
        if (destCM == null) {
            ColorModel cm = src.getColorModel();
            image = new BufferedImage(cm, src.getRaster().createCompatibleWritableRaster(w, h), cm.isAlphaPremultiplied(), null);
        } else {
            image = new BufferedImage(destCM, destCM.createCompatibleWritableRaster(w, h), destCM.isAlphaPremultiplied(), null);
        }
        return image;
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        double x = srcPt.getX();
        dstPt.setLocation(this.getTransformedX(x), srcPt.getY());
        return dstPt;
    }

    private double getTransformedX(double x) {
        if (x < this.myQuarterOfPerimeter) {
            double xc = x - this.myQuarterOfPerimeter;
            double trx = this.projectFromCircle(xc);
            return trx + this.myRadius;
        }
        if (x < this.myQuarterOfPerimeter + this.myCenterArea) {
            return x - (this.myQuarterOfPerimeter - this.myRadius);
        }
        double xc = x - this.myQuarterOfPerimeter - this.myCenterArea;
        double trx = this.projectFromCircle(xc);
        return trx + this.myRadius + this.myCenterArea;
    }

    private double projectFromCircle(double x) {
        double diameter = 2.0 * this.myRadius;
        return diameter * Math.cos(x / diameter) * Math.sin(x / diameter);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }
}

