/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.painters;

import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public final class ConicalGradientPaint
implements Paint {
    private final Point2D myCenter;
    private final double[] myFractionAngles;
    private final double[] myRedStepLookup;
    private final double[] myGreenStepLookup;
    private final double[] myBlueStepLookup;
    private final double[] myAlphaStepLookup;
    private final Color[] myColors;
    private static final float INT_TO_FLOAT_CONST = 0.003921569f;

    public ConicalGradientPaint(Point2D center, float[] fractions, Color[] colors) throws IllegalArgumentException {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("Fractions and colors must be equal in size");
        }
        ArrayList<Float> fractionList = new ArrayList<Float>();
        float offset = 0.0f;
        float[] fArray = fractions;
        int n = fractions.length;
        int n2 = 0;
        while (n2 < n) {
            float fraction = fArray[n2];
            fractionList.add(Float.valueOf(fraction));
            ++n2;
        }
        ArrayList<Color> colorList = new ArrayList<Color>(colors.length);
        colorList.addAll(Arrays.asList(colors));
        if (!SystemUtils.isEqual(((Float)fractionList.get(0)).floatValue(), 0.0, 1.0E-7)) {
            fractionList.add(0, Float.valueOf(0.0f));
            Color tmpColor = (Color)colorList.get(0);
            colorList.add(0, tmpColor);
        }
        if (!SystemUtils.isEqual(((Float)fractionList.get(fractionList.size() - 1)).floatValue(), 1.0, 1.0E-7)) {
            fractionList.add(Float.valueOf(1.0f));
            colorList.add(colors[0]);
        }
        Map<Float, Color> fractionColors = this.calculateColors(fractionList, colorList, 0.0f);
        fractionList.clear();
        colorList.clear();
        TreeSet<Float> sortedFractions = new TreeSet<Float>(fractionColors.keySet());
        Iterator iterator = sortedFractions.iterator();
        while (iterator.hasNext()) {
            float fraction = ((Float)iterator.next()).floatValue();
            fractionList.add(Float.valueOf(fraction));
            colorList.add(fractionColors.get(Float.valueOf(fraction)));
        }
        this.myCenter = center;
        this.myColors = colorList.toArray(new Color[0]);
        int maxFractions = fractionList.size();
        this.myFractionAngles = new double[maxFractions];
        int i = 0;
        while (i < maxFractions) {
            this.myFractionAngles[i] = ((Float)fractionList.get(i)).floatValue() * 360.0f;
            ++i;
        }
        this.myRedStepLookup = new double[this.myColors.length];
        this.myGreenStepLookup = new double[this.myColors.length];
        this.myBlueStepLookup = new double[this.myColors.length];
        this.myAlphaStepLookup = new double[this.myColors.length];
        i = 0;
        while (i < this.myColors.length - 1) {
            Color color = this.myColors[i];
            Color nextColor = this.myColors[i + 1];
            double angleDiff = this.myFractionAngles[i + 1] - this.myFractionAngles[i];
            this.myRedStepLookup[i] = (double)ConicalGradientPaint.intToFloat(nextColor.getRed() - color.getRed()) / angleDiff;
            this.myGreenStepLookup[i] = (double)ConicalGradientPaint.intToFloat(nextColor.getGreen() - color.getGreen()) / angleDiff;
            this.myBlueStepLookup[i] = (double)ConicalGradientPaint.intToFloat(nextColor.getBlue() - color.getBlue()) / angleDiff;
            this.myAlphaStepLookup[i] = (double)ConicalGradientPaint.intToFloat(nextColor.getAlpha() - color.getAlpha()) / angleDiff;
            ++i;
        }
    }

    private Map<Float, Color> calculateColors(List<Float> fractionList, List<Color> colorList, float offset) {
        int maxFractions = fractionList.size();
        HashMap<Float, Color> fractionColors = new HashMap<Float, Color>(maxFractions);
        int i = 0;
        while (i < maxFractions) {
            Color newFractionColor;
            float tmpFraction = fractionList.get(i).floatValue() + offset;
            Color tmpColor = colorList.get(i);
            if (tmpFraction <= 0.0f) {
                Color nextColors;
                float nextFraction;
                fractionColors.put(Float.valueOf(1.0f + tmpFraction + 1.0E-4f), tmpColor);
                if (i < maxFractions - 1) {
                    nextFraction = fractionList.get(i + 1).floatValue() + offset;
                    nextColors = colorList.get(i + 1);
                } else {
                    nextFraction = 1.0f - fractionList.get(0).floatValue() + offset;
                    nextColors = colorList.get(0);
                }
                if (nextFraction > 0.0f) {
                    newFractionColor = this.getColorFromFraction(tmpColor, nextColors, (int)((nextFraction - tmpFraction) * 10000.0f), (int)(-tmpFraction * 10000.0f));
                    fractionColors.put(Float.valueOf(0.0f), newFractionColor);
                    fractionColors.put(Float.valueOf(1.0f), newFractionColor);
                }
            } else if (tmpFraction >= 1.0f) {
                Color previousColor;
                float previousFraction;
                fractionColors.put(Float.valueOf(tmpFraction - 1.0f - 1.0E-4f), tmpColor);
                if (i > 0) {
                    previousFraction = fractionList.get(i - 1).floatValue() + offset;
                    previousColor = colorList.get(i - 1);
                } else {
                    previousFraction = fractionList.get(maxFractions - 1).floatValue() + offset;
                    previousColor = colorList.get(maxFractions - 1);
                }
                if (previousFraction < 1.0f) {
                    newFractionColor = this.getColorFromFraction(tmpColor, previousColor, (int)((tmpFraction - previousFraction) * 10000.0f), (int)(tmpFraction - 1.0f) * 10000);
                    fractionColors.put(Float.valueOf(1.0f), newFractionColor);
                    fractionColors.put(Float.valueOf(0.0f), newFractionColor);
                }
            } else {
                fractionColors.put(Float.valueOf(tmpFraction), tmpColor);
            }
            ++i;
        }
        fractionList.clear();
        colorList.clear();
        return fractionColors;
    }

    public Color getColorFromFraction(Color startColor, Color destinationColor, int range, int value) {
        float sourceRed = ConicalGradientPaint.intToFloat(startColor.getRed());
        float sourceGreen = ConicalGradientPaint.intToFloat(startColor.getGreen());
        float sourceBlue = ConicalGradientPaint.intToFloat(startColor.getBlue());
        float sourceAlpha = ConicalGradientPaint.intToFloat(startColor.getAlpha());
        float destRed = ConicalGradientPaint.intToFloat(destinationColor.getRed());
        float destGreen = ConicalGradientPaint.intToFloat(destinationColor.getGreen());
        float destBlue = ConicalGradientPaint.intToFloat(destinationColor.getBlue());
        float destAlpha = ConicalGradientPaint.intToFloat(destinationColor.getAlpha());
        float redDelta = destRed - sourceRed;
        float greenDelta = destGreen - sourceGreen;
        float blueDelta = destBlue - sourceBlue;
        float alphaDelta = destAlpha - sourceAlpha;
        float redFraction = redDelta / (float)range;
        float greenFraction = greenDelta / (float)range;
        float blueFraction = blueDelta / (float)range;
        float alphaFraction = alphaDelta / (float)range;
        return new Color(sourceRed + redFraction * (float)value, sourceGreen + greenFraction * (float)value, sourceBlue + blueFraction * (float)value, sourceAlpha + alphaFraction * (float)value);
    }

    private static float intToFloat(int color) {
        return (float)color * 0.003921569f;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform transform, RenderingHints hints) {
        return new ConicalGradientPaintContext(transform.transform(this.myCenter, null));
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    private final class ConicalGradientPaintContext
    implements PaintContext {
        private Point2D myCenterPoint;

        public ConicalGradientPaintContext(Point2D center) {
            this.myCenterPoint = new Point2D.Double(center.getX(), center.getY());
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        @Override
        public Raster getRaster(int x, int y, int tileWidth, int tileHeight) {
            double rotationCenterX = (double)(-x) + this.myCenterPoint.getX();
            double rotationCenterY = (double)(-y) + this.myCenterPoint.getY();
            int max = ConicalGradientPaint.this.myFractionAngles.length;
            WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(tileWidth, tileHeight);
            int[] data = new int[tileWidth * tileHeight * 4];
            double currentRed = 0.0;
            double currentGreen = 0.0;
            double currentBlue = 0.0;
            double currentAlpha = 0.0;
            int py = 0;
            while (py < tileHeight) {
                int px = 0;
                while (px < tileWidth) {
                    double dx = (double)px - rotationCenterX;
                    double dy = (double)py - rotationCenterY;
                    double angle = this.getAngle(dx, dy);
                    int i = 0;
                    while (i < max - 1) {
                        double fractionAngle = ConicalGradientPaint.this.myFractionAngles[i];
                        if (angle >= fractionAngle) {
                            Color color = ConicalGradientPaint.this.myColors[i];
                            double angleDiff = angle - fractionAngle;
                            currentRed = (double)ConicalGradientPaint.intToFloat(color.getRed()) + angleDiff * ConicalGradientPaint.this.myRedStepLookup[i];
                            currentGreen = (double)ConicalGradientPaint.intToFloat(color.getGreen()) + angleDiff * ConicalGradientPaint.this.myGreenStepLookup[i];
                            currentBlue = (double)ConicalGradientPaint.intToFloat(color.getBlue()) + angleDiff * ConicalGradientPaint.this.myBlueStepLookup[i];
                            currentAlpha = (double)ConicalGradientPaint.intToFloat(color.getAlpha()) + angleDiff * ConicalGradientPaint.this.myAlphaStepLookup[i];
                        }
                        ++i;
                    }
                    int base = (py * tileWidth + px) * 4;
                    data[base + 0] = (int)(currentRed * 255.0);
                    data[base + 1] = (int)(currentGreen * 255.0);
                    data[base + 2] = (int)(currentBlue * 255.0);
                    data[base + 3] = (int)(currentAlpha * 255.0);
                    ++px;
                }
                ++py;
            }
            raster.setPixels(0, 0, tileWidth, tileHeight, data);
            return raster;
        }

        private double getAngle(double x, double y) {
            double distance = Math.sqrt(x * x + y * y);
            if (SystemUtils.isEqual(distance, 0.0, 1.0E-7)) {
                distance = 1.0;
            }
            double angle = Math.abs(Math.toDegrees(Math.acos(x / distance)));
            if (x >= 0.0 && y <= 0.0) {
                angle = 90.0 - angle;
            } else if (x >= 0.0 && y >= 0.0) {
                angle += 90.0;
            } else if (x <= 0.0 && y >= 0.0) {
                angle += 90.0;
            } else if (x <= 0.0 && y <= 0.0) {
                angle = 450.0 - angle;
            }
            return angle;
        }
    }
}

