/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.painters;

import java.awt.image.RGBImageFilter;

public class GradientAlphaFilter
extends RGBImageFilter {
    private int mySize;
    boolean myLeftToRight;
    private int myImageWidth = -1;

    public GradientAlphaFilter(int fadeoutAreaWidth, int imageWidth) {
        this.canFilterIndexColorModel = true;
        this.myLeftToRight = true;
        this.mySize = fadeoutAreaWidth;
        this.myImageWidth = imageWidth;
    }

    public GradientAlphaFilter(int size, boolean isLeftToRight) {
        this.canFilterIndexColorModel = true;
        this.mySize = size;
        this.myLeftToRight = isLeftToRight;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        double scaleFactor = 1.0;
        if (this.myImageWidth >= 0) {
            if (x < this.mySize) {
                scaleFactor = (double)x / (double)this.mySize;
            } else if (x > this.myImageWidth - this.mySize) {
                scaleFactor = (double)(this.myImageWidth - x) / (double)this.mySize;
            }
        } else {
            scaleFactor = this.myLeftToRight ? (double)x / (double)this.mySize : (double)Math.max(0, this.mySize - x) / (double)this.mySize;
        }
        int alpha = rgb >> 24 & 0xFF;
        alpha = (int)((double)alpha * scaleFactor);
        return rgb & 0xFFFFFF | alpha << 24;
    }
}

