/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.painters;

import com.nokia.laf.borders.HeaderBorder;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class GradientBackgroundPainter {
    private static final Color[] LIGHT_PANEL_BACKGOUND = (Color[])UIManager.get("HeaderBorder.panelBackground");
    private static final String ROOT_PANE_KEY = "OrangeTouch.rootPane";
    private static final Color HEADER_TOP_COLOR = UIManager.getColor("Panel.headerTopColor");
    private static final Color[] PRODUCT_BANNER_BACKGOUND = (Color[])UIManager.get("Dialog.productBannerBackground");
    private static final Color[] TABBEDPANE_DIALOG_BACKGROUND = (Color[])UIManager.get("TabbedPane.dialogBackground");
    private static Color[] DIALOG_BACKGROUND_GRADIENT = (Color[])UIManager.get("OptionPane.backgroundGradient");
    private static HierarchyListener theHierarchyListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            Component comp;
            long changeFlags = e.getChangeFlags();
            if ((changeFlags & 2L) != 0L && !(comp = e.getComponent()).isDisplayable() && comp instanceof JComponent) {
                JComponent jComp = (JComponent)comp;
                jComp.putClientProperty(GradientBackgroundPainter.ROOT_PANE_KEY, null);
                comp.removeHierarchyListener(this);
            }
        }
    };
    private static HierarchyListener theRootListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            Component comp;
            long changeFlags = e.getChangeFlags();
            if ((changeFlags & 2L) != 0L && !(comp = e.getComponent()).isDisplayable() && comp instanceof JComponent) {
                JComponent jComp = (JComponent)comp;
                jComp.putClientProperty(GradientBackgroundPainter.ROOT_PANE_KEY, null);
                jComp.putClientProperty("OrangeTouch.isInLightContainer", null);
                comp.removeHierarchyListener(this);
                GradientBackgroundPainter.removeFromImageCache(comp);
            }
        }
    };
    private static Map<ImageCacheKey, SoftReference<Image>> theBackgroundImages = new HashMap<ImageCacheKey, SoftReference<Image>>();
    private static Image theHeaderGradient = GradientBackgroundPainter.createHeaderImage(190);
    private static Image theTabbedPaneHeaderGradient = GradientBackgroundPainter.createTabbedPaneHeaderImage(216);
    private static Image theTabbedPaneDialogHeaderGradient = GradientBackgroundPainter.createTabbedPaneDialogHeaderImage(24);
    private static Image theWhiteNoiseImage = ImageUtils.createWhiteNoiseImage(300, 200);

    private static void removeFromImageCache(Component comp) {
        for (ImageCacheKey key : theBackgroundImages.keySet()) {
            if (key.getRoot() != comp) continue;
            theBackgroundImages.remove(key);
            return;
        }
    }

    public static void paintBackground(Component comp, Graphics2D g, Shape shape, int depth) {
        Component backgroundProvider = GradientBackgroundPainter.getBackgroundProvider(comp, depth);
        if (backgroundProvider == null) {
            g.setColor(comp.getBackground());
            g.fillRect(0, 0, comp.getWidth() - 1, comp.getHeight() - 1);
            return;
        }
        JRootPane rootPane = GradientBackgroundPainter.getAndCacheRootPane(comp);
        boolean inStandaloneTabbedPane = GradientBackgroundPainter.isInStandaloneTabbedPane(backgroundProvider);
        boolean isInDialog = GradientBackgroundPainter.isInDialog(rootPane) || backgroundProvider instanceof JPopupMenu;
        Color[] gradient = GradientBackgroundPainter.getBackgroundGradient(comp, backgroundProvider, isInDialog, inStandaloneTabbedPane);
        if (isInDialog && backgroundProvider instanceof JRootPane) {
            backgroundProvider = ((JRootPane)backgroundProvider).getContentPane();
        }
        Rectangle bounds = shape.getBounds();
        if (gradient != null) {
            GradientBackgroundPainter.paintBackgroundGradient(g, comp, gradient, backgroundProvider, shape, bounds);
            if (isInDialog && inStandaloneTabbedPane) {
                GradientBackgroundPainter.paintDialogTabbedPaneHeaderGradient(g, comp, backgroundProvider, shape, bounds);
            }
        } else if (!(backgroundProvider instanceof JPopupMenu)) {
            GradientBackgroundPainter.paintHeaderGradientAndSolidBackground(g, comp, backgroundProvider, shape, bounds);
        }
        if (GradientBackgroundPainter.isWhiteNoisePainted(comp, rootPane, isInDialog, inStandaloneTabbedPane)) {
            GradientBackgroundPainter.paintWhiteNoise(g, bounds);
        }
    }

    private static boolean isInDialog(JRootPane rootPane) {
        return rootPane != null && (rootPane.getParent() instanceof Dialog || rootPane.getParent() instanceof JWindow);
    }

    private static JRootPane getAndCacheRootPane(Component comp) {
        if (comp instanceof JComponent) {
            JComponent jComp = (JComponent)comp;
            Object property = jComp.getClientProperty(ROOT_PANE_KEY);
            if (property != null) {
                return (JRootPane)property;
            }
            JRootPane rootPane = GradientBackgroundPainter.getRootPane(comp);
            if (rootPane != null) {
                jComp.addHierarchyListener(theHierarchyListener);
                jComp.putClientProperty(ROOT_PANE_KEY, rootPane);
            }
            return rootPane;
        }
        return SwingUtilities.getRootPane(comp);
    }

    /*
     * Unable to fully structure code
     */
    private static JRootPane getRootPane(Component c) {
        tempC = c;
        if (!(tempC instanceof RootPaneContainer)) ** GOTO lbl9
        return ((RootPaneContainer)tempC).getRootPane();
lbl-1000:
        // 1 sources

        {
            if (tempC instanceof JComponent && (property = ((JComponent)tempC).getClientProperty("OrangeTouch.rootPane")) != null) {
                return (JRootPane)property;
            }
            if (tempC instanceof JRootPane) {
                return (JRootPane)tempC;
            }
            tempC = tempC.getParent();
lbl9:
            // 2 sources

            ** while (tempC != null)
        }
lbl10:
        // 1 sources

        return null;
    }

    private static Color[] getBackgroundGradient(Component comp, Component root, boolean inDialog, boolean inStandaloneTab) {
        if (GradientBackgroundPainter.isDarkRootPane(root)) {
            return PRODUCT_BANNER_BACKGOUND;
        }
        if (GradientBackgroundPainter.isLightPanel(root)) {
            if (comp instanceof JComponent) {
                ((JComponent)comp).putClientProperty("OrangeTouch.isInLightContainer", true);
            }
            return LIGHT_PANEL_BACKGOUND;
        }
        if (inDialog) {
            return inStandaloneTab ? TABBEDPANE_DIALOG_BACKGROUND : DIALOG_BACKGROUND_GRADIENT;
        }
        return null;
    }

    private static boolean isWhiteNoisePainted(Component c, Component root, boolean isInDialog, boolean inStandaloneTab) {
        boolean isInScrollWithBorder;
        boolean isTableViewport = c instanceof JViewport && ((JViewport)c).getView() instanceof JTable;
        boolean bl = isInScrollWithBorder = root instanceof JScrollPane && ((JScrollPane)root).getInsets().bottom > 8;
        return isInDialog && !isInScrollWithBorder && !(root instanceof JPopupMenu) && !inStandaloneTab && !isTableViewport && !(c instanceof JTable);
    }

    private static boolean isStandaloneTab(Component comp) {
        return comp instanceof JTabbedPane && ClientPropertyUtil.booleanValue((JComponent)comp, "OrangeTouch.isStandalone", true);
    }

    private static boolean isInStandaloneTabbedPane(Component comp) {
        return GradientBackgroundPainter.isStandaloneTab(comp) || GradientBackgroundPainter.isStandaloneTab(comp.getParent());
    }

    private static boolean isDarkRootPane(Component root) {
        return root instanceof JRootPane && (((JRootPane)root).getJMenuBar() != null || ClientPropertyUtil.booleanValue((JComponent)root, "OrangeTouch.useRibbonBackground"));
    }

    private static void paintDialogTabbedPaneHeaderGradient(Graphics2D g, Component comp, Component backgroundProvider, Shape shape, Rectangle bounds) {
        Object oldAa = NetUtils.antiAliasingOn(g);
        Point positionInRoot = SwingUtilities.convertPoint(comp, bounds.x, bounds.y, backgroundProvider);
        Shape oldClip = g.getClip();
        int headerHeight = theTabbedPaneDialogHeaderGradient.getHeight(null);
        if (positionInRoot.y < headerHeight) {
            Rectangle headerRect = new Rectangle(0, 0, backgroundProvider.getWidth(), headerHeight);
            Rectangle clipped = SwingUtilities.convertRectangle(backgroundProvider, headerRect, comp);
            g.clipRect(clipped.x, clipped.y, (int)clipped.getWidth(), (int)clipped.getHeight());
            ImageUtils.drawImageToShape(g, theTabbedPaneDialogHeaderGradient, shape, positionInRoot);
            g.setClip(oldClip);
        }
        g.setClip(oldClip);
        NetUtils.setAntialiasing(g, oldAa);
    }

    private static void paintHeaderGradientAndSolidBackground(Graphics2D g, Component comp, Component backgroundProvider, Shape shape, Rectangle bounds) {
        Color oldColor = g.getColor();
        g.setColor(UIManager.getColor("Frame.background"));
        Object oldAa = NetUtils.antiAliasingOn(g);
        g.fill(shape);
        Point positionInRoot = SwingUtilities.convertPoint(comp, bounds.x, bounds.y, backgroundProvider);
        Shape oldClip = g.getClip();
        boolean paintHeader = GradientBackgroundPainter.isHeaderGradientPainted(backgroundProvider);
        Image header = backgroundProvider instanceof JTabbedPane ? theTabbedPaneHeaderGradient : theHeaderGradient;
        int headerHeight = header.getHeight(null);
        if (positionInRoot.y < headerHeight && paintHeader) {
            Rectangle headerRect = new Rectangle(0, 0, backgroundProvider.getWidth(), headerHeight);
            Rectangle cliped = SwingUtilities.convertRectangle(backgroundProvider, headerRect, comp);
            g.clipRect(cliped.x, cliped.y, (int)cliped.getWidth(), (int)cliped.getHeight());
            ImageUtils.drawImageToShape(g, header, shape, positionInRoot);
            g.setClip(oldClip);
        }
        g.setClip(oldClip);
        NetUtils.setAntialiasing(g, oldAa);
        g.setColor(oldColor);
    }

    private static boolean isHeaderGradientPainted(Component backgroundProvider) {
        if (backgroundProvider instanceof JScrollPane && Boolean.FALSE.equals(((JComponent)backgroundProvider).getClientProperty("OrangeTouch.headerGradientPainted"))) {
            return false;
        }
        return backgroundProvider != null && (!(backgroundProvider instanceof JScrollPane) || ((JScrollPane)backgroundProvider).getViewport().getView() instanceof JPanel);
    }

    private static void paintBackgroundGradient(Graphics2D g, Component c, Color[] gradient, Component root, Shape shape, Rectangle bounds) {
        SoftReference<Image> refToImage = theBackgroundImages.get(new ImageCacheKey(root, gradient));
        Image image = null;
        if (refToImage != null) {
            image = refToImage.get();
        }
        if (image == null || root.getHeight() != image.getHeight(null)) {
            if (image != null) {
                image.flush();
            }
            image = GradientBackgroundPainter.createImage(root, gradient);
        }
        Point converted = SwingUtilities.convertPoint(c, bounds.x, bounds.y, root);
        ImageUtils.drawImageToShape(g, image, shape, converted);
    }

    private static void paintWhiteNoise(Graphics2D g, Rectangle bounds) {
        int width = (int)bounds.getWidth();
        int height = (int)bounds.getHeight();
        if (width > theWhiteNoiseImage.getWidth(null) || height > theWhiteNoiseImage.getHeight(null)) {
            theWhiteNoiseImage.flush();
            theWhiteNoiseImage = ImageUtils.createWhiteNoiseImage(width + 100, height + 100);
        }
        g.drawImage(theWhiteNoiseImage, 0, 0, null);
    }

    private static boolean isBackgroundRootPanel(Component component) {
        if (!(component instanceof JPanel)) {
            return false;
        }
        JPanel panel = (JPanel)component;
        return ClientPropertyUtil.booleanValue(panel, "OrangeTouch.floatingPane") || panel.getBorder() instanceof HeaderBorder;
    }

    private static boolean isLightPanel(Component component) {
        if (!(component instanceof JPanel)) {
            return false;
        }
        JPanel panel = (JPanel)component;
        return panel.getBorder() instanceof HeaderBorder;
    }

    private static Image createImage(Component backgroundProvider, Color[] colors) {
        backgroundProvider.addHierarchyListener(theRootListener);
        BufferedImage image = ImageUtils.createVerticalGradientImage(1, backgroundProvider.getHeight(), colors);
        theBackgroundImages.put(new ImageCacheKey(backgroundProvider, colors), new SoftReference<BufferedImage>(image));
        return image;
    }

    private static Image createTabbedPaneDialogHeaderImage(int height) {
        return ImageUtils.createVerticalGradientImage(1, height, (Color[])UIManager.get("TabbedPane.dialogHeader"));
    }

    private static Image createHeaderImage(int height) {
        BufferedImage image = ImageUtils.createCompatibleOpaqueImage(1, height);
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(HEADER_TOP_COLOR);
        g2d.fillRect(0, 0, image.getWidth(), 2);
        int whiteAreaHeight = height / 3;
        Color[] colors = (Color[])UIManager.get("Panel.headerGradient");
        g2d.setPaint(new GradientPaint(0.0f, 2.0f, HEADER_TOP_COLOR, 0.0f, whiteAreaHeight - 2, colors[0]));
        g2d.fillRect(0, 2, image.getWidth(), whiteAreaHeight - 2);
        g2d.setPaint(new GradientPaint(0.0f, whiteAreaHeight, colors[0], 0.0f, height, colors[1]));
        g2d.fillRect(0, whiteAreaHeight, image.getWidth(), height);
        g2d.dispose();
        return image;
    }

    private static Image createTabbedPaneHeaderImage(int height) {
        Color[] colors = (Color[])UIManager.get("Panel.headerGradient");
        BufferedImage image = ImageUtils.createCompatibleOpaqueImage(1, height);
        Graphics2D g2d = image.createGraphics();
        int whiteAreaHeight = 89;
        g2d.setColor(HEADER_TOP_COLOR);
        g2d.fillRect(0, 0, image.getWidth(), 26);
        g2d.setPaint(new GradientPaint(0.0f, 26.0f, HEADER_TOP_COLOR, 0.0f, 89.0f, colors[0]));
        g2d.fillRect(0, 26, image.getWidth(), 89);
        g2d.setPaint(new GradientPaint(0.0f, 89.0f, colors[0], 0.0f, height, colors[1]));
        g2d.fillRect(0, 89, 1, height);
        g2d.dispose();
        return image;
    }

    private static Component getBackgroundProvider(Component container, int depth) {
        Component tempContainer = container;
        if (tempContainer instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)tempContainer)).getRootPane();
        }
        int currentDepth = 0;
        while (tempContainer != null) {
            if (tempContainer instanceof CellRendererPane) {
                return null;
            }
            if (GradientBackgroundPainter.isBackgroundProvider(tempContainer)) {
                if (currentDepth < depth) {
                    ++currentDepth;
                } else {
                    return tempContainer;
                }
            }
            tempContainer = tempContainer.getParent();
        }
        return null;
    }

    private static boolean isBackgroundProvider(Component container) {
        return container instanceof JRootPane || container instanceof JScrollPane && !Boolean.FALSE.equals(((JScrollPane)container).getClientProperty("OrangeTouch.headerGradientPainted")) || GradientBackgroundPainter.isInStandaloneTabbedPane(container) || container instanceof JOptionPane || container instanceof JPopupMenu || GradientBackgroundPainter.isBackgroundRootPanel(container);
    }

    private static class ImageCacheKey {
        private Component myRoot;
        private Color[] myColors;

        public ImageCacheKey(Component root, Color[] colors) {
            this.myRoot = root;
            this.myColors = colors;
        }

        public Component getRoot() {
            return this.myRoot;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.myColors);
            result = 31 * result + (this.myRoot == null ? 0 : this.myRoot.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImageCacheKey other = (ImageCacheKey)obj;
            if (!Arrays.equals(this.myColors, other.myColors)) {
                return false;
            }
            return !(this.myRoot == null ? other.myRoot != null : !this.myRoot.equals(other.myRoot));
        }
    }
}

