/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.painters;

import com.nokia.laf.painters.TranslucentImagePainter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;

public class GradientOutlinePainter
extends TranslucentImagePainter {
    public static final GradientOutlinePainter INSTANCE = new GradientOutlinePainter(32);

    public GradientOutlinePainter(int cacheCount) {
        super(cacheCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Component c, Graphics2D g, Color[] gradient, Shape shape, boolean isVertical) {
        Rectangle bounds = shape.getBounds();
        int imageWidth = (int)bounds.getWidth() + 1;
        int imageHeight = (int)bounds.getHeight() + 1;
        Object object = c.getTreeLock();
        synchronized (object) {
            Object[] args = new Object[]{gradient[0], gradient[1], isVertical, shape};
            this.paint(c, g, bounds.x, bounds.y, imageWidth, imageHeight, args);
        }
    }

    @Override
    protected void paintToImage(Component c, Graphics g, int width, int height, Object[] attributes) {
        Graphics2D g2 = (Graphics2D)g;
        Color[] gradient = new Color[]{(Color)attributes[0], (Color)attributes[1]};
        Shape shape = (Shape)attributes[3];
        boolean isVertical = (Boolean)attributes[2];
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Composite oldComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.Src);
        Rectangle bounds = shape.getBounds();
        g2.setColor(TRANSPARENT_COLOR);
        g2.fillRect(0, 0, width, height);
        g2.setComposite(oldComposite);
        Area area = new Area(shape);
        area.transform(AffineTransform.getTranslateInstance(-bounds.x, -bounds.y));
        if (isVertical) {
            this.drawVerticalGradientOutline(g2, gradient, bounds.height, area);
        } else {
            this.drawHorizontalGradientOutline(g2, gradient, bounds.width, area);
        }
    }

    private void drawHorizontalGradientOutline(Graphics2D g2, Color[] colors, int width, Shape area) {
        g2.setPaint(new GradientPaint(0.0f, 0.0f, colors[0], width - 1, 0.0f, colors[1]));
        g2.draw(area);
    }

    private void drawVerticalGradientOutline(Graphics2D g2, Color[] colors, int height, Shape area) {
        g2.setPaint(new GradientPaint(0.0f, 0.0f, colors[0], 0.0f, height - 1, colors[1]));
        g2.draw(area);
    }
}

