/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.painters;

import com.nokia.laf.painters.TranslucentImagePainter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;

public class GradientShapePainter
extends TranslucentImagePainter {
    public static final GradientShapePainter INSTANCE = new GradientShapePainter(32);

    public GradientShapePainter(int cacheSize) {
        super(cacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Component c, Graphics2D g, Color[] gradient, Shape shape, boolean isVertical) {
        Rectangle bounds = shape.getBounds();
        int imageWidth = bounds.width;
        int imageHeight = bounds.height;
        Object object = c.getTreeLock();
        synchronized (object) {
            Object[] args = new Object[]{gradient[0], gradient[1], isVertical, shape};
            this.paint(c, g, bounds.x, bounds.y, imageWidth, imageHeight, args);
        }
    }

    @Override
    protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
        g.setColor(TRANSPARENT_COLOR);
        Graphics2D g2 = (Graphics2D)g;
        Composite oldComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.Src);
        g2.fillRect(0, 0, w, h);
        g2.setComposite(oldComposite);
        Color[] gradient = new Color[]{(Color)args[0], (Color)args[1]};
        boolean isVertical = (Boolean)args[2];
        Shape shape = (Shape)args[3];
        Rectangle bounds = shape.getBounds();
        Area area = new Area(shape);
        area.transform(AffineTransform.getTranslateInstance(-bounds.x, -bounds.y));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (isVertical) {
            this.drawVerticalGradient(g2, gradient, area);
        } else {
            this.drawHorizontalGradient(g2, gradient, area);
        }
    }

    private void drawVerticalGradient(Graphics2D g2, Color[] colors, Shape shape) {
        int h = shape.getBounds().height;
        g2.setPaint(new GradientPaint(0.0f, 0.0f, colors[0], 0.0f, h, colors[1]));
        g2.fill(shape);
    }

    private void drawHorizontalGradient(Graphics2D g2, Color[] colors, Shape shape) {
        int w = shape.getBounds().width;
        g2.setPaint(new GradientPaint(0.0f, 0.0f, colors[0], w, 0.0f, colors[1]));
        g2.fill(shape);
    }
}

