/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.painters;

import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ImageCache {
    private int myMaxCount;
    private List<SoftReference<?>> myEntries;

    public ImageCache(int maxCount) {
        this.myMaxCount = maxCount;
        this.myEntries = new ArrayList(maxCount);
    }

    public void setMaxCount(int maxCount) {
        this.myMaxCount = maxCount;
    }

    private synchronized ImageEntry getEntry(GraphicsConfiguration config, int w, int h, Object[] attributes) {
        ImageEntry entry;
        int counter = this.myEntries.size() - 1;
        while (counter >= 0) {
            SoftReference<?> softRef = this.myEntries.get(counter);
            entry = (ImageEntry)softRef.get();
            if (entry == null) {
                this.myEntries.remove(counter);
            } else if (entry.equals(config, w, h, Arrays.asList(attributes))) {
                return entry;
            }
            --counter;
        }
        entry = new ImageEntry(config, w, h, attributes);
        if (this.myEntries.size() == this.myMaxCount) {
            this.myEntries.remove(0);
        }
        this.myEntries.add(new SoftReference<ImageEntry>(entry));
        return entry;
    }

    public Image getImage(GraphicsConfiguration config, int w, int h, Object[] args) {
        return this.getEntry(config, w, h, args).getImage();
    }

    public void setImage(GraphicsConfiguration config, int w, int h, Object[] args, Image image) {
        ImageEntry entry = this.getEntry(config, w, h, args);
        entry.setImage(image);
    }

    public static boolean equal(GeneralPath p1, GeneralPath p2) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        if (p1.getWindingRule() != p2.getWindingRule()) {
            return false;
        }
        return ImageCache.compareIterators(p1.getPathIterator(null), p2.getPathIterator(null));
    }

    public static boolean equal(Area p1, Area p2) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        PathIterator iterator1 = p1.getPathIterator(null);
        PathIterator iterator2 = p2.getPathIterator(null);
        if (iterator1.getWindingRule() != iterator2.getWindingRule()) {
            return false;
        }
        return ImageCache.compareIterators(iterator1, iterator2);
    }

    protected static boolean compareIterators(PathIterator iterator1, PathIterator iterator2) {
        double[] d1 = new double[6];
        double[] d2 = new double[6];
        boolean done = iterator1.isDone() && iterator2.isDone();
        while (!done) {
            int seg2;
            if (iterator1.isDone() != iterator2.isDone()) {
                return false;
            }
            int seg1 = iterator1.currentSegment(d1);
            if (seg1 != (seg2 = iterator2.currentSegment(d2))) {
                return false;
            }
            if (!Arrays.equals(d1, d2)) {
                return false;
            }
            iterator1.next();
            iterator2.next();
            boolean bl = done = iterator1.isDone() && iterator2.isDone();
        }
        return true;
    }

    private static class ImageEntry {
        private GraphicsConfiguration myConfig;
        private List<Object> myArgs;
        private Image myImage;
        private int myWidth;
        private int myHeight;

        public ImageEntry(GraphicsConfiguration config, int w, int h, Object[] args) {
            this.myConfig = config;
            this.myArgs = Arrays.asList(args);
            this.myWidth = w;
            this.myHeight = h;
        }

        public void setImage(Image image) {
            this.myImage = image;
        }

        public Image getImage() {
            return this.myImage;
        }

        public String toString() {
            String value = super.toString();
            StringBuffer buf = new StringBuffer(value);
            buf.append("[ graphicsConfig=");
            buf.append(this.myConfig);
            buf.append(", image=");
            buf.append(this.myImage);
            buf.append(", w=");
            buf.append(this.myWidth);
            buf.append(", h=");
            buf.append(this.myHeight);
            if (this.myArgs != null) {
                int counter = 0;
                while (counter < this.myArgs.size()) {
                    buf.append(", ");
                    buf.append(this.myArgs.get(counter));
                    ++counter;
                }
                buf.append("]");
            }
            value = buf.toString();
            return value;
        }

        public boolean equals(GraphicsConfiguration config, int w, int h, List<Object> args) {
            if (this.myWidth == w && this.myHeight == h && args.size() == this.myArgs.size() && (this.myConfig != null && this.myConfig.equals(config) || this.myConfig == null && config == null)) {
                Object last1 = args.get(args.size() - 1);
                Object last2 = this.myArgs.get(this.myArgs.size() - 1);
                if (last1 instanceof GeneralPath && last2 instanceof GeneralPath) {
                    boolean pathsEquals = ImageCache.equal((GeneralPath)last1, (GeneralPath)last2);
                    if (!pathsEquals) {
                        return false;
                    }
                    return this.myArgs.subList(0, this.myArgs.size() - 1).equals(args.subList(0, args.size() - 1));
                }
                if (last1 instanceof Area && last2 instanceof Area) {
                    boolean pathsEquals = ImageCache.equal((Area)last1, (Area)last2);
                    if (!pathsEquals) {
                        return false;
                    }
                    return this.myArgs.subList(0, this.myArgs.size() - 1).equals(args.subList(0, args.size() - 1));
                }
                return this.myArgs.equals(args);
            }
            return false;
        }
    }
}

