/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.painters;

import com.nokia.laf.painters.GradientPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class LinearGradientPainter
extends GradientPainter {
    public static final LinearGradientPainter INSTANCE = new LinearGradientPainter(16);

    public LinearGradientPainter(int cacheSize) {
        super(cacheSize);
    }

    @Override
    protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
        Graphics2D g2 = (Graphics2D)g;
        Color[] gradient = (Color[])args[0];
        boolean isVertical = (Boolean)args[1];
        if (isVertical) {
            this.drawVerticalGradient(g2, gradient, w, h);
        } else {
            this.drawHorizontalGradient(g2, gradient, w, h);
        }
    }

    private void drawVerticalGradient(Graphics2D g2, Color[] colors, int w, int h) {
        g2.setPaint(new GradientPaint(0.0f, 0.0f, colors[0], 0.0f, h - 1, colors[1]));
        g2.fillRect(0, 0, w, h);
    }

    private void drawHorizontalGradient(Graphics2D g2, Color[] colors, int w, int h) {
        g2.setPaint(new GradientPaint(0.0f, 0.0f, colors[0], w - 1, 0.0f, colors[1]));
        g2.fillRect(0, 0, w, h);
    }
}

