/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.painters;

import com.nokia.laf.painters.GradientAlphaFilter;
import com.nokia.laf.painters.TranslucentImagePainter;
import com.nokia.widgets.util.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import javax.swing.UIManager;

public class ProgressBarPainter
extends TranslucentImagePainter {
    public static final ProgressBarPainter INSTANCE = new ProgressBarPainter(16);

    public ProgressBarPainter(int cacheCount) {
        super(cacheCount);
    }

    @Override
    protected void paintToImage(Component c, Graphics g, int w, int h, Object[] attributes) {
        int tempW = w;
        int tempH = h;
        Graphics2D g2 = (Graphics2D)g;
        Color[] colors = (Color[])attributes[0];
        boolean isVertical = Boolean.TRUE.equals(attributes[1]);
        boolean isLeftToRight = Boolean.TRUE.equals(attributes[2]);
        boolean isDeterminate = Boolean.TRUE.equals(attributes[3]);
        if (isVertical) {
            g2.rotate(-1.5707963267948966);
            g2.translate(-tempH, 0);
            int oldW = tempW;
            tempW = tempH;
            tempH = oldW;
            if (isDeterminate) {
                isLeftToRight = !isLeftToRight;
            }
        }
        g.setColor(c.getBackground());
        if (isLeftToRight) {
            g.fillRect(tempW - 4, 1, 4, tempH - 1);
        } else {
            g.fillRect(0, 1, 5, tempH - 1);
        }
        g2.setPaint(new GradientPaint(0.0f, 1.0f, colors[0], 0.0f, tempH - 1, colors[1]));
        g2.fillRect(isLeftToRight ? 0 : 1, 0, tempW, tempH);
        int offset = isVertical ? 1 : 0;
        int xPos = isLeftToRight ? 0 : 4;
        int xPosEnd = tempW + offset;
        g.setColor(UIManager.getColor("ProgressBar.topBorder"));
        g.drawLine(xPos += 4, 0, xPosEnd, 0);
        if (!isDeterminate) {
            int width = tempW / 2 + 1;
            int height = tempH;
            BufferedImage image = ImageUtils.createEmptyImage(width, height, c.getBackground());
            Graphics graphics = image.getGraphics().create();
            graphics.setColor(UIManager.getColor("ProgressBar.trackShadow"));
            graphics.drawLine(0, 0, width, 0);
            graphics.dispose();
            GradientAlphaFilter filter = new GradientAlphaFilter(tempW / 2, !isLeftToRight);
            FilteredImageSource producer = new FilteredImageSource(image.getSource(), filter);
            Image img = Toolkit.getDefaultToolkit().createImage(producer);
            g.drawImage(img, isLeftToRight ? 0 : tempW / 2, 0, width, height, null);
        }
    }
}

