/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.painters;

import com.nokia.laf.NetTheme;
import java.awt.Color;
import java.awt.image.RGBImageFilter;

public class SolidColorFilter
extends RGBImageFilter {
    private int myColor = NetTheme.getHoverColor().getRGB();
    private boolean myRetainWhite = true;

    public SolidColorFilter() {
    }

    public SolidColorFilter(Color color) {
        this.myColor = color.getRGB();
    }

    public SolidColorFilter(Color color, boolean retainWhite) {
        this(color);
        this.myRetainWhite = retainWhite;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int alpha = rgb >> 24 & 0xFF;
        int r = rgb >> 0 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb >> 16 & 0xFF;
        if (this.myRetainWhite && r == 255 && g == 255 && b == 255) {
            return rgb;
        }
        return this.myColor & 0xFFFFFF | alpha << 24;
    }
}

