/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.rootpane;

import com.nokia.widgets.util.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.Timer;
import javax.swing.plaf.UIResource;

public class DimmingGlassPane
extends JComponent
implements UIResource {
    private static float MAX_ALPHA = 0.09f;
    private static float ALPHA_STEP_DIM = 0.015f;
    private static float ALPHA_STEP_UNDIM = 0.016f;
    private Component myRequestor;
    private float myAlpha = 0.0f;
    private BufferedImage myImage;
    private boolean myIsDimming = true;
    private Timer myTimer = new Timer(3, new Animator());
    private Component myOriginalGlassPane;

    public DimmingGlassPane(Component requestor, Component originalGlassPane) {
        this.setOpaque(false);
        this.myRequestor = requestor;
        this.myOriginalGlassPane = originalGlassPane;
        this.myTimer.setInitialDelay(0);
    }

    public void setRequestor(Component requestor) {
        this.myRequestor = requestor;
    }

    @Override
    public void paint(Graphics g) {
        if (this.myRequestor == null) {
            return;
        }
        if (this.myTimer.isRunning() && this.myImage != null) {
            g.drawImage(this.myImage, 0, 0, null);
        } else {
            super.paint(g);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(new Color(0.0f, 0.0f, 0.0f, Math.max(0.0f, this.myAlpha)));
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void dim() {
        this.paintRootPaneToOffScreenImage();
        JRootPane parent = (JRootPane)this.getParent();
        if (parent != null) {
            this.setSize(parent.getWidth(), parent.getHeight());
        }
        this.setVisible(true);
        this.setOpaque(true);
        this.myIsDimming = true;
        this.myTimer.restart();
    }

    public void undim() {
        this.paintRootPaneToOffScreenImage();
        this.setOpaque(true);
        this.myIsDimming = false;
        this.myAlpha = MAX_ALPHA;
        this.myTimer.restart();
    }

    public boolean isDimming() {
        return this.myIsDimming;
    }

    public void undimFinished() {
        boolean originalGlassPaneVisibility = this.myOriginalGlassPane != null ? this.myOriginalGlassPane.isVisible() : false;
        JRootPane parent = (JRootPane)this.getParent();
        if (parent != null) {
            parent.setGlassPane(this.myOriginalGlassPane);
        }
        if (this.myOriginalGlassPane != null) {
            this.myOriginalGlassPane.setVisible(originalGlassPaneVisibility);
        }
    }

    public Component getRequestor() {
        return this.myRequestor;
    }

    protected void paintRootPaneToOffScreenImage() {
        if (this.myImage == null) {
            this.createNewRootPaneImage();
        } else {
            JRootPane parent = (JRootPane)this.getParent();
            if (parent != null && this.myImage.getWidth() == parent.getWidth() && this.myImage.getHeight() == parent.getHeight()) {
                float alpha = this.myAlpha;
                this.myAlpha = 0.0f;
                Graphics gr = this.myImage.getGraphics();
                this.setOpaque(false);
                parent.paint(gr);
                this.myAlpha = alpha;
                gr.dispose();
            } else {
                this.createNewRootPaneImage();
            }
        }
    }

    private void createNewRootPaneImage() {
        float alpha = this.myAlpha;
        this.myAlpha = 0.0f;
        JRootPane parent = (JRootPane)this.getParent();
        int width = Math.max(1, parent.getWidth());
        int height = Math.max(1, parent.getHeight());
        this.myImage = ImageUtils.createCompatibleOpaqueImage(width, height);
        Graphics2D g2d = this.myImage.createGraphics();
        this.setOpaque(false);
        parent.paint(g2d);
        g2d.dispose();
        this.myAlpha = alpha;
    }

    private final class Animator
    implements ActionListener {
        private Animator() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DimmingGlassPane.this.myIsDimming) {
                if (DimmingGlassPane.this.myAlpha > MAX_ALPHA) {
                    DimmingGlassPane.this.myTimer.stop();
                    DimmingGlassPane.this.setOpaque(false);
                } else {
                    DimmingGlassPane dimmingGlassPane = DimmingGlassPane.this;
                    dimmingGlassPane.myAlpha = dimmingGlassPane.myAlpha + ALPHA_STEP_DIM;
                }
            } else if (DimmingGlassPane.this.myAlpha < 0.0f) {
                DimmingGlassPane.this.myRequestor = null;
                DimmingGlassPane.this.myTimer.stop();
                DimmingGlassPane.this.setVisible(false);
                DimmingGlassPane.this.myImage = null;
                DimmingGlassPane.this.undimFinished();
            } else {
                DimmingGlassPane dimmingGlassPane = DimmingGlassPane.this;
                dimmingGlassPane.myAlpha = dimmingGlassPane.myAlpha - ALPHA_STEP_UNDIM;
            }
            DimmingGlassPane.this.paintImmediately(0, 0, DimmingGlassPane.this.getWidth(), DimmingGlassPane.this.getHeight());
        }
    }
}

