/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.rootpane;

import com.nokia.laf.NetRootPaneUI;
import com.nokia.widgets.ResizeCorner;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class NetRootPaneLayout
implements LayoutManager {
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension titlePaneSize;
        JComponent titlePane;
        Dimension menubarSize;
        int contentPaneWidth = 0;
        int contentPanepHeight = 0;
        JRootPane root = (JRootPane)parent;
        Dimension contentPaneSize = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
        if (contentPaneSize != null) {
            contentPaneWidth = contentPaneSize.width;
            contentPanepHeight = contentPaneSize.height;
        }
        int menubarWidth = 0;
        int menubarHeight = 0;
        if (root.getJMenuBar() != null && (menubarSize = root.getJMenuBar().getPreferredSize()) != null) {
            menubarWidth = menubarSize.width;
            menubarHeight = menubarSize.height;
        }
        int titlepaneWidth = 0;
        int titlePaneHeight = 0;
        if (this.hasCustomTitlePane(root) && (titlePane = ((NetRootPaneUI)root.getUI()).getTitlePane()) != null && (titlePaneSize = titlePane.getPreferredSize()) != null) {
            titlepaneWidth = titlePaneSize.width;
            titlePaneHeight = titlePaneSize.height;
        }
        Insets insets = parent.getInsets();
        return new Dimension(Math.max(Math.max(contentPaneWidth, menubarWidth), titlepaneWidth) + insets.left + insets.right, contentPanepHeight + menubarHeight + titlePaneHeight + insets.top + insets.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension titlebarSize;
        JComponent titlePane;
        Dimension menubarSize;
        JRootPane root = (JRootPane)parent;
        int contentPaneWidth = 0;
        int contentPaneHeight = 0;
        Dimension contentPaneSize = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
        if (contentPaneSize != null) {
            contentPaneWidth = contentPaneSize.width;
            contentPaneHeight = contentPaneSize.height;
        }
        int menubarWidth = 0;
        int menubarHeight = 0;
        if (root.getJMenuBar() != null && (menubarSize = root.getJMenuBar().getMinimumSize()) != null) {
            menubarWidth = menubarSize.width;
            menubarHeight = menubarSize.height;
        }
        int titlePaneWidth = 0;
        int titlePaneHeight = 0;
        if (this.hasCustomTitlePane(root) && (titlePane = ((NetRootPaneUI)root.getUI()).getTitlePane()) != null && (titlebarSize = titlePane.getMinimumSize()) != null) {
            titlePaneWidth = titlebarSize.width;
            titlePaneHeight = titlebarSize.height;
        }
        Insets insets = parent.getInsets();
        return new Dimension(Math.max(Math.max(contentPaneWidth, menubarWidth), titlePaneWidth) + insets.left + insets.right, contentPaneHeight + menubarHeight + titlePaneHeight + insets.top + insets.bottom);
    }

    public Dimension maximumLayoutSize(Container target) {
        int maxWidth;
        Dimension titlepaneSize;
        JComponent titlePane;
        Dimension menubarSize;
        Dimension contentPaneSize;
        JRootPane root = (JRootPane)target;
        int contentPaneWidth = Integer.MAX_VALUE;
        int contentPaneHeight = Integer.MAX_VALUE;
        if (root.getContentPane() != null && (contentPaneSize = root.getContentPane().getMaximumSize()) != null) {
            contentPaneWidth = contentPaneSize.width;
            contentPaneHeight = contentPaneSize.height;
        }
        int mbWidth = Integer.MAX_VALUE;
        int mbHeight = Integer.MAX_VALUE;
        if (root.getJMenuBar() != null && (menubarSize = root.getJMenuBar().getMaximumSize()) != null) {
            mbWidth = menubarSize.width;
            mbHeight = menubarSize.height;
        }
        int tpWidth = Integer.MAX_VALUE;
        int tpHeight = Integer.MAX_VALUE;
        if (this.hasCustomTitlePane(root) && (titlePane = ((NetRootPaneUI)root.getUI()).getTitlePane()) != null && (titlepaneSize = titlePane.getMaximumSize()) != null) {
            tpWidth = titlepaneSize.width;
            tpHeight = titlepaneSize.height;
        }
        Insets insets = target.getInsets();
        int maxHeight = Math.max(Math.max(contentPaneHeight, mbHeight), tpHeight);
        if (maxHeight != Integer.MAX_VALUE) {
            maxHeight = contentPaneHeight + mbHeight + tpHeight + insets.top + insets.bottom;
        }
        if ((maxWidth = Math.max(Math.max(contentPaneWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
            maxWidth += insets.left + insets.right;
        }
        return new Dimension(maxWidth, maxHeight);
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension tpd;
        JComponent titlePane;
        JRootPane root = (JRootPane)parent;
        Rectangle bounds = root.getBounds();
        Insets insets = root.getInsets();
        int nextY = 0;
        int width = bounds.width - insets.right - insets.left;
        int height = bounds.height - insets.top - insets.bottom;
        if (root.getLayeredPane() != null) {
            root.getLayeredPane().setBounds(insets.left, insets.top, width, height);
        }
        if (root.getGlassPane() != null) {
            root.getGlassPane().setBounds(insets.left, insets.top, width, height);
        }
        if (this.hasCustomTitlePane(root) && (titlePane = ((NetRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
            int tpHeight = tpd.height;
            titlePane.setBounds(0, 0, width, tpHeight);
            nextY += tpHeight;
        }
        if (root.getJMenuBar() != null) {
            Dimension mbd = root.getJMenuBar().getPreferredSize();
            root.getJMenuBar().setBounds(0, nextY, width, mbd.height);
            nextY += mbd.height;
        }
        if (root.getContentPane() != null) {
            root.getContentPane().setBounds(0, nextY, width, height < nextY ? 0 : height - nextY);
        }
        ResizeCorner resizeCorner = ((NetRootPaneUI)root.getUI()).getResizeCorner();
        if (this.isResizeCornerShown(root)) {
            Dimension preferredSize = ((Component)resizeCorner).getPreferredSize();
            int offset = SwingUtilities.getWindowAncestor(root) instanceof Dialog ? 9 : 0;
            resizeCorner.setBounds(parent.getWidth() - preferredSize.width - offset + 1, parent.getHeight() - preferredSize.height - offset, preferredSize.width, preferredSize.height);
        } else {
            resizeCorner.setBounds(-1, -1, 0, 0);
        }
    }

    private boolean hasCustomTitlePane(JRootPane root) {
        return root.getWindowDecorationStyle() != 0 && root.getUI() instanceof NetRootPaneUI;
    }

    private boolean isResizeCornerShown(JRootPane rootPane) {
        if (!UIManager.getBoolean("OrangeTouch.resizeCornerVisible")) {
            return false;
        }
        if (!ClientPropertyUtil.booleanValue(rootPane, "OrangeTouch.resizeCornerVisible", true)) {
            return false;
        }
        if (!(rootPane.getParent() instanceof Window)) {
            return false;
        }
        Window window = SwingUtilities.getWindowAncestor(rootPane);
        if (window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            return dialog.isResizable();
        }
        if (window instanceof Frame) {
            Frame frame = (Frame)window;
            return frame.isResizable() && (frame.getExtendedState() & 6) == 0;
        }
        return false;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }
}

