/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.rootpane;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetRootPaneUI;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.buttons.CloseButton;
import com.nokia.widgets.icons.CloseIcon;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.icons.PEmptyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.UIResource;

public class NetTitlePane
extends JComponent {
    private static final DimensionUIResource DEFAULT_MINIMUM_SIZE = new DimensionUIResource(150, 55);
    private static final int IMAGE_HEIGHT = 18;
    private static final int IMAGE_WIDTH = 18;
    private PropertyChangeListener myPropertyChangeListener;
    private JMenuBar myMenuBar;
    private Action myCloseAction;
    private Action myIconifyAction;
    private Action myRestoreAction;
    private Action myMaximizeAction;
    private JButton myToggleButton;
    private JButton myIconifyButton;
    private CloseButton myCloseButton;
    private Icon myMaximizeIcon;
    private Icon myMinimizeIcon;
    private WindowListener myWindowListener;
    private Window myWindow;
    private JRootPane myRootPane;
    private int myWindowState;
    private Color myInactiveForeground = UIManager.getColor("inactiveCaptionText");
    private Color myActiveForeground = null;

    public NetTitlePane(JRootPane root, NetRootPaneUI ui) {
        this.myRootPane = root;
        this.myWindowState = -1;
        this.installSubcomponents();
        this.determineColors();
        this.installDefaults();
        this.setLayout(this.createLayout());
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void installListeners() {
        if (this.myWindow != null) {
            this.myWindowListener = this.createWindowListener();
            this.myWindow.addWindowListener(this.myWindowListener);
            this.myPropertyChangeListener = this.createWindowPropertyChangeListener();
            this.myWindow.addPropertyChangeListener(this.myPropertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.myWindow != null) {
            this.myWindow.removeWindowListener(this.myWindowListener);
            this.myWindow.removePropertyChangeListener(this.myPropertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    public JRootPane getRootPane() {
        return this.myRootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.myWindow = SwingUtilities.getWindowAncestor(this);
        if (this.myWindow != null) {
            if (this.myWindow instanceof Frame) {
                this.setState(((Frame)this.myWindow).getExtendedState());
            } else {
                this.setState(0);
            }
            if (!this.myWindow.isMinimumSizeSet()) {
                this.myWindow.setMinimumSize(DEFAULT_MINIMUM_SIZE);
            }
            this.setActive(this.myWindow.isActive());
            this.installListeners();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.myWindow = null;
    }

    private void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.createActions();
            this.myMenuBar = this.createMenuBar();
            this.add(this.myMenuBar);
            this.createButtons();
            this.add(this.myIconifyButton);
            this.add(this.myToggleButton);
            this.add(this.myCloseButton);
        } else if (decorationStyle == 2 || decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6 || decorationStyle == 7 || decorationStyle == 8) {
            this.createActions();
            this.createButtons();
            this.add(this.myCloseButton);
        }
    }

    private void determineColors() {
        switch (this.getWindowDecorationStyle()) {
            case 1: {
                this.myActiveForeground = UIManager.getColor("activeCaptionText");
                break;
            }
            case 4: {
                this.myActiveForeground = UIManager.getColor("OptionPane.errorDialog.titlePane.foreground");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.myActiveForeground = UIManager.getColor("activeCaptionText");
                break;
            }
            case 8: {
                this.myActiveForeground = UIManager.getColor("OptionPane.warningDialog.titlePane.foreground");
                break;
            }
            default: {
                this.myActiveForeground = UIManager.getColor("activeCaptionText");
            }
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    protected JMenuBar createMenuBar() {
        this.myMenuBar = new SystemMenuBar();
        this.myMenuBar.setFocusable(false);
        this.myMenuBar.setBorderPainted(true);
        this.myMenuBar.add(this.createMenu());
        return this.myMenuBar;
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.myWindowState | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.myWindowState | 6);
        }
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.myWindowState & 1) != 0) {
            frame.setExtendedState(this.myWindowState & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.myWindowState & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.myCloseAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.myIconifyAction = new IconifyAction();
            this.myRestoreAction = new RestoreAction();
            this.myMaximizeAction = new MaximizeAction();
        }
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu("");
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems();
        }
        return menu;
    }

    private void addMenuItems() {
    }

    private JButton createTitleButton() {
        JButton button = new JButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(false);
        return button;
    }

    private void createButtons() {
        this.myCloseButton = new CloseButton(16, this.myCloseAction);
        CloseIcon icon = this.myCloseButton.getIcon();
        this.myCloseButton.putClientProperty("paintActive", Boolean.TRUE);
        this.myCloseButton.setText(null);
        this.myCloseButton.putClientProperty("AccessibleName", "Close");
        Color crossColor = ((Color[])UIManager.get(this.getGradient()))[0];
        icon.setColor(crossColor);
        if (this.getWindowDecorationStyle() == 8) {
            icon.setBackgroundColor(Color.WHITE);
        } else if (this.getWindowDecorationStyle() == 4) {
            icon.setBackgroundColor(Color.WHITE);
        }
        if (this.getWindowDecorationStyle() == 1) {
            this.myMaximizeIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
            this.myMinimizeIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
            this.myIconifyButton = this.createTitleButton();
            this.myIconifyButton.setAction(this.myIconifyAction);
            this.myIconifyButton.setText(null);
            this.myIconifyButton.putClientProperty("paintActive", Boolean.TRUE);
            this.myIconifyButton.setBorder(BorderFactory.createEmptyBorder());
            this.myIconifyButton.putClientProperty("AccessibleName", "Iconify");
            this.myIconifyButton.setIcon(UIManager.getIcon("InternalFrame.iconifyIcon"));
            this.myToggleButton = this.createTitleButton();
            this.myToggleButton.setAction(this.myRestoreAction);
            this.myToggleButton.putClientProperty("paintActive", Boolean.TRUE);
            this.myToggleButton.setBorder(BorderFactory.createEmptyBorder());
            this.myToggleButton.putClientProperty("AccessibleName", "Maximize");
            this.myToggleButton.setIcon(this.myMaximizeIcon);
        }
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean isActive) {
        Boolean activeB = isActive ? Boolean.TRUE : Boolean.FALSE;
        this.myCloseButton.putClientProperty("paintActive", activeB);
        if (this.getWindowDecorationStyle() == 1) {
            this.myIconifyButton.putClientProperty("paintActive", activeB);
            this.myToggleButton.putClientProperty("paintActive", activeB);
        }
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window w = this.getWindow();
        if (w != null && this.getWindowDecorationStyle() == 1) {
            if (this.myWindowState == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 0 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    rootPane.setBorder(null);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.updateToggleButton(this.myRestoreAction, this.myMinimizeIcon);
                        this.myMaximizeAction.setEnabled(false);
                        this.myRestoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.myMaximizeAction, this.myMaximizeIcon);
                        this.myMaximizeAction.setEnabled(true);
                        this.myRestoreAction.setEnabled(false);
                    }
                    if (this.myToggleButton.getParent() == null || this.myIconifyButton.getParent() == null) {
                        this.add(this.myToggleButton);
                        this.add(this.myIconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.myToggleButton.setText(null);
                } else {
                    this.myMaximizeAction.setEnabled(false);
                    this.myRestoreAction.setEnabled(false);
                    if (this.myToggleButton.getParent() != null) {
                        this.remove(this.myToggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.myMaximizeAction.setEnabled(false);
                this.myRestoreAction.setEnabled(false);
                this.myIconifyAction.setEnabled(false);
                this.remove(this.myToggleButton);
                this.remove(this.myIconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.myCloseAction.setEnabled(true);
            this.myWindowState = state;
        }
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.myToggleButton.setAction(action);
        this.myToggleButton.setIcon(icon);
        this.myToggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.myWindow;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        GradientUtils.drawVerticalBackgroundGradient(this, g);
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        String title = this.getTitleText();
        JRootPane rootPane = this.getRootPane();
        Icon icon = new PEmptyIcon(0, 0);
        Window window = this.getWindow();
        if (this.isMessageBox()) {
            JOptionPane container = this.getOptionPane();
            icon = this.getIcon(container != null ? container : window);
        }
        GradientUtils.drawVerticalGradient((JComponent)this, g, new Color[]{Color.white, Color.white}, 0, 7, this.getWidth(), 12);
        GradientUtils.drawVerticalGradient((JComponent)this, g, new Color[]{Color.white, Color.decode("#FBFBFB")}, 0, 13, this.getWidth(), this.getHeight() - 12);
        int width = this.getWidth();
        int height = this.getHeight();
        int xOffset = 13;
        if (this.getWindowDecorationStyle() == 1) {
            xOffset += 24;
        }
        if (title != null) {
            boolean isSelected = window == null ? true : window.isActive();
            g.setFont(rootPane.getFont().deriveFont(14.0f).deriveFont(1));
            FontMetrics fm = g.getFontMetrics(rootPane.getFont().deriveFont(16.0f));
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent() + 3;
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.myIconifyButton != null && this.myIconifyButton.getParent() != null) {
                rect = this.myIconifyButton.getBounds();
            }
            if (rect.x == 0) {
                rect.x = window.getWidth() - window.getInsets().right - 30;
            }
            int titleW = rect.x - xOffset;
            title = NetUtils.getClippedText(title, fm, titleW);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            NetLookAndFeel.toggleTextAntialiasing(g);
            if (icon != null) {
                icon.paintIcon(this, g, xOffset, yOffset - icon.getIconHeight() + 2);
                if (icon.getIconWidth() > 0) {
                    xOffset += icon.getIconWidth() + 6;
                }
            }
            if (isSelected && !this.isMessageBox()) {
                g.setColor(NetTheme.getTextShadowColor());
                g.drawString(title, xOffset, yOffset + 1);
            }
            if (!NetUtils.isWarningOrErrorBox(rootPane)) {
                this.myCloseButton.getIcon().setBackgroundColor(isSelected ? null : Color.decode("#CCCCCC"));
            }
            g.setColor(isSelected ? this.myActiveForeground : this.myInactiveForeground);
            g.drawString(title, xOffset, yOffset);
            this.paintBackground(g, width, xOffset, title, fm);
        }
    }

    protected String getTitleText() {
        Object[] messages;
        JOptionPane optionPane;
        if (this.isMessageBox() && (optionPane = this.getOptionPane()) != null && optionPane.getMessage() instanceof Object[] && (messages = (Object[])optionPane.getMessage()).length > 0 && messages[0] instanceof String) {
            return messages[0].toString();
        }
        return this.getTitle();
    }

    private JOptionPane getOptionPane() {
        Container contentPane = this.getRootPane().getContentPane();
        if (contentPane.getComponentCount() > 0 && contentPane.getComponent(0) instanceof JOptionPane) {
            return (JOptionPane)contentPane.getComponent(0);
        }
        return null;
    }

    private boolean isMessageBox() {
        return NetUtils.isMessageBox(this.getRootPane());
    }

    private boolean isErrorOrWarningBox() {
        return NetUtils.isWarningOrErrorBox(this.getRootPane());
    }

    protected Icon getIcon(Container dialogContainer) {
        if (dialogContainer == null) {
            return null;
        }
        if (dialogContainer instanceof JOptionPane) {
            JOptionPane optionPane = (JOptionPane)dialogContainer;
            Icon mIcon = optionPane.getIcon();
            if (mIcon == null) {
                mIcon = this.getIconForType(optionPane.getMessageType(), optionPane);
            }
            return mIcon;
        }
        if (dialogContainer instanceof JDialog) {
            return this.getIconForType(this.getWindowDecorationStyle(), (JDialog)dialogContainer);
        }
        return null;
    }

    protected Icon getIconForType(int messageType, JOptionPane optionPane) {
        if (messageType < 0 || messageType > 3) {
            return null;
        }
        String propertyName = null;
        switch (messageType) {
            case 0: {
                propertyName = "OptionPane.errorIcon";
                break;
            }
            case 1: {
                propertyName = "OptionPane.informationIcon";
                break;
            }
            case 2: {
                propertyName = "OptionPane.warningIcon";
                break;
            }
            case 3: {
                propertyName = "OptionPane.questionIcon";
                break;
            }
        }
        if (propertyName != null) {
            return (Icon)UIManager.get(propertyName);
        }
        return null;
    }

    protected Icon getIconForType(int decorationStyle, JDialog dialog) {
        Icon mIcon = null;
        switch (decorationStyle) {
            case 4: {
                mIcon = CommonIcons.getErrorIcon();
                break;
            }
            case 3: {
                mIcon = CommonIcons.getInfoIcon();
                break;
            }
            case 8: {
                mIcon = CommonIcons.getWarningIcon();
                break;
            }
            case 7: {
                mIcon = (Icon)UIManager.get("OptionPane.questionIcon");
                break;
            }
        }
        return mIcon;
    }

    @Override
    public Dimension getPreferredSize() {
        String title = this.getTitleText();
        Font titleFont = this.getRootPane().getFont().deriveFont(14.0f).deriveFont(1);
        int titleLength = SwingUtilities.computeStringWidth(this.getFontMetrics(titleFont), title);
        Dimension result = super.getPreferredSize();
        return new Dimension(titleLength + 55 + 9 + 24, result.height);
    }

    private void paintBackground(Graphics g, int width, int xOffset, String title, FontMetrics fm) {
        boolean isSelected;
        int titleAreaLength = xOffset + fm.stringWidth(title) + 16;
        titleAreaLength = Math.max(titleAreaLength, 50);
        titleAreaLength = Math.min(titleAreaLength, this.myWindow.getWidth() - 66);
        Shape path = this.createCurvedOutline(width, titleAreaLength);
        g.setColor(UIManager.getColor("RootPane.bottomHighlight"));
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        String gradient = this.getGradient();
        GradientUtils.drawVerticalGradient((JComponent)this, g, gradient, path);
        Shape oldClip = g.getClip();
        Rectangle bounds = oldClip.getBounds();
        g.clipRect(0, 8, this.getWidth(), this.getHeight());
        g.translate(0, 1);
        GradientUtils.drawVerticalGradientOutline((JComponent)this, g, new Color[]{NetLookAndFeel.getWhite(), NetLookAndFeel.getWhite()}, path);
        g.translate(0, -1);
        g.setClip(oldClip);
        g.clipRect(0, 1, bounds.width + 1, bounds.height + 1);
        Color[] outline = (Color[])UIManager.get(this.getCurvyOutlineKey());
        GradientUtils.drawVerticalGradientOutline((JComponent)this, g, outline, path);
        g.setClip(oldClip);
        Window window = this.getWindow();
        boolean bl = isSelected = window == null ? true : window.isActive();
        if (isSelected && !this.isErrorOrWarningBox()) {
            this.paintEmphasis(g, titleAreaLength);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private void paintEmphasis(Graphics g, int width) {
        Graphics2D g2d = (Graphics2D)g;
        Shape oldClip = g.getClip();
        g.clipRect(0, 0, width + 14, 100);
        GeneralPath emphasis = new GeneralPath();
        emphasis.moveTo(0.0f, 6.0f);
        emphasis.lineTo(width + 2, 6.0f);
        int curvedAreaWidth = 38;
        int curvedAreaHeight = 14;
        emphasis.quadTo(width + curvedAreaWidth / 2 - 6, 6.0f, width + curvedAreaWidth / 2, 13 + curvedAreaHeight / 2);
        Point2D.Float start = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float end = new Point2D.Float(width + 24, 0.0f);
        float[] dist = new float[]{0.0f, 0.34f, 1.0f};
        Color[] colors = (Color[])UIManager.get("RootPane.topEmphasis");
        LinearGradientPaint p = new LinearGradientPaint(start, end, dist, colors);
        g2d.setPaint(p);
        g2d.draw(emphasis);
        g2d.translate(-1, -1);
        g2d.setColor(NetLookAndFeel.getWhite());
        g2d.draw(emphasis);
        int alpha = this.isMessageBox() ? 90 : 130;
        colors = new Color[]{NetUtils.getColor(colors[0], alpha), NetUtils.getColor(colors[1], alpha), NetUtils.getColor(colors[2], alpha)};
        p = new LinearGradientPaint(start, end, dist, colors);
        g2d.setPaint(p);
        g2d.draw(emphasis);
        g2d.translate(0, -1);
        g2d.setColor(NetLookAndFeel.getWhite());
        g2d.draw(emphasis);
        alpha = this.isMessageBox() ? 9 : 14;
        colors = new Color[]{NetUtils.getColor(colors[0], alpha), NetUtils.getColor(colors[1], alpha), NetUtils.getColor(colors[2], alpha)};
        p = new LinearGradientPaint(start, end, dist, colors);
        g2d.setPaint(p);
        g2d.draw(emphasis);
        g2d.translate(1, 2);
        g2d.setClip(oldClip);
    }

    private String getGradient() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 8) {
            return "RootPane.warningCapGradient";
        }
        if (decorationStyle == 4) {
            return "RootPane.errorCapGradient";
        }
        return "RootPane.capGradient";
    }

    private String getCurvyOutlineKey() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 8) {
            return "RootPane.warningCurvyOutline";
        }
        if (decorationStyle == 4) {
            return "RootPane.errorCurvyOutline";
        }
        return "RootPane.curvyOutline";
    }

    private Shape createCurvedOutline(int width, int titleAreaLength) {
        GeneralPath path = new GeneralPath();
        path.moveTo(-2.0f, 0.0f);
        path.lineTo(-2.0f, 6.0f);
        path.lineTo(titleAreaLength, 6.0f);
        int curvedAreaWidth = 38;
        int curvedAreaHeight = 14;
        path.quadTo(titleAreaLength + curvedAreaWidth / 2 - 6, 6.0f, titleAreaLength + curvedAreaWidth / 2, 13 + curvedAreaHeight / 2);
        path.quadTo(titleAreaLength + curvedAreaWidth / 2 + 7, 13 + curvedAreaHeight + 2, titleAreaLength + curvedAreaWidth, 13 + curvedAreaHeight);
        path.lineTo(width, 13 + curvedAreaHeight);
        path.lineTo(width, 0.0f);
        path.closePath();
        return path;
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString((Object)"MetalTitlePane.closeTitle", NetTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NetTitlePane.this.close();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString((Object)"MetalTitlePane.iconifyTitle", NetTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NetTitlePane.this.iconify();
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString((Object)"MetalTitlePane.maximizeTitle", NetTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NetTitlePane.this.maximize();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = NetTitlePane.this.getFrame();
                if (frame != null) {
                    NetTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    NetTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                NetTitlePane.this.repaint();
            } else if ("componentOrientation".equals(name)) {
                NetTitlePane.this.revalidate();
                NetTitlePane.this.repaint();
            }
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString((Object)"MetalTitlePane.restoreTitle", NetTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NetTitlePane.this.restore();
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        private SystemMenuBar() {
        }

        @Override
        public void paint(Graphics g) {
            Icon icon;
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if ((icon = UIManager.getIcon("InternalFrame.icon")) != null) {
                icon.paintIcon(this, g, 0, 0);
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(18, size.width), Math.max(size.height, 18));
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        private int computeHeight() {
            FontMetrics fm = NetTitlePane.this.myRootPane.getFontMetrics(NetTitlePane.this.myRootPane.getFont());
            int fontHeight = fm.getHeight();
            fontHeight += 14;
            int iconHeight = 0;
            if (NetTitlePane.this.getWindowDecorationStyle() == 1) {
                iconHeight = 18;
            }
            int finalHeight = Math.max(fontHeight, iconHeight);
            return finalHeight;
        }

        @Override
        public void layoutContainer(Container c) {
            int buttonWidth;
            int buttonHeight;
            boolean leftToRight = NetTitlePane.this.myWindow == null ? NetTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : NetTitlePane.this.myWindow.getComponentOrientation().isLeftToRight();
            int w = NetTitlePane.this.getWidth();
            int y = 5;
            if (NetTitlePane.this.myCloseButton != null && NetTitlePane.this.myCloseButton.getIcon() != null) {
                buttonHeight = NetTitlePane.this.myCloseButton.getIcon().getIconHeight();
                buttonWidth = NetTitlePane.this.myCloseButton.getIcon().getIconWidth();
            } else {
                buttonHeight = 18;
                buttonWidth = 18;
            }
            int x = leftToRight ? w : 0;
            int spacing = 6;
            int n = x = leftToRight ? spacing : w - buttonWidth - spacing;
            if (NetTitlePane.this.myMenuBar != null) {
                NetTitlePane.this.myMenuBar.setBounds(x, y, buttonWidth, buttonHeight);
            }
            x = leftToRight ? w : 0;
            spacing = 5;
            x += -spacing - buttonWidth;
            if (NetTitlePane.this.myCloseButton != null) {
                NetTitlePane.this.myCloseButton.setBounds(x, y, buttonWidth, buttonHeight);
            }
            if (NetTitlePane.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && NetTitlePane.this.myToggleButton.getParent() != null) {
                    spacing = 10;
                    NetTitlePane.this.myToggleButton.setBounds(x += -spacing - buttonWidth, y, buttonWidth, buttonHeight);
                }
                if (NetTitlePane.this.myIconifyButton != null && NetTitlePane.this.myIconifyButton.getParent() != null) {
                    spacing = 2;
                    NetTitlePane.this.myIconifyButton.setBounds(x += -spacing - buttonWidth, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
            }
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            NetTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            NetTitlePane.this.setActive(false);
        }
    }
}

