/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.scrollbar;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalScrollButton;

public final class NetArrowButton
extends MetalScrollButton {
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private static Color theNormalArrowColor;
    private static Color theDisabledArrowColor;
    private static int ROUNDING;

    static {
        ROUNDING = NetTheme.getNormalRounding();
        theNormalArrowColor = UIManager.getColor("ScrollBar.normalArrow");
        theDisabledArrowColor = UIManager.getColor("ScrollBar.disabledArrow");
    }

    public NetArrowButton(int direction, int width) {
        super(direction, width, true);
        this.setBorder(new NetArrowButtonBorder());
        this.setOpaque(false);
    }

    @Override
    public void paint(Graphics g) {
        Object oldAa = NetUtils.antiAliasingOn(g);
        this.paintBackground(g);
        this.paintArrowIcon(g);
        this.paintBorder(g);
        NetUtils.setAntialiasing(g, oldAa);
    }

    private void paintBackground(Graphics g) {
        int height = this.getHeight();
        int width = this.getWidth();
        g.setColor(this.getParent().isEnabled() ? NetLookAndFeel.getWhite() : NetLookAndFeel.getControl());
        JScrollPane scroll = this.getEnclosingScrollPane(this);
        boolean isInComboBopup = ClientPropertyUtil.booleanValue((JComponent)this.getParent(), "ScrollBar.comboBoxPopup");
        boolean popupAboveCombo = ClientPropertyUtil.booleanValue(scroll, "OrangeTouch.popupAboveCombo");
        Shape fill = this.getFillShape(height, width, scroll, isInComboBopup, popupAboveCombo);
        if (fill != null) {
            if (this.isVertical()) {
                GradientUtils.drawHorizontalGradient((JComponent)this, g, "ScrollPane.arrowButtonGradient", fill);
            } else {
                GradientUtils.drawVerticalGradient((JComponent)this, g, "ScrollPane.arrowButtonGradient", fill);
            }
        }
    }

    private boolean isFooterVisible(JScrollPane scroll) {
        JComponent footer = null;
        if (scroll != null) {
            footer = (JComponent)scroll.getClientProperty("OceanTouch.footerComponent");
        }
        return footer != null && footer.getHeight() > 0 && footer.isVisible();
    }

    private Shape getFillShape(int height, int width, JScrollPane scroll, boolean isInComboBopup, boolean popupAboveCombo) {
        boolean footerVisible = this.isFooterVisible(scroll);
        if (this.getDirection() == 1 && this.isUpperTrailingCornerVisible(scroll) || (this.getDirection() == 5 || this.getDirection() == 7 || this.getDirection() == 3) && footerVisible) {
            return new Rectangle2D.Double(0.0, 0.0, width, height);
        }
        if (isInComboBopup) {
            if (this.getDirection() == 1) {
                return popupAboveCombo ? NetUtils.getRoundedRect(this, 0, 0, width, height, ROUNDING, 5, 7) : new Rectangle2D.Double(0.0, 0.0, width, height - 1);
            }
            if (this.getDirection() == 5) {
                return popupAboveCombo ? new Rectangle2D.Double(0.0, 0.0, width, height) : NetUtils.getRoundedRect(this, 0, -1, width + 1, height + 1, ROUNDING, 1, 7);
            }
        } else {
            return this.getButtonShapeForFill(width, height);
        }
        return null;
    }

    private void paintArrowIcon(Graphics g) {
        int width = this.getWidth();
        int iconSize = width / 4;
        Color arrowColor = theNormalArrowColor;
        if (!this.isEnabled()) {
            arrowColor = theDisabledArrowColor;
        } else if (this.getModel().isRollover()) {
            arrowColor = NetTheme.getHoverColor();
        }
        PArrowIcon arrow = new PArrowIcon(width, iconSize, arrowColor, this.getDirection());
        arrow.paintIcon(this, g, 0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(17, 17);
    }

    private Shape getButtonShapeForFill(int width, int height) {
        JScrollPane scroll = this.getEnclosingScrollPane(this);
        boolean isEmptyViewportBorder = this.isViewportBorderEmpty(scroll);
        int buttonDirection = this.getDirection();
        if (buttonDirection == 1) {
            return isEmptyViewportBorder ? NetUtils.getRoundedRect(this, 1, 1, width - 1, height - 1, ROUNDING - 1, 5) : NetUtils.getRoundedRect(this, 1, 1, width - 1, height - 1, ROUNDING - 1, 7, 5);
        }
        if (buttonDirection == 5) {
            return isEmptyViewportBorder ? NetUtils.getRoundedRect(this, 1, 0, width - 1, height, ROUNDING, 1) : NetUtils.getRoundedRect(this, 1, 0, width - 1, height, ROUNDING, 7, 1);
        }
        if (buttonDirection == 3) {
            return isEmptyViewportBorder ? NetUtils.getRoundedRect(this, 0, 1, width, height - 1, ROUNDING, 7) : NetUtils.getRoundedRect(this, 0, 1, width, height - 1, ROUNDING, 7, 1);
        }
        return isEmptyViewportBorder ? NetUtils.getRoundedRect(this, 0, 1, width, height - 1, ROUNDING, 3) : NetUtils.getRoundedRect(this, 0, 1, width, height - 1, ROUNDING, 3, 1);
    }

    private boolean isVertical() {
        return this.getDirection() == 1 || this.getDirection() == 5;
    }

    private boolean isUpperTrailingCornerVisible(JScrollPane scroll) {
        return scroll != null && NetUtils.isNotNullAndVisible(scroll.getCorner("UPPER_TRAILING_CORNER"));
    }

    private JScrollPane getEnclosingScrollPane(Component c) {
        Container parent = c.getParent().getParent();
        if (parent instanceof JScrollPane) {
            return (JScrollPane)parent;
        }
        return null;
    }

    private boolean isViewportBorderEmpty(JScrollPane scroll) {
        if (ClientPropertyUtil.booleanValue((JComponent)this.getParent(), "ScrollBar.comboBoxPopup") || scroll == null) {
            return false;
        }
        Border viewportBorder = scroll.getViewportBorder();
        if (viewportBorder == null) {
            return true;
        }
        Insets viewportInsets = viewportBorder.getBorderInsets(scroll);
        if (viewportBorder instanceof EmptyBorder) {
            return true;
        }
        if (this.getDirection() == 5) {
            Component view = scroll.getViewport().getView();
            if (view instanceof JTable) {
                return false;
            }
            if (NetUtils.isNotNullAndVisible(scroll.getVerticalScrollBar()) && scroll.getViewportBorder() != null && scroll.getViewportBorder().getBorderInsets((Component)scroll).left > 0) {
                return false;
            }
            return viewportInsets.bottom == 0;
        }
        return viewportInsets.equals(new Insets(0, 0, 0, 0));
    }

    private class NetArrowButtonBorder
    extends AbstractBorder {
        private static final int BIG_SIZE = 1000;

        private NetArrowButtonBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 1;
            insets.left = 1;
            insets.bottom = 1;
            insets.right = 1;
            if (NetArrowButton.this.getDirection() == 1) {
                insets.top = 2;
            } else if (NetArrowButton.this.getDirection() == 5) {
                insets.bottom = 2;
            } else if (NetArrowButton.this.getDirection() == 2) {
                insets.left = 2;
            } else {
                insets.right = 2;
            }
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, ZERO_INSETS);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.translate(x, y);
            Object oldAa = NetUtils.antiAliasingOn(g);
            Color oldColor = g.getColor();
            Color borderColor = UIManager.getColor("ScrollBar.arrowBorderColor");
            JScrollPane scroll = NetArrowButton.this.getEnclosingScrollPane(c);
            boolean isTable = scroll != null && scroll.getViewport().getView() instanceof JTable;
            boolean isInComboBopup = ClientPropertyUtil.booleanValue((JComponent)NetArrowButton.this.getParent(), "ScrollBar.comboBoxPopup");
            Color outerBorderColor = isTable ? NetUtils.getTableOutlineColor(scroll) : borderColor;
            g.setColor(borderColor);
            if (isInComboBopup) {
                outerBorderColor = NetLookAndFeel.getFocusColor();
            }
            boolean isEmptyViewportBorder = NetArrowButton.this.isViewportBorderEmpty(scroll);
            Graphics2D g2d = (Graphics2D)g;
            RoundRectangle2D.Double borderShape = new RoundRectangle2D.Double(x, y, width, height, ROUNDING, ROUNDING);
            if (NetArrowButton.this.getDirection() == 1) {
                this.paintNorth(c, g2d, width, height, borderShape, borderColor, scroll, outerBorderColor, isInComboBopup, isEmptyViewportBorder);
            } else if (NetArrowButton.this.getDirection() == 5) {
                this.paintSouth(c, g2d, width, height, borderShape, borderColor, scroll, isTable, outerBorderColor, isInComboBopup, isEmptyViewportBorder);
            } else if (NetArrowButton.this.getDirection() == 3) {
                this.paintEast(g2d, scroll, width, height, borderShape, borderColor, outerBorderColor, isEmptyViewportBorder);
            } else if (NetArrowButton.this.getDirection() == 7) {
                this.paintWest(g2d, scroll, width, height, borderShape, borderColor, outerBorderColor, isEmptyViewportBorder);
            }
            g.translate(-x, -y);
            g.setColor(oldColor);
            NetUtils.setAntialiasing(g, oldAa);
        }

        private void paintNorth(Component c, Graphics2D g, int width, int height, RectangularShape borderShape, Color borderColor, JScrollPane scroll, Color outerBorderColor, boolean isInComboBopup, boolean isEmptyViewportBorder) {
            g.setColor(borderColor);
            if (isInComboBopup) {
                this.paintComboBoxPopupNorthButton(g, scroll, width, height, outerBorderColor);
            } else {
                if (NetArrowButton.this.isUpperTrailingCornerVisible(scroll)) {
                    this.paintTableNorthButton(g, width, height, borderShape);
                } else {
                    this.paintRegularNorthButton(c, g, width, height, borderShape, isEmptyViewportBorder);
                }
                g.setColor(outerBorderColor);
            }
        }

        private void paintComboBoxPopupNorthButton(Graphics2D g, JScrollPane scroll, int width, int height, Color outerBorderColor) {
            g.drawLine(0, 0, 0, height - 1);
            g.setColor(outerBorderColor);
            boolean popupAboveCombo = ClientPropertyUtil.booleanValue(scroll, "OrangeTouch.popupAboveCombo");
            if (popupAboveCombo) {
                Shape outline = NetUtils.getRoundedRect(NetArrowButton.this, -1, 0, width + 1, height + 1, ROUNDING, 5, 7);
                g.draw(outline);
            } else {
                g.drawLine(width - 1, 0, width - 1, height - 1);
                g.drawLine(0, 0, width - 1, 0);
            }
        }

        private void paintTableNorthButton(Graphics2D g, int width, int height, RectangularShape myBorderShape) {
            myBorderShape.setFrame(-1000.0, -1000.0, 1000 + width - 1, height + 2000);
            Color oldColor = g.getColor();
            g.setColor(UIManager.getColor("ScrollBar.NormalBorder"));
            g.draw(myBorderShape);
            g.drawLine(0, 0, 0, height - 1);
            g.setColor(oldColor);
        }

        private void paintRegularNorthButton(Component c, Graphics2D g, int width, int height, RectangularShape myBorderShape, boolean isEmptyViewportBorder) {
            if (isEmptyViewportBorder) {
                myBorderShape.setFrame(0.0, 0.0, width - 1, height + 1000);
                g.draw(myBorderShape);
            } else {
                Shape buttonShape = NetUtils.getRoundedRect((JComponent)c, 0, 0, NetArrowButton.this.getWidth(), NetArrowButton.this.getHeight() + 1, ROUNDING, 7, 5);
                GradientUtils.drawVerticalGradientOutline((JComponent)c, (Graphics)g, "ScrollBar.arroButtonOutlineGradient", buttonShape);
                g.drawLine(0, 1, 0, height - 1);
            }
        }

        private void paintSouth(Component c, Graphics2D g, int width, int height, RectangularShape borderShape, Color borderColor, JScrollPane scroll, boolean isTable, Color outerBorderColor, boolean isInComboBopup, boolean isEmptyViewportBorder) {
            Color[] scrollPaneOutline = (Color[])UIManager.get("ScrollPane.outline");
            Shape buttonShape = NetUtils.getRoundedRect((JComponent)c, 0, -1, NetArrowButton.this.getWidth(), NetArrowButton.this.getHeight() + 1, ROUNDING, 7, 1);
            if (NetArrowButton.this.isFooterVisible(scroll)) {
                buttonShape = new Rectangle2D.Double(0.0, -1.0, NetArrowButton.this.getWidth() - 1, NetArrowButton.this.getHeight());
            }
            if (isEmptyViewportBorder) {
                borderShape.setFrame(0.0, -1000.0, width - 1, height + 1000 - 1);
                g.setColor(outerBorderColor);
                g.draw(borderShape);
            } else if (isTable) {
                g.setColor(NetUtils.getTableOutlineColor(scroll));
                g.draw(buttonShape);
            } else if (isInComboBopup) {
                g.setColor(NetLookAndFeel.getFocusColor());
                boolean popupAboveCombo = ClientPropertyUtil.booleanValue(scroll, "OrangeTouch.popupAboveCombo");
                if (popupAboveCombo) {
                    buttonShape = new Rectangle2D.Double(-1.0, -1.0, width, height);
                }
                g.draw(buttonShape);
            } else {
                GradientUtils.drawVerticalGradientOutline((JComponent)c, (Graphics)g, new Color[]{UIManager.getColor("ScrollBar.arrowBorderColor"), scrollPaneOutline[1]}, buttonShape);
            }
            g.setColor(borderColor);
            if (!isEmptyViewportBorder) {
                g.drawLine(0, 0, 0, height - 2);
            }
        }

        private void paintEast(Graphics2D g, JScrollPane scroll, int width, int height, RectangularShape borderShape, Color borderColor, Color outerBorderColor, boolean isEmptyViewportBorder) {
            g.setColor(outerBorderColor);
            if (NetArrowButton.this.isFooterVisible(scroll)) {
                g.drawRect(-1, 0, NetArrowButton.this.getWidth(), NetArrowButton.this.getHeight() - 1);
                return;
            }
            int yOverflow = isEmptyViewportBorder ? 0 : 1000;
            borderShape.setFrame(-1000.0, -yOverflow, 1000 + width - 1, height + yOverflow - 1);
            g.draw(borderShape);
            if (!isEmptyViewportBorder) {
                g.setColor(borderColor);
                g.drawLine(0, 0, width - 2, 0);
            }
        }

        private void paintWest(Graphics2D g, JScrollPane scroll, int width, int height, RectangularShape borderShape, Color borderColor, Color outerBorderColor, boolean isEmptyViewportBorder) {
            g.setColor(outerBorderColor);
            if (NetArrowButton.this.isFooterVisible(scroll)) {
                g.drawRect(0, 0, NetArrowButton.this.getWidth(), NetArrowButton.this.getHeight() - 1);
                return;
            }
            int yOverflow = isEmptyViewportBorder ? 0 : 1000;
            borderShape.setFrame(0.0, -yOverflow, width + 1000, height + yOverflow - 1);
            g.draw(borderShape);
            if (!isEmptyViewportBorder) {
                g.setColor(borderColor);
                g.drawLine(1, 0, width - 1, 0);
            }
        }
    }
}

