/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.scrollbar;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.JumpScrollable;
import com.nokia.widgets.icons.PArrowIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class NetScrollPaneLayout
extends ScrollPaneLayout
implements UIResource,
ActionListener {
    private static final int JUMP_SCROLL_BUTTON_HEIGHT = 12;
    JumpScrollButton myUpJumpScrollButton;
    JumpScrollButton myDownJumpScrollButton;
    private boolean showJumpScroll = false;
    private JViewport myOriginalViewport;

    public void setShowJumpScroll(boolean showJumpScroll) {
        this.showJumpScroll = showJumpScroll;
    }

    public boolean getShowJumpScroll() {
        return this.showJumpScroll;
    }

    public void uninstallDefaults() {
        if (this.myUpJumpScrollButton != null) {
            this.myUpJumpScrollButton.remove();
        }
        if (this.myDownJumpScrollButton != null) {
            this.myDownJumpScrollButton.remove();
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        this.createDummyViewportForReceivingCallsToSetBounds();
        this.performActualLayoutContainer(parent);
        this.copyBoundsFromDummyAndRestoreOriginalViewport();
    }

    private void createDummyViewportForReceivingCallsToSetBounds() {
        this.myOriginalViewport = this.viewport;
        this.viewport = new ViewportWrapper(this.myOriginalViewport);
    }

    private void copyBoundsFromDummyAndRestoreOriginalViewport() {
        this.myOriginalViewport.setBounds(this.viewport.getBounds());
        this.viewport = this.myOriginalViewport;
    }

    private void performActualLayoutContainer(Container parent) {
        super.layoutContainer(parent);
        JScrollPane scroll = (JScrollPane)parent;
        boolean jumpScrollable = this.viewport != null && this.viewport.getView() instanceof JumpScrollable;
        this.addOrRemoveJumpScrollButtons(scroll, jumpScrollable);
        JComponent footer = (JComponent)scroll.getClientProperty("OceanTouch.footerComponent");
        int footerHeight = this.getFooterHeight(footer);
        if (NetUtils.isNotNullAndVisible(this.vsb) || footerHeight > 0) {
            this.adjustViewport(scroll, footerHeight);
            this.adjustVerticalScrollBar(scroll, footerHeight);
            if (NetUtils.isNotNullAndVisible(this.vsb) && jumpScrollable && this.getShowJumpScroll()) {
                this.layoutJumpScrollButtons();
            }
        } else if (jumpScrollable) {
            this.hideJumpScrollButtons();
        }
        this.layoutFooter(scroll, footer);
        this.adjustHorizontalScrollBar(footer);
    }

    private void adjustViewport(JScrollPane scroll, int footerHeight) {
        Rectangle viewportBounds = this.viewport.getBounds();
        if (NetUtils.isNotNullAndVisible(this.vsb) && scroll.getViewportBorder() != null && scroll.getViewportBorder().getBorderInsets((Component)scroll).left > 0) {
            ++viewportBounds.width;
        }
        if (footerHeight > 0) {
            viewportBounds.height -= footerHeight;
        } else if (NetUtils.isNotNullAndVisible(scroll.getHorizontalScrollBar()) && scroll.getViewportBorder() != null) {
            viewportBounds.height += scroll.getViewportBorder().getBorderInsets((Component)scroll).bottom;
        }
        this.viewport.setBounds(viewportBounds);
    }

    private void adjustVerticalScrollBar(JScrollPane scroll, int footerHeight) {
        Rectangle bounds = this.vsb.getBounds();
        if (footerHeight > 0) {
            Insets vpInsets = scroll.getViewportBorder().getBorderInsets(scroll);
            bounds.height -= footerHeight + vpInsets.bottom - 1;
        }
        if (NetUtils.isNotNullAndVisible(this.hsb) && this.lowerRight == null) {
            ++bounds.height;
        }
        this.vsb.setBounds(bounds);
    }

    private void adjustHorizontalScrollBar(Component footer) {
        if (NetUtils.isNotNullAndVisible(this.hsb)) {
            Rectangle bounds = this.hsb.getBounds();
            if (NetUtils.isNotNullAndVisible(this.vsb) && this.lowerRight == null) {
                ++bounds.width;
            }
            if (NetUtils.isNotNullAndVisible(footer)) {
                bounds.y = footer.getY() - bounds.height + 1;
            }
            this.hsb.setBounds(bounds);
        }
    }

    private void layoutFooter(JScrollPane scroll, JComponent footer) {
        int footerHeight = this.getFooterHeight(footer);
        if (footerHeight > 0) {
            Insets insets = scroll.getInsets();
            Insets vpInsets = scroll.getViewportBorder().getBorderInsets(scroll);
            int totalInsetsLeft = insets.left + vpInsets.left;
            int totalInsetsRight = insets.right + vpInsets.right;
            footer.setBounds(insets.left + vpInsets.left, scroll.getHeight() - (vpInsets.bottom + insets.bottom) - footerHeight, scroll.getWidth() - (totalInsetsLeft + totalInsetsRight), footerHeight);
        } else if (footer != null) {
            footer.setBounds(-1, -1, 0, 0);
        }
    }

    private int getFooterHeight(JComponent footer) {
        return footer != null && footer.isVisible() ? footer.getPreferredSize().height : 0;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension result = super.preferredLayoutSize(parent);
        JScrollPane scroll = (JScrollPane)parent;
        JComponent footer = (JComponent)scroll.getClientProperty("OceanTouch.footerComponent");
        if (footer != null && footer.isVisible()) {
            result.height += footer.getPreferredSize().height;
        }
        return result;
    }

    private void addOrRemoveJumpScrollButtons(JScrollPane scroll, boolean jumpScrollable) {
        if (jumpScrollable) {
            if (this.myUpJumpScrollButton == null) {
                this.myDownJumpScrollButton = new JumpScrollButton(1, this);
                scroll.add(this.myDownJumpScrollButton);
                this.myUpJumpScrollButton = new JumpScrollButton(-1, this);
                scroll.add(this.myUpJumpScrollButton);
            }
        } else if (this.myUpJumpScrollButton != null) {
            this.myUpJumpScrollButton.remove();
            this.myUpJumpScrollButton = null;
            this.myDownJumpScrollButton.remove();
            this.myDownJumpScrollButton = null;
        }
    }

    private void layoutJumpScrollButtons() {
        Rectangle vsbBounds = this.vsb.getBounds();
        vsbBounds.height -= 24;
        this.vsb.setBounds(vsbBounds);
        Rectangle jumpScrollButtonBounds = new Rectangle(vsbBounds.x, vsbBounds.y + vsbBounds.height, (int)vsbBounds.getWidth(), 12);
        this.myUpJumpScrollButton.setBounds(jumpScrollButtonBounds);
        jumpScrollButtonBounds.y += 12;
        this.myDownJumpScrollButton.setBounds(jumpScrollButtonBounds);
        JumpScrollable jumpScrollable = (JumpScrollable)((Object)this.viewport.getView());
        this.myUpJumpScrollButton.setToolTipText(jumpScrollable.getTooltipText(-1));
        this.myDownJumpScrollButton.setToolTipText(jumpScrollable.getTooltipText(1));
    }

    private void hideJumpScrollButtons() {
        if (this.myUpJumpScrollButton != null) {
            this.myUpJumpScrollButton.setHidden();
        }
        if (this.myDownJumpScrollButton != null) {
            this.myDownJumpScrollButton.setHidden();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.viewport.getView() instanceof JumpScrollable) {
            int direction = 0;
            if (e.getSource() == this.myUpJumpScrollButton) {
                direction = -1;
            } else if (e.getSource() == this.myDownJumpScrollButton) {
                direction = 1;
            }
            if (direction == 0) {
                return;
            }
            int increment = ((JumpScrollable)((Object)this.viewport.getView())).getJumpScrollIncrement(this.viewport.getViewRect(), direction);
            Dimension viewSize = this.viewport.getViewSize();
            Point viewPosition = this.viewport.getViewPosition();
            double maxViewYPos = viewSize.getHeight() - (double)this.viewport.getHeight();
            if (direction > 0) {
                if ((double)(viewPosition.y + increment) > maxViewYPos) {
                    increment = (int)(maxViewYPos - (double)viewPosition.y);
                }
                viewPosition.y += increment;
            } else {
                if (viewPosition.y - increment < 0) {
                    increment = viewPosition.y;
                }
                viewPosition.y -= increment;
            }
            this.viewport.setViewPosition(viewPosition);
        }
    }

    private static class JumpScrollButton
    extends JButton {
        private static final PArrowIcon UP_ARROW = new PArrowIcon(8, 4, UIManager.getColor("ScrollBar.normalArrow"), 1);
        private static final PArrowIcon DOWN_ARROW = new PArrowIcon(8, 4, UIManager.getColor("ScrollBar.normalArrow"));
        private ActionListener myListener;

        public JumpScrollButton(int direction, ActionListener listener) {
            this.setIcon(direction < 0 ? UP_ARROW : DOWN_ARROW);
            this.setFocusable(false);
            this.setDefaultCapable(false);
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setBackground(new Color(240, 240, 240));
            this.myListener = listener;
            this.addActionListener(this.myListener);
        }

        public void setHidden() {
            this.setBounds(-1, -1, 0, 0);
        }

        public void remove() {
            if (this.getParent() != null) {
                this.getParent().remove(this);
                this.removeActionListener(this.myListener);
            }
        }
    }

    private class ViewportWrapper
    extends JViewport {
        private JViewport myWrappedViewport;

        public ViewportWrapper(JViewport viewportToWrap) {
            this.myWrappedViewport = viewportToWrap;
        }

        @Override
        public Component getView() {
            if (this.myWrappedViewport == null) {
                return null;
            }
            return this.myWrappedViewport.getView();
        }
    }
}

