/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.scrollbar;

import com.nokia.laf.NetTheme;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class NetScrollPaneViewportBorder
extends AbstractBorder
implements UIResource {
    private static boolean clearOppositeBorder(JComponent component) {
        return NetUtils.isNotNullAndVisible(component) && Boolean.TRUE.equals(component.getClientProperty("clearOppositeBorder"));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        boolean clearTopBorder;
        JScrollPane scroll = (JScrollPane)c;
        if (scroll == null) {
            return insets;
        }
        Component view = scroll.getViewport().getView();
        if (view instanceof JPanel && ((JPanel)view).getBorder() instanceof TitledBorder || scroll.getParent() instanceof JSplitPane) {
            insets.right = insets.left = view instanceof JTable ? 1 : 0;
            insets.top = 0;
            insets.bottom = 0;
            return insets;
        }
        if (view instanceof JTable) {
            JTable table = (JTable)view;
            if (ComponentUtils.isStandalone((JComponent)view)) {
                insets.top = NetUtils.isNotNullAndVisible(table.getTableHeader()) ? 1 : 5;
                insets.bottom = 5;
                insets.left = 1;
                insets.right = 1;
            } else {
                insets.top = 0;
                insets.bottom = 0;
                insets.left = 0;
                insets.right = 0;
            }
        } else {
            insets.top = 5;
            insets.bottom = 5;
            insets.left = 1;
            insets.right = 1;
        }
        boolean bl = clearTopBorder = scroll.getColumnHeader() != null && NetScrollPaneViewportBorder.clearOppositeBorder((JComponent)scroll.getColumnHeader().getView());
        if (clearTopBorder) {
            insets.top = 0;
        }
        return insets;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        JScrollPane scroll = (JScrollPane)c;
        Component view = scroll.getViewport().getView();
        if (view == null || view instanceof JPanel && ((JPanel)view).getBorder() instanceof TitledBorder || scroll.getParent() instanceof JSplitPane) {
            return;
        }
        int borderWidth = width;
        int borderHeight = height;
        int rounding = NetTheme.getSmallRounding();
        JComponent footer = (JComponent)scroll.getClientProperty("OceanTouch.footerComponent");
        if (NetScrollPaneViewportBorder.clearOppositeBorder(scroll.getVerticalScrollBar())) {
            borderWidth = NetUtils.isNotNullAndVisible(footer) ? (borderWidth += 17) : (borderWidth += 10);
        }
        if (NetScrollPaneViewportBorder.clearOppositeBorder(scroll.getHorizontalScrollBar())) {
            borderHeight = NetUtils.isNotNullAndVisible(footer) ? (borderHeight += footer.getHeight() - 4) : (borderHeight += 10);
        }
        Object oldAa = NetUtils.antiAliasingOn(g);
        g.translate(x, y);
        this.fillTopAndBottomCaps(g, scroll, view, width, height);
        if (ClientPropertyUtil.booleanValue(scroll, "OceanTouch.paintBorderOutline", true)) {
            this.paintOutline(g, scroll, view, x, y, width, height, borderWidth, borderHeight, rounding);
        }
        g.translate(-x, -y);
        NetUtils.setAntialiasing(g, oldAa);
    }

    private void fillTopAndBottomCaps(Graphics g, JScrollPane scroll, Component view, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        if (view instanceof JList || view instanceof JTree || view instanceof JTextComponent) {
            g2d.setColor(view.getBackground());
            g2d.fill(this.getBottomCap(scroll, width, height));
            Shape topCap = this.getTopCap(scroll, width);
            g2d.fill(topCap);
            g2d.setColor(UIManager.getColor("TextField.topHighlight"));
            g2d.draw(topCap);
        } else if (view instanceof JTable) {
            this.fillCapsForTable(g2d, scroll, view, width, height);
        } else {
            this.fillCapForPanel(g2d, scroll, view, this.getTopCap(scroll, width));
            this.fillCapForPanel(g2d, scroll, view, this.getBottomCap(scroll, width, height));
        }
    }

    private void fillCapsForTable(Graphics2D g, JScrollPane scroll, Component view, int width, int height) {
        int rounding = NetTheme.getComponentOutlineRounding(scroll);
        g.setColor(((Color[])UIManager.get("Dialog.background"))[1]);
        g.drawLine(2, height - 2, width - 3, height - 2);
        JTable table = (JTable)view;
        Shape bottomCap = this.getBottomCap(scroll, width, height);
        Shape topCap = NetUtils.getRoundedRect(scroll, 1, 1, width - 1, rounding / 2, rounding, 5);
        if (!NetUtils.isNotNullAndVisible(table.getTableHeader())) {
            NetUtils.paintTableBackgroundFilter(g, table, topCap);
        }
        if (!(table.getBackground() instanceof UIResource)) {
            Color oldColor = g.getColor();
            g.setColor(scroll.getViewport().getView().getBackground());
            g.fill(bottomCap);
            if (!NetUtils.isNotNullAndVisible(table.getTableHeader())) {
                g.fill(topCap);
            }
            g.setColor(oldColor);
        } else if (table.getColumnCount() == 1 && table.getRowCount() > 0 && table.getColumnCount() > 0 && table.isCellEditable(0, 0)) {
            g.setColor(table.getBackground());
            g.fill(bottomCap);
        } else {
            JComponent footer = (JComponent)scroll.getClientProperty("OceanTouch.footerComponent");
            if (NetUtils.isNotNullAndVisible(footer)) {
                g.setColor(((Color[])UIManager.get("Footer.gradient"))[1]);
                JScrollBar vsb = scroll.getVerticalScrollBar();
                int vsbWidth = vsb != null && vsb.isVisible() ? vsb.getWidth() : 0;
                Shape filterBottom = NetUtils.getRoundedRect(scroll, 1, height - 5, width + vsbWidth, 5, 10, 1);
                g.fill(filterBottom);
            } else {
                GradientUtils.drawVerticalBackgroundGradient(scroll.getViewport(), g, bottomCap, 1);
                NetUtils.paintTableBackgroundFilter(g, table, bottomCap);
            }
        }
    }

    private void fillCapForPanel(Graphics2D g, JScrollPane scroll, Component view, Shape topCap) {
        g.setColor(view.getBackground());
        if (!(view.getBackground() instanceof UIResource) || ClientPropertyUtil.intValue((JComponent)view, "panelType") == ClientProperties.PANEL_USER_FOREGROUND) {
            g.fill(topCap);
        } else {
            GradientUtils.drawVerticalBackgroundGradient((Container)scroll, (Graphics)g, topCap);
        }
    }

    private void paintOutline(Graphics g, JScrollPane scroll, Component view, int x, int y, int width, int height, int borderWidth, int borderHeight, int rounding) {
        boolean paintTopBorder = NetScrollPaneViewportBorder.isTopBorderPainted(scroll);
        Shape outline = paintTopBorder ? NetUtils.getOutline(scroll, 0, 0, borderWidth - 1, borderHeight - 1) : NetUtils.getRoundedPath(scroll, 0, 0, borderWidth, borderHeight, rounding, 1, true);
        boolean isInOverflow = ClientPropertyUtil.booleanValue(scroll, "OrangeTouch.isInOverflowPopup");
        if (isInOverflow) {
            outline = NetUtils.getOutline(scroll, 0, 0, borderWidth - 1, borderHeight + 1);
            this.paintOverflowPopupOutline(g, x, y, scroll, outline);
        } else if (view instanceof JTable) {
            outline = paintTopBorder ? NetUtils.getOutline(scroll, 0, 0, borderWidth - 1, borderHeight - 1) : NetUtils.getRoundedPath(scroll, 0, 0, borderWidth, borderHeight, 10, 1, true);
            g.setColor(NetUtils.getTableOutlineColor(scroll));
            ((Graphics2D)g).draw(outline);
        } else {
            this.paintMainOutline(g, scroll, outline, width, height);
        }
        if (scroll.getParent() instanceof JTabbedPane) {
            this.paintTabbedPaneOutline(g, height, scroll);
        }
    }

    private void paintMainOutline(Graphics g, JScrollPane scroll, Shape outline, int width, int height) {
        Shape oldClip = g.getClip();
        if (NetUtils.isNotNullAndVisible(scroll.getVerticalScrollBar()) && NetUtils.isNotNullAndVisible(scroll.getHorizontalScrollBar())) {
            g.clipRect(0, 0, width, height);
        }
        GradientUtils.drawVerticalGradientOutline((JComponent)scroll, g, "ScrollPane.outline", outline);
        g.setClip(oldClip);
    }

    private void paintOverflowPopupOutline(Graphics g, int x, int y, JScrollPane scroll, Shape outline) {
        Shape tempOutline = outline;
        JPopupMenu popup = (JPopupMenu)SwingUtilities.getAncestorOfClass(JPopupMenu.class, scroll);
        Rectangle overflowBounds = (Rectangle)scroll.getClientProperty("OrangeTouch.overflowBounds");
        Component invoker = popup.getInvoker();
        Point overflowLocation = overflowBounds.getLocation();
        SwingUtilities.convertPointToScreen(overflowLocation, invoker);
        Point popupLocation = popup.getLocationOnScreen();
        int relativePopupXLocation = overflowLocation.x - popupLocation.x - 4;
        if (overflowLocation.y + overflowBounds.height == popupLocation.y && relativePopupXLocation == 0) {
            tempOutline = new Area(tempOutline);
            ((Area)tempOutline).add(new Area(new Rectangle(x, y, 10, 10)));
        }
        GradientUtils.drawVerticalGradientOutline((JComponent)scroll, g, "ScrollPane.outline", tempOutline);
        if (overflowLocation.y + overflowBounds.height == popupLocation.y) {
            g.setColor(UIManager.getColor("ComboBox.background"));
            g.drawLine(relativePopupXLocation + 1, y, (int)((double)relativePopupXLocation + overflowBounds.getWidth()) - 2, y);
        }
    }

    private void paintTabbedPaneOutline(Graphics g, int height, JScrollPane scroll) {
        JTabbedPane tabPane = (JTabbedPane)scroll.getParent();
        TabbedPaneUI ui = tabPane.getUI();
        Rectangle rect = ui.getTabBounds(tabPane, tabPane.getSelectedIndex());
        Rectangle tabRect = SwingUtilities.convertRectangle(tabPane, rect, scroll);
        g.setColor(tabPane.getBackground());
        switch (tabPane.getTabPlacement()) {
            case 1: {
                if (tabRect.y + tabRect.height > 0) {
                    g.drawLine(tabRect.x + 1, 0, tabRect.x + tabRect.width - 2, 0);
                }
                g.drawLine(0, height, 0, height);
                break;
            }
            case 3: {
                if (height - tabRect.y <= 0) break;
                g.drawLine(tabRect.x + 1, height - 1, tabRect.x + tabRect.width - 2, height - 1);
                break;
            }
            case 2: {
                if (tabRect.x + tabRect.width <= 0) break;
                g.drawLine(0, tabRect.y + 1, 0, tabRect.y + tabRect.height - 2);
                break;
            }
        }
    }

    private static boolean isTopBorderPainted(JScrollPane scroll) {
        return scroll.getColumnHeader() == null || !NetScrollPaneViewportBorder.clearOppositeBorder((JComponent)scroll.getColumnHeader().getView());
    }

    private Shape getBottomCap(JScrollPane scroll, int width, int height) {
        return NetUtils.isNotNullAndVisible(scroll.getVerticalScrollBar()) ? NetUtils.getRoundedRect(scroll, 1, height - 5, width, 5, 10, 1, 3) : NetUtils.getRoundedRect(scroll, 1, height - 5, width - 1, 5, 10, 1);
    }

    private Shape getTopCap(JScrollPane scroll, int width) {
        return NetUtils.isNotNullAndVisible(scroll.getVerticalScrollBar()) ? NetUtils.getRoundedRect(scroll, 1, 1, width, 5, 10, 5, 3) : NetUtils.getRoundedRect(scroll, 1, 1, width - 1, 5, 10, 5);
    }
}

