/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.tabbedpane;

import com.nokia.widgets.TabCloseEvent;
import com.nokia.widgets.TabCloseListener;
import java.util.Set;
import javax.swing.JTabbedPane;

public class TabCloseListenerSupport {
    private JTabbedPane myTabbedPane;

    public TabCloseListenerSupport(JTabbedPane tabbedPane) {
        this.myTabbedPane = tabbedPane;
    }

    public void closeTab(int tabIndex) {
        if (this.canCloseTab(tabIndex)) {
            this.myTabbedPane.remove(tabIndex);
            this.fireTabClosed(tabIndex);
        }
    }

    private boolean canCloseTab(int tabIndex) {
        Set<TabCloseListener> closeListeners = this.getCloseListeners();
        if (closeListeners == null) {
            return true;
        }
        TabCloseEvent event = new TabCloseEvent(this.myTabbedPane, tabIndex);
        for (TabCloseListener tabCloseListener : closeListeners) {
            if (tabCloseListener.tabClosing(event)) continue;
            return false;
        }
        return true;
    }

    private void fireTabClosed(int tabIndex) {
        Set<TabCloseListener> closeListeners = this.getCloseListeners();
        if (closeListeners == null) {
            return;
        }
        TabCloseEvent event = new TabCloseEvent(this.myTabbedPane, tabIndex);
        for (TabCloseListener tabCloseListener : closeListeners) {
            tabCloseListener.tabClosed(event);
        }
    }

    private Set<TabCloseListener> getCloseListeners() {
        Set closeListeners = (Set)this.myTabbedPane.getClientProperty("OrangeTouch.tabCloseListeners");
        return closeListeners;
    }
}

